/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import jaws.corePackage.SpecialFunctions;
import jaws.corePackage.Statistics;
import jaws.corePackage.Utils;

public class ContingencyTables {
    private static double log2 = Math.log(2.0);

    public static double chiSquared(double[][] dArray, boolean bl) {
        int n = (dArray.length - 1) * (dArray[0].length - 1);
        return Statistics.chiSquaredProbability(ContingencyTables.chiVal(dArray, bl), n);
    }

    public static double chiVal(double[][] dArray, boolean bl) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = true;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n3];
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + dArray[n4][n];
                int n6 = n;
                dArray3[n6] = dArray3[n6] + dArray[n4][n];
                d3 += dArray[n4][n];
                ++n;
            }
            ++n4;
        }
        int n7 = (n2 - 1) * (n3 - 1);
        if (n7 > 1 || !bl) {
            bl2 = false;
        } else if (n7 <= 0) {
            return 0.0;
        }
        d2 = 0.0;
        n4 = 0;
        while (n4 < n2) {
            if (Utils.gr(dArray2[n4], 0.0)) {
                n = 0;
                while (n < n3) {
                    if (Utils.gr(dArray3[n], 0.0)) {
                        d = dArray3[n] * dArray2[n4] / d3;
                        d2 += ContingencyTables.chiCell(dArray[n4][n], d, bl2);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        return d2;
    }

    public static boolean cochransCriterion(double[][] dArray) {
        int n;
        double d = 0.0;
        double d2 = 5.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n6];
        int n7 = 0;
        while (n7 < n5) {
            n = 0;
            while (n < n6) {
                int n8 = n7;
                dArray2[n8] = dArray2[n8] + dArray[n7][n];
                int n9 = n;
                dArray3[n9] = dArray3[n9] + dArray[n7][n];
                d += dArray[n7][n];
                ++n;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n5) {
            if (Utils.gr(dArray2[n7], 0.0)) {
                ++n3;
            }
            ++n7;
        }
        n = 0;
        while (n < n6) {
            if (Utils.gr(dArray3[n], 0.0)) {
                ++n4;
            }
            ++n;
        }
        n7 = 0;
        while (n7 < n5) {
            if (Utils.gr(dArray2[n7], 0.0)) {
                n = 0;
                while (n < n6) {
                    double d3;
                    if (Utils.gr(dArray3[n], 0.0) && Utils.sm(d3 = dArray3[n] * dArray2[n7] / d, d2)) {
                        if (Utils.sm(d3, 1.0)) {
                            return false;
                        }
                        if ((double)(++n2) > (double)(n3 * n4) / d2) {
                            return false;
                        }
                    }
                    ++n;
                }
            }
            ++n7;
        }
        return true;
    }

    public static double CramersV(double[][] dArray) {
        int n;
        double d = 0.0;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                d += dArray[n4][n5];
                ++n5;
            }
            ++n4;
        }
        int n6 = n = n2 < n3 ? n2 - 1 : n3 - 1;
        if (n == 0 || Utils.eq(d, 0.0)) {
            return 0.0;
        }
        return Math.sqrt(ContingencyTables.chiVal(dArray, false) / (d * (double)n));
    }

    public static double entropy(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d -= ContingencyTables.lnFunc(dArray[n]);
            d2 += dArray[n];
            ++n;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return (d + ContingencyTables.lnFunc(d2)) / (d2 * log2);
    }

    public static double entropyConditionedOnColumns(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray[0].length) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < dArray.length) {
                d += ContingencyTables.lnFunc(dArray[n2][n]);
                d3 += dArray[n2][n];
                ++n2;
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
            ++n;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return -d / (d2 * log2);
    }

    public static double entropyConditionedOnRows(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < dArray[0].length) {
                d += ContingencyTables.lnFunc(dArray[n][n2]);
                d3 += dArray[n][n2];
                ++n2;
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
            ++n;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return -d / (d2 * log2);
    }

    public static double entropyConditionedOnRows(double[][] dArray, double[][] dArray2, double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < dArray2.length) {
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 0;
            while (n2 < dArray2[0].length) {
                d2 -= dArray2[n][n2] * Math.log(dArray[n][n2] + 1.0);
                d3 += dArray[n][n2];
                d4 += dArray2[n][n2];
                ++n2;
            }
            d2 += d4 * Math.log(d3 + d);
            ++n;
        }
        return d2 / log2;
    }

    public static double entropyOverRows(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < dArray[0].length) {
                d3 += dArray[n][n2];
                ++n2;
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
            ++n;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return (d + ContingencyTables.lnFunc(d2)) / (d2 * log2);
    }

    public static double entropyOverColumns(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < dArray[0].length) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < dArray.length) {
                d3 += dArray[n2][n];
                ++n2;
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
            ++n;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return (d + ContingencyTables.lnFunc(d2)) / (d2 * log2);
    }

    public static double gainRatio(double[][] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < dArray[0].length) {
            double d5 = 0.0;
            n = 0;
            while (n < dArray.length) {
                d5 += dArray[n][n2];
                ++n;
            }
            d += ContingencyTables.lnFunc(d5);
            d4 += d5;
            ++n2;
        }
        d -= ContingencyTables.lnFunc(d4);
        n = 0;
        while (n < dArray.length) {
            double d6 = 0.0;
            int n3 = 0;
            while (n3 < dArray[0].length) {
                d2 += ContingencyTables.lnFunc(dArray[n][n3]);
                d6 += dArray[n][n3];
                ++n3;
            }
            d3 += ContingencyTables.lnFunc(d6);
            ++n;
        }
        d2 -= d3;
        double d7 = d - d2;
        if (Utils.eq(d3 -= ContingencyTables.lnFunc(d4), 0.0)) {
            return 0.0;
        }
        return d7 / d3;
    }

    public static double log2MultipleHypergeometric(double[][] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < dArray.length) {
            double d3 = 0.0;
            n2 = 0;
            while (n2 < dArray[n3].length) {
                d3 += dArray[n3][n2];
                ++n2;
            }
            d += SpecialFunctions.lnFactorial(d3);
            d2 += d3;
            ++n3;
        }
        n2 = 0;
        while (n2 < dArray[0].length) {
            double d4 = 0.0;
            n = 0;
            while (n < dArray.length) {
                d4 += dArray[n][n2];
                ++n;
            }
            d += SpecialFunctions.lnFactorial(d4);
            ++n2;
        }
        n = 0;
        while (n < dArray.length) {
            int n4 = 0;
            while (n4 < dArray[n].length) {
                d -= SpecialFunctions.lnFactorial(dArray[n][n4]);
                ++n4;
            }
            ++n;
        }
        return -(d -= SpecialFunctions.lnFactorial(d2)) / log2;
    }

    public static double[][] reduceMatrix(double[][] dArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n5];
        int n6 = 0;
        while (n6 < n4) {
            n = 0;
            while (n < n5) {
                int n7 = n6;
                dArray2[n7] = dArray2[n7] + dArray[n6][n];
                int n8 = n;
                dArray3[n8] = dArray3[n8] + dArray[n6][n];
                ++n;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n4) {
            if (Utils.gr(dArray2[n6], 0.0)) {
                ++n2;
            }
            ++n6;
        }
        n = 0;
        while (n < n5) {
            if (Utils.gr(dArray3[n], 0.0)) {
                ++n3;
            }
            ++n;
        }
        double[][] dArray4 = new double[n2][n3];
        int n9 = 0;
        n6 = 0;
        while (n6 < n4) {
            if (Utils.gr(dArray2[n6], 0.0)) {
                int n10 = 0;
                n = 0;
                while (n < n5) {
                    if (Utils.gr(dArray3[n], 0.0)) {
                        dArray4[n9][n10] = dArray[n6][n];
                        ++n10;
                    }
                    ++n;
                }
                ++n9;
            }
            ++n6;
        }
        return dArray4;
    }

    public static double symmetricalUncertainty(double[][] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        while (n2 < dArray[0].length) {
            double d6 = 0.0;
            n = 0;
            while (n < dArray.length) {
                d6 += dArray[n][n2];
                ++n;
            }
            d2 += ContingencyTables.lnFunc(d6);
            d += d6;
            ++n2;
        }
        d2 -= ContingencyTables.lnFunc(d);
        n = 0;
        while (n < dArray.length) {
            double d7 = 0.0;
            int n3 = 0;
            while (n3 < dArray[0].length) {
                d7 += dArray[n][n3];
                d4 += ContingencyTables.lnFunc(dArray[n][n3]);
                ++n3;
            }
            d3 += ContingencyTables.lnFunc(d7);
            ++n;
        }
        d4 -= d3;
        d5 = d2 - d4;
        if (Utils.eq(d2, 0.0) || Utils.eq(d3 -= ContingencyTables.lnFunc(d), 0.0)) {
            return 0.0;
        }
        return 2.0 * (d5 / (d2 + d3));
    }

    public static double tauVal(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n2];
        int n3 = 0;
        while (n3 < n) {
            double d4 = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                if (Utils.gr(dArray[n3][n4], d4)) {
                    d4 = dArray[n3][n4];
                }
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + dArray[n3][n4];
                d3 += dArray[n3][n4];
                ++n4;
            }
            d2 += d4;
            ++n3;
        }
        if (Utils.eq(d3, 0.0)) {
            return 0.0;
        }
        d = dArray2[Utils.maxIndex(dArray2)];
        return (d2 - d) / (d3 - d);
    }

    private static double lnFunc(double d) {
        if (d < 1.0E-6) {
            return 0.0;
        }
        return d * Math.log(d);
    }

    private static double chiCell(double d, double d2, boolean bl) {
        double d3 = d - d2;
        if (bl && (d3 = Math.abs(d3) - 0.5) < 0.0) {
            d3 = 0.0;
        }
        if (Math.abs(d2) < 1.0E-9) {
            return 0.0;
        }
        return d3 * d3 / d2;
    }
}

