/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import jaws.corePackage.Attribute;
import jaws.corePackage.Instances;

class Tree {
    public boolean isLeaf = true;
    public Instances instances;
    public int classification;
    public Attribute splittingAttribute;
    public double splittingValue;
    public Tree[] children;

    public Tree(Instances instances) throws Exception {
        this.isLeaf = true;
        this.instances = instances;
        if (instances.numInstances() > 0) {
            this.classification = (int)instances.instance(0).classValue();
            return;
        }
        this.classification = 0;
    }

    public Tree(Instances instances, Attribute attribute, double d) {
        this.isLeaf = false;
        this.instances = instances;
        this.splittingAttribute = attribute;
        this.splittingValue = d;
        if (attribute.isNominal()) {
            this.children = new Tree[attribute.numValues()];
            return;
        }
        this.children = new Tree[2];
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{" < ", " > "};
        try {
            if (this.isLeaf) {
                stringBuffer.append(" -> " + this.instances.classAttribute().value(this.classification) + " (" + this.instances.numInstances() + " instances)" + "\n");
            } else {
                stringBuffer.append("\n");
                int n2 = !this.splittingAttribute.isNominal() ? 2 : this.splittingAttribute.numValues();
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 0;
                    while (n4 < n) {
                        stringBuffer.append("    ");
                        ++n4;
                    }
                    stringBuffer.append(this.splittingAttribute.name());
                    if (this.splittingAttribute.isNominal()) {
                        stringBuffer.append(" = " + this.splittingAttribute.value(n3));
                    } else {
                        stringBuffer.append(String.valueOf(stringArray[n3]) + this.splittingValue);
                    }
                    stringBuffer.append(this.children[n3].toString(n + 1));
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print Id3 classifier!";
        }
    }
}

