/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Matrix;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Classifier;
import jaws.evaluationPackage.Evaluation;
import jaws.filterPackage.Filter;
import jaws.filterPackage.NominalToNumericFilter;
import jaws.filterPackage.ReplaceMissingValuesFilter;

public class LinearRegression
extends Classifier {
    private double[] coefficients;
    private boolean[] toBeDeleted;
    private Instances transformedData;
    private ReplaceMissingValuesFilter theMissingFilter;
    private NominalToNumericFilter theTransformFilter;

    public void buildClassifier(Instances instances) throws Exception {
        Object var2_2 = null;
        Object var3_3 = null;
        if (!instances.classAttribute().isNumeric()) {
            throw new Exception("Class attribute has to be numeric for regression!");
        }
        this.transformedData = instances;
        this.theTransformFilter = new NominalToNumericFilter();
        this.theTransformFilter.inputFormat(this.transformedData);
        this.transformedData = Filter.useFilter(this.transformedData, this.theTransformFilter);
        this.theMissingFilter = new ReplaceMissingValuesFilter();
        this.theMissingFilter.inputFormat(this.transformedData);
        this.transformedData = Filter.useFilter(this.transformedData, this.theMissingFilter);
        this.toBeDeleted = new boolean[this.transformedData.numAttributes()];
        int n = 0;
        while (n < this.transformedData.numAttributes()) {
            this.toBeDeleted[n] = false;
            ++n;
        }
        this.doRegression();
        this.transformedData = new Instances(this.transformedData, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = 0.0;
        int n = 0;
        Instance instance2 = instance;
        this.theTransformFilter.input(instance2);
        instance2 = this.theTransformFilter.output();
        this.theMissingFilter.input(instance2);
        instance2 = this.theMissingFilter.output();
        int n2 = 0;
        while (n2 < instance2.numAttributes()) {
            if (instance2.classIndex() != n2 && !this.toBeDeleted[n2]) {
                d += this.coefficients[n] * instance2.value(n2);
                ++n;
            }
            ++n2;
        }
        return d += this.coefficients[n];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            boolean bl = true;
            stringBuffer.append("\nLinear Regression Model\n\n");
            stringBuffer.append(this.transformedData.classAttribute().name() + " =\n\n");
            int n2 = 0;
            while (true) {
                if (n2 >= this.transformedData.numAttributes()) {
                    stringBuffer.append(" +\n" + Utils.doubleToString(this.coefficients[n], 12, 4));
                    return stringBuffer.toString();
                }
                if (n2 != this.transformedData.classIndex() && !this.toBeDeleted[n2]) {
                    if (!bl) {
                        stringBuffer.append(" +\n");
                    } else {
                        bl = false;
                    }
                    stringBuffer.append(Utils.doubleToString(this.coefficients[n], 12, 4) + " * ");
                    stringBuffer.append(this.transformedData.attribute(n2).name());
                    ++n;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return "Can't print Linear Regression!";
        }
    }

    public void doRegression() throws Exception {
        int n = 0;
        int n2 = 0;
        this.linearDependencies();
        int n3 = this.transformedData.numAttributes();
        int n4 = 0;
        while (n4 < this.transformedData.numAttributes()) {
            if (n4 != this.transformedData.classIndex() && this.toBeDeleted[n4]) {
                --n3;
            }
            ++n4;
        }
        Matrix matrix = new Matrix(this.transformedData.numInstances(), n3);
        Matrix matrix2 = new Matrix(this.transformedData.numInstances(), 1);
        n4 = 0;
        while (n4 < this.transformedData.numInstances()) {
            if (!this.transformedData.instance(n4).classIsMissing()) {
                n = 0;
                int n5 = 0;
                while (n5 < this.transformedData.numAttributes()) {
                    if (n5 == this.transformedData.classIndex()) {
                        matrix2.setElement(n4, 0, this.transformedData.instance(n4).classValue());
                    } else if (!this.toBeDeleted[n5]) {
                        matrix.setElement(n4, n, this.transformedData.instance(n4).value(n5));
                        ++n;
                    }
                    ++n5;
                }
                matrix.setElement(n4, n, 1.0);
                ++n2;
            }
            ++n4;
        }
        double[] dArray = matrix.regression(matrix2);
        this.coefficients = dArray;
    }

    private final void linearDependencies() throws Exception {
        int n;
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.transformedData.numAttributes()) {
            if (n2 != this.transformedData.classIndex()) {
                d = Double.MAX_VALUE;
                n = 0;
                while (n < this.transformedData.numInstances()) {
                    if (!this.transformedData.instance(n).isMissing(n2)) {
                        if (d == Double.MAX_VALUE) {
                            d = this.transformedData.instance(n).value(n2);
                        } else if (!Utils.eq(d, this.transformedData.instance(n).value(n2))) break;
                    }
                    ++n;
                }
                if (n == this.transformedData.numInstances()) {
                    this.toBeDeleted[n2] = true;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.transformedData.numAttributes() - 1) {
            if (!this.toBeDeleted[n2] && n2 != this.transformedData.classIndex()) {
                int n3 = n2 + 1;
                while (n3 < this.transformedData.numAttributes()) {
                    if (!this.toBeDeleted[n3] && n3 != this.transformedData.classIndex()) {
                        d = Double.MAX_VALUE;
                        n = 0;
                        while (n < this.transformedData.numInstances()) {
                            if (!this.transformedData.instance(n).isMissing(n2)) {
                                if (d == Double.MAX_VALUE) {
                                    d = this.transformedData.instance(n).value(n2) / this.transformedData.instance(n).value(n3);
                                } else if (!Utils.eq(d, this.transformedData.instance(n).value(n2) / this.transformedData.instance(n).value(n3))) break;
                            }
                            ++n;
                        }
                        if (n == this.transformedData.numInstances()) {
                            this.toBeDeleted[n3] = true;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new LinearRegression(), stringArray));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

