/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Classifier;
import jaws.evaluationPackage.Evaluation;
import jaws.evaluationPackage.UpdateableClassifier;

public class IB1
extends Classifier
implements UpdateableClassifier {
    private Instances train;
    private double[] minArray;
    private double[] maxArray;

    public void buildClassifier(Instances instances) throws Exception {
        this.train = new Instances(instances);
        this.minArray = new double[this.train.numAttributes()];
        this.maxArray = new double[this.train.numAttributes()];
        int n = 0;
        while (n < this.train.numAttributes()) {
            this.maxArray[n] = Double.NaN;
            this.minArray[n] = Double.NaN;
            ++n;
        }
        Enumeration enumeration = this.train.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            this.updateMinMax((Instance)enumeration.nextElement());
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        this.train.add(instance);
        this.updateMinMax(instance);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        this.updateMinMax(instance);
        Enumeration enumeration = this.train.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            double d3;
            Instance instance2 = (Instance)enumeration.nextElement();
            if (instance2.classIsMissing() || !((d3 = this.distance(instance, instance2)) < d)) continue;
            d = d3;
            d2 = instance2.classValue();
        }
        return d2;
    }

    public String toString() {
        return "IB1 classifier";
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        int n = 0;
        while (n < this.train.numAttributes()) {
            if (n != this.train.classIndex()) {
                if (this.train.attribute(n).isNominal()) {
                    if (instance.isMissing(n) || instance2.isMissing(n) || (int)instance.value(n) != (int)instance2.value(n)) {
                        d += 1.0;
                    }
                } else {
                    double d2;
                    if (instance.isMissing(n) || instance2.isMissing(n)) {
                        if (instance.isMissing(n) && instance2.isMissing(n)) {
                            d2 = 1.0;
                        } else {
                            d2 = instance2.isMissing(n) ? this.norm(instance.value(n), n) : this.norm(instance2.value(n), n);
                            if (d2 < 0.5) {
                                d2 = 1.0 - d2;
                            }
                        }
                    } else {
                        d2 = this.norm(instance.value(n), n) - this.norm(instance2.value(n), n);
                    }
                    d += d2 * d2;
                }
            }
            ++n;
        }
        return d;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.minArray[n]) || Utils.eq(this.maxArray[n], this.minArray[n])) {
            return 0.0;
        }
        return (d - this.minArray[n]) / (this.maxArray[n] - this.minArray[n]);
    }

    private void updateMinMax(Instance instance) {
        int n = 0;
        while (n < this.train.numAttributes()) {
            if (this.train.attribute(n).isNumeric() && !instance.isMissing(n)) {
                if (Double.isNaN(this.minArray[n])) {
                    this.minArray[n] = instance.value(n);
                    this.maxArray[n] = instance.value(n);
                } else if (instance.value(n) < this.minArray[n]) {
                    this.minArray[n] = instance.value(n);
                } else if (instance.value(n) > this.maxArray[n]) {
                    this.maxArray[n] = instance.value(n);
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new IB1(), stringArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            return;
        }
    }
}

