#include "HtmlLinks.h"





HtmlLink::HtmlLink(const HtmlLink& x){
  Xmin=x.Xmin;
  Ymin=x.Ymin;
  Xmax=x.Xmax;
  Ymax=x.Ymax;
  dest=new GString(x.dest);
}

HtmlLink::HtmlLink(double xmin,double ymin,double xmax,double ymax,GString * _dest)
{
  Xmin=xmin;
  Ymin=ymin;
  Xmax=xmax;
  Ymax=ymax;
  dest=new GString(_dest);
}

HtmlLink::~HtmlLink(){
 if (dest) delete dest;
}

GBool HtmlLink::inLink(double xmin,double ymin,double xmax,double ymax) const {
  double y=(ymin+ymax)/2;
  if (y>Ymax) return gFalse;
  return (y>Ymin)&&(xmin<Xmax)&&(xmax>Xmin);
 }
  

HtmlLink& HtmlLink::operator=(const HtmlLink& x){
  if (this==&x) return *this;
  if (dest) {delete dest;dest=NULL;} 
  Xmin=x.Xmin;
  Ymin=x.Ymin;
  Xmax=x.Xmax;
  Ymax=x.Ymax;
  dest=new GString(x.dest);
  return *this;
} 

GString* HtmlLink::Link(GString* content){
   GString *tmp=new GString("<a href=\"");
   tmp->append(new GString(dest));
   tmp->append("\">");
   tmp->append(content);
   tmp->append("</a>");
   delete content;
   return tmp;
}

   

HtmlLinks::HtmlLinks(){
  accu=new GVector<HtmlLink>();
}

HtmlLinks::~HtmlLinks(){
  delete accu;
  accu=NULL; 
}

GBool HtmlLinks::inLink(double xmin,double ymin,double xmax,double ymax,int& p)const {
  
  for(GVector<HtmlLink>::iterator i=accu->begin();i!=accu->end();i++){
    if (i->inLink(xmin,ymin,xmax,ymax)) {
        p=(i - accu->begin());
        return 1;
    }
   }
  return 0;
}

HtmlLink* HtmlLinks::getLink(int i) const{
  GVector<HtmlLink>::iterator g=accu->begin();
  g+=i; 
  return g;
}

