#include <windows.h>
#include <string.h>
#include "netio.h"
#include "httpreq.h"
// #include "locate.h"
#include "wincgiutils.h"


#define url_limit 256
#define file_limit 102400   /*should be large enough for a header line*/
#define default_http_port 80


int parse_url(char *url,
	      char **protocol, char **machine, int *port, char **name)
/* Attempt to break a url into segments.  If the parsing
   fails, 'name' is left pointing to the unparsed portion.
   This routine may extend the url string by one character */
{
  char next, thiss;
  *protocol = *machine = "";
  *port = default_http_port;
  
  *name = url;       /* In case there is no protocol */
  while (*url != ':' && *url != 0) url++;
  if (*url == 0) return http_error_url_invalid;
  url++;
  if (*url != '/') return http_error_url_invalid;
  *url++ = 0;
  if (*url != '/') return http_error_url_invalid;
  url++;
  
  *protocol = *name;
  *machine = url;
  while (*url != ':' && *url != '/' && *url != 0) url++;
  if (*url == ':') {
    *url = 0;
    url++; *port = 0;
    while (*url >= '0' && *url <= '9')
      *port = *port * 10 + (*url++ - '0');
    }
  if (*url == '/') {
    *url++ = 0;
    next = '/';
    *name = url;
    while (*url != 0) {
      thiss = *url;  *url++ = next;  next = thiss; }
    *url++ = next;
    *url = 0;
    }
  else if (*url == 0) {
    url++;
    *name = url;
    *url++ = '/';
    *url = 0;
    }
  else {
    *name = url;
    return http_error_url_invalid;
  }
  return http_ok;
}




int Send_String(char *str, RequestInfoT *RInfo)
{
  return
    SendData(RInfo->ClientSocket, (BYTE *)str, strlen(str), RInfo->ThreadNum);
}

int Send_String_N(char *str, int n,  RequestInfoT *RInfo)
{
  return
    SendData(RInfo->ClientSocket, (BYTE *)str, n, RInfo->ThreadNum);
}

int send_header(char *content, RequestInfoT *RequestInfo)
{
  char Header[1536];  int len, lenc;
	//Build Header
	Header[0] = 0;
	//Status Line
	if (content[0] != '@')          /*No redirection needed*/
	  strcat(Header, "HTTP/1.0 200 OK\r\n");
	else                            /*Redirection*/
	  strcat(Header, "HTTP/1.0 302 Relocation\r\n");
	//Server
	strcat(Header, "Server: GSDL\r\n");
	//Content Type
	strcat(Header, "Content-type: ");
	if (content[0] != '@')          /*No redirection needed*/
	  strcat(Header, content);
	else {                          /*Redirection entry*/
	  strcat(Header, "text/html \r\n");
	  strcat(Header, "Location: ");
	  len = strlen(Header);
	  lenc = strlen(content) - 1;
	  strncpy(&Header[len], &content[1], lenc);
	  Header[len+lenc] = 0;
	  }
	strcat(Header, " \r\n");
	//Single CRLF to end header
	strcat(Header, "\r\n");

   return Send_String(Header, RequestInfo);
}

void send_retrieve_error(int error_num, char *msg1, char *msg2, RequestInfoT *RequestInfo)
{
  char Header[512], Body[512], ErrorNumStr[17], BodyLengthStr[17];
  DWORD BodyLength; int HeaderLength;

  itoa(error_num, ErrorNumStr, 10);

  //Build Data (so we can determine length for the header)
  Body[0] = 0;
  strcat(Body, "<HTML><HEAD><TITLE>Server Error</TITLE></HEAD><BODY>\n");
  strcat(Body, "<H1>Error ");
  strcat(Body, ErrorNumStr);
  strcat(Body, ": ");
  strcat(Body, msg1);
  strcat(Body, "</H1>\n");
  strcat(Body, msg2);
  strcat(Body, "\n</BODY></HTML>");
  BodyLength = (DWORD) strlen(Body);

  //Build Header
  Header[0] = 0;
  //Status Line
  strcat(Header, "HTTP/1.0 ");
  strcat(Header, ErrorNumStr);
  strcat(Header, " ");
  strcat(Header, msg1);
  strcat(Header, "\r\n");
  //Server
  strcat(Header, "Server: GSDL\r\n");
  strcat(Header, "Content-Type: text/html\r\n");
  //Content Length
  itoa(BodyLength, BodyLengthStr, 10);
  strcat(Header, "Content-Length: ");
  strcat(Header, BodyLengthStr);
  strcat(Header, "\r\n");
  //Single CRLF to end header
  strcat(Header, "\r\n");
  HeaderLength = strlen(Header);

   //Send the file if we have one (and if it's not a HEAD request)
  SendData(RequestInfo->ClientSocket, (BYTE *) Header, strlen(Header), RequestInfo->ThreadNum);
//   if ((FileFound == FALSE) && (strcmpi(RequestFields.MethodStr, "HEAD") != 0)) {
	//Send generated data
  SendData(RequestInfo->ClientSocket, (BYTE *) Body, BodyLength, RequestInfo->ThreadNum);

}

