#define SB_NOERROR            0
#define SB_ALREADYINIT        1
#define SB_DDE_FAILINIT       2
#define SB_DDE_FAILDEINIT     3
#define SB_NOTINITED          4
#define SB_FAIL_BADFORMAT     5
#define SB_FAIL_NOTFOUND      6
#define SB_FAIL_NORESOURCES   7
#define SB_FAILCONNECTBROWSER 9


extern int numbrowserstarted;

// initstartbrowser should be called before startbrowser
//
// returns SB_NOERROR on success, 
// SB_ALREADYINIT or SB_DDE_FAILINIT on failure
int initstartbrowser ();

// returns SB_NOERROR on success,
// SB_DDE_FAILDEINIT of failure
int deinitstartbrowser ();

// startbrowser will try to start a browser (or connect to a running browser).
//
// Returns SB_NOERROR on success,
// SB_NOTINITED, SB_FAIL_BADFORMAT, SB_FAIL_NOTFOUND, or SB_FAIL_NORESOURCES, 
//  on failure
int startbrowser (char *url, char *browser_exe, char *startdir);

// returns SB_NOERROR on success,
// SB_NOTINITED, SB_FAILCONNECTBROWSER on failure
int browserrunning (char *browser_exe);
