#ifndef D_WINSOCK_H
#define D_WINSOCK_H


/* get most definitions from the real winsock */
#include <winsock.h>


#define D_NOERROR           0
#define D_ERR_UNEXPECTED    1
#define D_ERR_LOADFAILED    2
#define D_ERR_FREELIBFAILED 3



// d_LoadWinsock must be called before an normal winsock
// functions


// expects path to be NULL, a empty string, or a path which ends in a slash
// returns D_NOERROR on success,
// D_ERR_UNEXPECTED or D_ERR_LOADFAILED on failure
int d_LoadWinsock (char *path);

// returns D_NOERROR on success,
// D_ERR_FREELIBFAILED on failure
int d_UnloadWinsock ();


// dynamically loaded versions of the winsock functions

SOCKET d_accept (SOCKET s, struct sockaddr *addr, int *addrlen);
int d_bind (SOCKET s, const struct sockaddr *addr, int namelen);
int d_closesocket (SOCKET s);
int d_connect (SOCKET s, const struct sockaddr *name, int namelen);
int d_ioctlsocket (SOCKET s, long cmd, u_long *argp);
int d_getpeername (SOCKET s, struct sockaddr *name, int *namelen);
int d_getsockname (SOCKET s, struct sockaddr *name, int *namelen);
int d_getsockopt (SOCKET s, int level, int optname, char *optval, int *optlen);
u_long d_htonl (u_long hostlong);
u_short d_htons (u_short hostshort);
unsigned long d_inet_addr (const char *cp);
char *d_inet_ntoa (struct in_addr in);
int d_listen (SOCKET s, int backlog);
u_long d_ntohl (u_long netlong);
u_short d_ntohs (u_short netshort);
int d_recv (SOCKET s, char *buf, int len, int flags);
int d_recvfrom (SOCKET s, char *buf, int len, int flags,
		struct sockaddr *from, int *fromlen);
int d_select (int nfds, fd_set *readfds, fd_set *writefds,
	      fd_set *exceptfds, const struct timeval *timeout);
int d_send (SOCKET s, const char *buf, int len, int flags);
int d_sendto (SOCKET s, const char *buf, int len, int flags,
	      const struct sockaddr *to, int tolen);
int d_setsockopt (SOCKET s, int level, int optname,
		  const char *optval, int optlen);
int d_shutdown (SOCKET s, int how);
SOCKET d_socket (int af, int type, int protocol);

hostent *d_gethostbyaddr(const char *addr, int len, int type);
hostent *d_gethostbyname(const char *name);
int d_gethostname (char *name, int namelen);
servent *d_getservbyport(int port, const char *proto);
servent *d_getservbyname(const char *name, const char *proto);
protoent *d_getprotobynumber(int proto);
protoent *d_getprotobyname(const char *name);

int d_WSAStartup(WORD wVersionRequired, LPWSADATA lpWSAData);
int d_WSACleanup(void);
void d_WSASetLastError(int iError);
int d_WSAGetLastError(void);
BOOL d_WSAIsBlocking(void);
int d_WSAUnhookBlockingHook(void);
FARPROC d_WSASetBlockingHook(FARPROC lpBlockFunc);
int d_WSACancelBlockingCall(void);
HANDLE d_WSAAsyncGetServByName(HWND hWnd, u_int wMsg,
			       const char *name,
			       const char *proto,
			       char *buf, int buflen);
HANDLE d_WSAAsyncGetServByPort(HWND hWnd, u_int wMsg, int port,
			       const char *proto, char *buf,
			       int buflen);
HANDLE d_WSAAsyncGetProtoByName(HWND hWnd, u_int wMsg,
				const char *name, char *buf,
				int buflen);
HANDLE d_WSAAsyncGetProtoByNumber(HWND hWnd, u_int wMsg,
				  int number, char *buf,
				  int buflen);
HANDLE d_WSAAsyncGetHostByName(HWND hWnd, u_int wMsg,
			       const char *name, char *buf,
			       int buflen);
HANDLE d_WSAAsyncGetHostByAddr(HWND hWnd, u_int wMsg,
			       const char *addr, int len, int type,
			       char *buf, int buflen);
int d_WSACancelAsyncRequest(HANDLE hAsyncTaskHandle);
int d_WSAAsyncSelect(SOCKET s, HWND hWnd, u_int wMsg,
		     long lEvent);





#endif
