/**********************************************************************
 *
 * z3950proto.h --
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef Z3950PROTO_H
#define Z3950PROTO_H

#include "recptproto.h"
#include "z3950server.h"

class z3950proto : public recptproto {
protected:
  int zserver_count;
  z3950_server_array zservers;
public:
  z3950proto();
  virtual ~z3950proto();

  int getServerCount() { return zserver_count;}
  /*
  void add_collectserver (collectserver *thecserver) 
        {cservers.addcollectserver(thecserver);}
  */
  
  void add_server(z3950_server& zserver);

  void read_config_file(const text_t &filename, const text_t &errfile);

  void configure (const text_t &key, const text_tarray &cfgline);

  bool init (ostream &logout);

  text_t get_protocol_name () {return "z3950proto";}

  void get_collection_list (text_tarray &collist, comerror_t &err, 
			    ostream &logout);

  void has_collection (const text_t &collection, bool &hascollection, 
		       comerror_t &err, ostream &logout);
  
  void ping (const text_t &collection, bool &wassuccess, 
	     comerror_t &err, ostream &logout);
  
  void get_collectinfo (const text_t &collection, 
			ColInfoResponse_t &collectinfo,
			comerror_t &err, ostream &logout);
  
  void get_filterinfo (const text_t &collection,
		       InfoFiltersResponse_t &response,
		       comerror_t &err, ostream &logout);
  
  /*  void get_info (const text_t &collection, const text_tset &metadata,
      FilterResponse_t &response, ostream &logout);
  */

  void get_filteroptions (const text_t &collection,
                          const InfoFilterOptionsRequest_t &request,
                          InfoFilterOptionsResponse_t &response, 
                          comerror_t &err, ostream &logout);
  
  void filter (const text_t &collection,
	       FilterRequest_t &request,
	       FilterResponse_t &response,
	       comerror_t &err, ostream &logout);
  
  void get_document (const text_t &collection,
		     const DocumentRequest_t &request,
		     DocumentResponse_t &response,
		     comerror_t &err, ostream &logout);

};

#endif
