/**********************************************************************
 *
 * usersaction.h -- managing users
 * Copyright (C) 1999  DigiLib Systems Limited, New Zealand
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef USERSACTION_H
#define USERSACTION_H

#include "gsdlconf.h"
#include "action.h"
#include "text_t.h"


class usersaction : public action {
protected:
  text_t usersfile;

public:
  usersaction ();
  virtual ~usersaction () {}

  void configure (const text_t &key, const text_tarray &cfgline);
  
  text_t get_action_name () {return "um";}
  
  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response, text_t &response_data, 
			 ostream &logout);
  
  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

protected:
  void define_user_macros (cgiargsclass &args, displayclass &disp);
  
  bool do_listusers (cgiargsclass &args, displayclass &disp, 
		     outconvertclass &outconvert, ostream &textout, 
		     ostream &logout);

  bool do_edituser (cgiargsclass &args, displayclass &disp, 
		    outconvertclass &outconvert, ostream &textout, 
		    ostream &logout);

  bool do_deleteuser (cgiargsclass &args, displayclass &disp, 
		      outconvertclass &outconvert, ostream &textout, 
		      ostream &logout);

  bool do_changepasswd (cgiargsclass &args, displayclass &disp, 
			outconvertclass &outconvert, ostream &textout, 
			ostream &logout);
};


#endif
