/**********************************************************************
 *
 * htmlutils.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "htmlutils.h"

text_t html_safe (const text_t &instring) {
  
  text_t outstring;
  text_t::const_iterator here = instring.begin();
  text_t::const_iterator end = instring.end();
  while (here != end) {
    if (*here == '"') outstring += "&quot;";
    else if (*here == '&') outstring += "&amp;";
    else if (*here == '<') outstring += "&lt;";
    else if (*here == '>') outstring += "&gt;";
    else outstring.push_back(*here);
    here ++;
  }
  return outstring;
}
