/**********************************************************************
 *
 * formattools.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef FORMATTOOLS_H
#define FORMATTOOLS_H

#include "text_t.h"
#include "comtypes.h"
#include "recptproto.h"
#include "display.h"

enum command_t {comIf, comOr, comMeta, comText, comLink, comEndLink, comNum, comIcon, 
		comDoc, comHighlight, comEndHighlight, comRel};//changed
enum pcommand_t {pNone, pImmediate, pTop, pAll};
enum dcommand_t {dMeta, dText};
enum mcommand_t {mNone, mCgiSafe};

struct metadata_t {
  void clear();
  metadata_t () {clear();}

  text_t metaname;
  mcommand_t metacommand;
  pcommand_t parentcommand;
  text_t parentoptions;
};


// The decision component of an {If}{decision,true-text,false-text}
// formatstring.  Te decision can be based on metadata or on text;
// normally that text would be a macro like _cgiargmode_.  --gordon
struct decision_t {
  void clear();
  decision_t () {clear();}

  dcommand_t command;
  metadata_t meta;
  text_t text;
};

struct format_t {
  void clear();
  format_t () {clear();}

  command_t command;
  decision_t decision;
  text_t text;
  metadata_t meta;
  format_t *nextptr;
  format_t *ifptr;
  format_t *elseptr;
  format_t *orptr;
};

// the format structure used by this receptionist
struct formatinfo_t {
  void clear();
  formatinfo_t () {clear();}

  bool DocumentImages;
  bool DocumentTitles;
  text_t DocumentHeading;
  bool DocumentContents;
  bool DocumentArrowsBottom;
  text_tarray DocumentButtons;
  text_t DocumentText;
  //-----------------
  text_t RelatedDocuments;
  //----------------
  text_tmap formatstrings;
  bool DocumentUseHTML;
};

bool is_table_content (const text_t &formatstring);
bool is_table_content (const format_t *formatlistptr);

bool get_formatstring (const text_t &key, const text_tmap &formatstringmap,
		       text_t &formatstring);
bool get_formatstring (const text_t &key1, const text_t &key2,  
		       const text_tmap &formatstringmap,
		       text_t &formatstring);

text_t format_date (const text_t &date);

text_t iso639 (const text_t &langcode);

text_t get_related_docs(const text_t& collection, recptproto* collectproto,
			  ResultDocInfo_t &docinfo, ostream& logout);


bool parse_formatstring (const text_t &formatstring, format_t *formatlistptr, 
			 text_tset &metadata, bool &getParents);


text_t get_formatted_string (const text_t& collection, recptproto* collectproto,
			     ResultDocInfo_t &docinfo, displayclass &disp,
			     format_t *formatlistptr,
			     const text_t &link, const text_t &icon, 
			     const text_t& t, const bool highlight, 
			     ostream& logout);

text_t get_formatted_string (const text_t& collection, recptproto* collectproto,
			     ResultDocInfo_t &docinfo, displayclass &disp,
			     format_t *formatlistptr,
			     const text_t &link, const text_t &icon, 
			     const bool highlight,
			     ostream& logout);

text_t get_formatted_string (const text_t& collection, recptproto* collectproto,
			     ResultDocInfo_t &docinfo, displayclass &disp, 
			     format_t *formatlistptr,
			     const text_t &text,
			     ostream& logout);

text_t get_formatted_string (const text_t& collection, recptproto* collectproto,
			     ResultDocInfo_t &docinfo, displayclass &disp, 
			     format_t *formatlistptr, ostream& logout);



#endif


