/**********************************************************************
 *
 * browserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "browserclass.h"
#include <assert.h>


browserclass::browserclass () {
}

browserclass::~browserclass () {
}

// configure should be called once for each configuration line
// the default version does nothing
void browserclass::configure (const text_t &/*key*/, const text_tarray &/*cfgline*/) {
}

// init should be called after all the configuration is done but
// before any other methods are called
bool browserclass::init (ostream &/*logout*/) {
  return true;
}

// returns the name that specifies the browserclass type
text_t browserclass::get_browser_name () {
  return "";
}

void browserclass::processOID (cgiargsclass &/*args*/, recptproto * /*collectproto*/, ostream &/*logout*/) {
}

void browserclass::load_metadata_defaults (text_tset &/*metadata*/) {
}

text_t browserclass::get_default_formatstring () {
  return "";
}

void browserclass::set_filter_options (FilterRequest_t &request, cgiargsclass &args) {
  
  OptionValue_t option;

  if (args["a"] == "q") {
    int arg_m = args.getintarg("m");
    
    option.name = "StartResults";
    option.value = args["r"];
    request.filterOptions.push_back (option);
    
    option.name = "EndResults";
    int endresults = args.getintarg("o") + (args.getintarg("r") - 1);
    //    int endresults = (args.getintarg("o")*3) + (args.getintarg("r") - 1);
    if ((endresults > arg_m) && (arg_m != -1)) endresults = arg_m;
    option.value = endresults;
    request.filterOptions.push_back (option);

  } else {
    option.name = "StartResults";
    option.value = args["r"];
    request.filterOptions.push_back (option);
    
    option.name = "EndResults";
    int endresults = 20 + (args.getintarg("r") - 1);
    option.value = endresults;
    request.filterOptions.push_back (option);
  }
}

int browserclass::output_section_group (ResultDocInfo_t &/*section*/, cgiargsclass &/*args*/,
					const text_t &/*collection*/, int /*colnumber*/, 
					format_t * /*formatlistptr*/, bool /*use_table*/, 
					text_tset &/*metadata*/, bool &/*getParents*/,
					recptproto * /*collectproto*/, displayclass &/*disp*/, 
					outconvertclass &/*outconvert*/, ostream &/*textout*/, 
					ostream &/*logout*/) {
  return 0;
}

int browserclass::output_section_group (FilterResponse_t &/*sections*/, cgiargsclass &/*args*/,
					const text_t &/*collection*/, int /*colnumber*/, 
					format_t * /*formatlistptr*/, bool /*use_table*/, 
					text_tset &/*metadata*/, bool &/*getParents*/,
					recptproto * /*collectproto*/, displayclass &/*disp*/, 
					outconvertclass &/*outconvert*/, ostream &/*textout*/, 
					ostream &/*logout*/) {
  return 0;
}

bool operator==(const browserptr &x, const browserptr &y) {
  return (x.b == y.b);
}

bool operator<(const browserptr &x, const browserptr &y) {
  return (x.b < y.b);
}

// thebrowserclass remains the property of the calling code but
// should not be deleted until it is removed from this list.
void browsermapclass::addbrowser (browserclass *thebrowserclass) {
  // can't add a null browserclass
  assert (thebrowserclass != NULL);
  if (thebrowserclass == NULL) return;
  
  // can't add a browserclass with no name
  assert (!(thebrowserclass->get_browser_name()).empty());
  if ((thebrowserclass->get_browser_name()).empty()) return;

  browserptr aptr;
  aptr.b = thebrowserclass;
  browserptrs[thebrowserclass->get_browser_name()] = aptr;
}

// getbrowser will return the default browser if the browser 
// could not be found
browserclass *browsermapclass::getbrowser (const text_t &key) {
  // can't find a browser with no name
  if (key.empty()) return get_default_browser();

  iterator here = browserptrs.find (key);
  if (here == browserptrs.end()) return get_default_browser();
  
  return (*here).second.b;
}

void browsermapclass::setdefaultbrowser (const text_t &browsername) {
  defaultbrowser = browsername;
}

browserclass *browsermapclass::get_default_browser () {

  iterator here = browserptrs.find (defaultbrowser);
  if (here == browserptrs.end())
    // we'll just take the first in the list if
    // no valid default was set
    here = browserptrs.begin();
  return (*here).second.b;
}
