/**************************************************************************
 *
 * text.h -- Header file for compression related stuff
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: text.cpp,v 1.2 2000/07/24 02:16:33 kjm18 Exp $
 *
 **************************************************************************/

#include "text.h"

// UCArray currently contains all the basic reading and writing
// functions
#include "UCArray.h"


compressed_text_header::compressed_text_header () {
  Clear();
}

void compressed_text_header::Clear () {
  num_of_docs = 0;
  num_of_words = 0;
  num_of_bytes = 0.0;
}


bool compressed_text_header::Read (FILE *f) {
  return (ReadUL (f, num_of_docs) &&
	  ReadUL (f, num_of_words) &&
	  ReadD (f, num_of_bytes));
}

bool compressed_text_header::Write (FILE *f) const {
  return (WriteUL (f, num_of_docs) &&
	  WriteUL (f, num_of_words) &&
	  WriteD (f, num_of_bytes));
}


auxiliary_dict::auxiliary_dict () {
  word_data[0] = NULL;
  word_data[1] = NULL;
  words[0] = NULL;
  words[1] = NULL;
}

auxiliary_dict::~auxiliary_dict () {
  Clear ();
}

void auxiliary_dict::Clear () {
  if (word_data[0] != NULL) {
    delete word_data[0];
    word_data[0] = NULL;
  }
  if (word_data[1] != NULL) {
    delete word_data[1];
    word_data[1] = NULL;
  }
  if (words[0] != NULL) {
    delete words[0];
    words[0] = NULL;
  }
  if (words[1] != NULL) {
    delete words[1];
    words[1] = NULL;
  }
}


compression_dict::compression_dict () {
  int which;
  for (which = 0; which < 2; which++) {
    cfh[which] = NULL;
    values[which] = NULL;
    escape[which] = NULL;
    chars_huff[which] = NULL;
    chars_vals[which] = NULL;
    lens_huff[which] = NULL;
    lens_vals[which] = NULL;
  }

  MemForCompDict = 0;
  ad = NULL;
  fast_loaded = 0;
}

compression_dict::~compression_dict () {
  Clear ();
}

void compression_dict::Clear () {
  int which;
  for (which = 0; which < 2; which++) {
    if (cfh[which] != NULL) {
      delete cfh[which];
      cfh[which] = NULL;
    }
    if (values[which] != NULL) {
      delete values[which][0][0];
      delete values[which][0];
      delete values[which];
      values[which] = NULL;
    }
    if (escape[which] != NULL) { // don't know if needed
      //delete escape[which]; // this was causing a seg fault
      escape[which] = NULL;
    }
    if (chars_huff[which] != NULL) {
      delete chars_huff[which];
      chars_huff[which] = NULL;
    }
    if (chars_vals[which] != NULL) {
      delete chars_vals[which][0];
      delete chars_vals[which];
      chars_vals[which] = NULL;
    }
    if (lens_huff[which] != NULL) {
      delete lens_huff[which];
      lens_huff[which] = NULL;
    }
    if (lens_vals[which] != NULL) {
      delete lens_vals[which][0];
      delete lens_vals[which];
      lens_vals[which] = NULL;
    }
  }

  if (ad != NULL) {
    delete ad;
    ad = NULL;
  }

  MemForCompDict = 0;
  fast_loaded = 0;
}
