/**************************************************************************
 *
 * FileBuf.h -- File buffer
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: FileBuf.h,v 1.1 2000/01/14 02:17:38 sjboddie Exp $
 *
 **************************************************************************/

#ifndef FILEBUF_H
#define FILEBUF_H

#define FILEBUFSIZE 65536


class FileBuf {
protected:
  unsigned char buf[FILEBUFSIZE];
  unsigned char *here;
  unsigned char *end;

  int fd;

  // gets a new buffer if need be, returns true if
  // more could be got. if true is returned the caller
  // can assume that here != end
  bool NextBuf ();
  
public:
  FileBuf ();

  void SetFD (int _fd);

  inline bool Get (unsigned char &c) {
    if (here != end || NextBuf()) { c = *here++; return true; }
    return false;
  }
  
  inline bool Peek (unsigned char &c) {
    if (here != end || NextBuf()) { c = *here; return true; }
    return false;
  }

  inline bool Next () {
    if (here != end || NextBuf()) { here++; return true; }
    return false;
  }
};


#endif
