/**************************************************************************
 *
 * FileBuf.cpp -- File buffer
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: FileBuf.cpp,v 1.1 2000/01/14 02:17:37 sjboddie Exp $
 *
 **************************************************************************/

#include "FileBuf.h"
#include "sysfuncs.h"


bool FileBuf::NextBuf () {
  if (fd < 0) return false;

  int numbytes = read (fd, buf, FILEBUFSIZE);
  if (numbytes < 0) numbytes = 0;
  
  here = buf;
  end = here + numbytes;

  return (numbytes > 0);
}

FileBuf::FileBuf () {
  here = end = buf;
  fd = -1;
}

void FileBuf::SetFD (int _fd) {
  here = end = buf;
  fd = _fd;
}

