/**************************************************************************
 *
 * huffman.h -- Huffman coding functions
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: huffman.h,v 1.1 2000/01/14 02:17:06 sjboddie Exp $
 *
 **************************************************************************/

#ifndef H_HUFFMAN
#define H_HUFFMAN

#include "sysfuncs.h"
#include "bitio_m_abstract.h"

#define MAX_HUFFCODE_LEN 31

struct huff_data {
  int num_codes;
  int mincodelen;
  int maxcodelen;
  int lencount[MAX_HUFFCODE_LEN + 1];
  unsigned long min_code[MAX_HUFFCODE_LEN + 1];
  char *clens;
};


huff_data *Generate_Huffman_Data (int num, long *freqs, huff_data * data,
				  u_long * mem);

unsigned long *Generate_Huffman_Codes (huff_data * data, u_long * mem);

unsigned long **Generate_Huffman_Vals (huff_data * data, u_long * mem);

int Write_Huffman_Data (FILE * f, huff_data * hd);

int Read_Huffman_Data (FILE * f, huff_data * hd, u_long * mem, u_long * disk);

/* Calculate the number of bits required to code the data with the
   specified frequencies. Normally freqs and counts should point to
   the same array. */
double Calculate_Huffman_Size (int num, long *freqs, long *counts);


#endif
