/**********************************************************************
 *
 * getpw.cpp -- 
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the 
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2000  The New Zealand Digital Library Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/

// include crypt
#if defined(__WIN32__)
#include "crypt.h"
#else
#if defined(HAVE_CRYPT_H)
#include <crypt.h>
#else 
#define _XOPEN_SOURCE 1
#include <unistd.h>
#endif
#endif

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\iostream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#else
#  include <iostream>
#endif

#include <string.h>
#include <pwd.h>

int main (int argc, char *argv[]) {

  char c[10];
  while (1) {
    char *a = getpass("Enter password:");
    int len = strlen (a);
    if (len < 3 || len > 8) {
      cerr << "Password must be between 3 and 8 characters long. Try again\n";
      continue;
    }
    strcpy (c, a);
    char *b = getpass("Re-enter password:");  
    if ((strcmp (c, b)) == 0) break;
    else cerr << "Passwords didn't match. Try again.\n";
  }

  char *salt = "Tp";
  char *pw = crypt (c, salt);

  cout << pw << "\n";
  
  return 0;
}
