###########################################################################
#
# win32 makefile -- src/colservr
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = c:\gsdl
STLPATH = c:\stlport

AR = lib
CC = cl
CPPFLAGS =
LDFLAGS =
DEFS = -DNZDL -DQUIET -D__WIN32__ -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H \
       -DSHORT_SUFFIX -DPARADOCNUM -DHAVE_CONFIG_H -D__STL_NO_NEW_IOSTREAMS \
       -DGSDLSERVER	
INCLUDES = -I$(GSDLHOME)\src\colservr -I$(GSDLHOME)\lib -I$(GSDLHOME)\src\recpt \
	   -I$(GSDLHOME)\packages\mg -I$(GSDLHOME)\packages\mg\lib \
	   -I$(GSDLHOME)\packages\mg\src\text -I$(GSDLHOME)\packages\wingdbm \
	   -I$(STLPATH)

LIBS = $(GSDLHOME)\packages\wingdbm\gdbm.lib

COMPILE = $(CC) -c $(CPPFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) $(LDFLAGS) -o $@

.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 

HEADERS = mgq.h mgsearch.h querycache.h queryinfo.h collectserver.h \
          colservrconfig.h maptools.h filter.h source.h browsefilter.h \
          queryfilter.h mggdbmsource.h phrasesearch.h phrasequeryfilter.h

SOURCES = mgq.c mgsearch.cpp querycache.cpp queryinfo.cpp collectserver.cpp \
          colservrconfig.cpp maptools.cpp filter.cpp source.cpp \
          browsefilter.cpp queryfilter.cpp mggdbmsource.cpp phrasesearch.cpp \
          phrasequeryfilter.cpp

OBJECTS = mgq.obj mgsearch.obj querycache.obj queryinfo.obj collectserver.obj \
          colservrconfig.obj maptools.obj filter.obj source.obj browsefilter.obj \
          queryfilter.obj mggdbmsource.obj phrasesearch.obj phrasequeryfilter.obj

all : $(OBJECTS)

clean:
	del *.obj

install:
