/**********************************************************************
 *
 * source.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef SOURCE_H
#define SOURCE_H

#include "gsdlconf.h"
#include "text_t.h"
#include "comtypes.h"


class sourceclass {
public:
  sourceclass ();
  virtual ~sourceclass ();

  // configure should be called once for each configuration line
  virtual void configure (const text_t &key, const text_tarray &cfgline);

  // init should be called after all the configuration is done but
  // before any other methods are called
  virtual bool init (ostream &logout);

  // translate_OID translates OIDs using ".pr", ."fc" etc.
  virtual bool translate_OID (const text_t &OIDin, text_t &OIDout, 
			      comerror_t &err, ostream &logout);

  // get_metadata fills out the metadata if possible, if it is not responsable
  // for the given OID then it will return false.
  virtual bool get_metadata (const text_t &requestParams, const text_t &refParams, 
			     bool getParents, const text_tset &fields,
			     const text_t &OID, MetadataInfo_tmap &metadata, 
			     comerror_t &err, ostream &logout);

  virtual bool get_document (const text_t &OID, text_t &doc, 
			     comerror_t &err, ostream &logout);
};


// The sourceptr class does not 'own' the source. The 
// source should be deleted by the code which created it.
class sourceptr {
public:
  sourceclass *s;

  sourceptr () {s=NULL;}
  ~sourceptr () {}
};

bool operator==(const sourceptr &x, const sourceptr &y);
bool operator<(const sourceptr &x, const sourceptr &y);

typedef vector<sourceptr> sourceptrlist;

// contains a list of sources
class sourcelistclass {
protected:
  sourceptrlist sourceptrs;

public:
  // type support for sourcelistclass
  typedef sourceptrlist::iterator iterator;
  typedef sourceptrlist::const_iterator const_iterator;
  typedef sourceptrlist::reference reference;
  typedef sourceptrlist::const_reference const_reference;
  typedef sourceptrlist::size_type size_type;

  typedef sourceptrlist::difference_type difference_type;
  typedef sourceptrlist::const_reverse_iterator const_reverse_iterator;
  typedef sourceptrlist::reverse_iterator reverse_iterator;
  
  // basic container support
  iterator begin () {return sourceptrs.begin();}
  const_iterator begin () const {return sourceptrs.begin();}
  iterator end () {return sourceptrs.end();}
  const_iterator end () const {return sourceptrs.end();}

  void erase(iterator pos) {sourceptrs.erase(pos);}
  void erase(iterator first, iterator last) {sourceptrs.erase(first, last);}
  sourcelistclass &operator=(const sourcelistclass &x) 
    {sourceptrs=x.sourceptrs;return *this;}

  bool empty () const {return sourceptrs.empty();}
  size_type size() const {return sourceptrs.size();}


  // added functionality
  void clear () {sourceptrs.erase(sourceptrs.begin(),sourceptrs.end());}

  // thesource remains the property of the calling code but
  // should not be deleted until it is removed from this list.
  void addsource (sourceclass *thesource);
};



#endif
