/**********************************************************************
 *
 * mgppsearch.h -- implementation of search class for mgpp
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * 
 *
 *********************************************************************/


#ifndef MGPPSEARCH_H
#define MGPPSEARCH_H

#include "search.h"

class mgppsearchclass : public searchclass {
public:
  mgppsearchclass ();
  virtual ~mgppsearchclass ();

  virtual text_t get_mg_type() {return "mgpp";}
 
  // the search results are returned in queryresults
  // search returns 'true' if it was able to do a search
  virtual bool search(const queryparamclass &queryparams, 
	      queryresultsclass &queryresults);
  
  // this returns a list of terms in queryresults - no document info is returned
  // returns a list of numTerms terms, starting from the query string term (in queryparams)
  // + start. used for full text browsing
  virtual bool browse_search(const queryparamclass &queryparams, int start, int numTerms,
			     queryresultsclass &queryresults);

  // the document text for 'docnum' is placed in 'output'
  // docTargetDocument returns 'true' if it was able to
  // try to get a document
  // collection is needed to see if an index from the 
  // collection is loaded. If no index has been loaded
  // defaultindex is needed to load one
  virtual bool docTargetDocument(const text_t &defaultindex,
			 const text_t &defaultsubcollection,
			 const text_t &defaultlanguage,
			 const text_t &collection,
			 int docnum,
			 text_t &output);

  /*  // same as docTargetDocument except the document is returned
  // in its raw form. UDoc remains the property of mg and may
  // be destroyed on the next call to mg.
  // not implemented for mgpp
  virtual bool mgdocument (const text_t &defaultindex,
		   const text_t &defaultsubcollection,
		   const text_t &defaultlanguage,
		   const text_t &collection,
		   int docnum,
		   char *&UDoc, int &ULen);
  */
  void set_gdbm_level(text_t &level);

 protected:
  text_t gdbm_level; // the level used in gdbm file (usu. Section, but may be 
                     // Document)

};


#endif

