/**********************************************************************
 *
 * mggdbmsource.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef MGGDBMSOURCE_H
#define MGGDBMSOURCE_H

#include "gsdlconf.h"
#include "text_t.h"
#include "comtypes.h"
#include "infodbclass.h"
#include "maptools.h"
#include "search.h"
#include "source.h"


class mggdbmsourceclass : public sourceclass {
protected:
  text_t gsdlhome;
  text_t gdbmhome;
  text_t collection;
  text_t collectdir;

  // these maps are only needed to convert the default indexes
  stringmap indexmap;
  stringmap subcollectionmap;
  stringmap languagemap;

  text_t defaultindex;
  text_t defaultsubcollection;
  text_t defaultlanguage;

  text_t parentOID;
  infodbclass parentinfo;
  text_tarray parentcontents;

  text_t gdbm_filename;
  gdbmclass *gdbmptr;
  
  searchclass *mgsearchptr;

public:
  mggdbmsourceclass ();
  virtual ~mggdbmsourceclass ();

  // the gdbmptr remains the responsability of the calling code
  void set_gdbmptr (gdbmclass *thegdbmptr) {gdbmptr=thegdbmptr;}

  // the mgsearchptr remains the responsability of the calling code
  void set_mgsearchptr (searchclass *themgsearchptr) {mgsearchptr=themgsearchptr;}

  void configure (const text_t &key, const text_tarray &cfgline);
  bool init (ostream &logout);
  bool translate_OID (const text_t &OIDin, text_t &OIDout, 
		      comerror_t &err, ostream &logout);
  bool get_metadata (const text_t &requestParams, const text_t &refParams, 
		     bool getParents, const text_tset &fields, 
		     const text_t &OID, MetadataInfo_tmap &metadata, 
		     comerror_t &err, ostream &logout);
  bool get_document (const text_t &OID, text_t &doc, 
		     comerror_t &err, ostream &logout);
};



#endif
