/**********************************************************************
 *
 * cfgread.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "cfgread.h"

int write_ini_line (ofstream &fileout, const text_t &key, const text_t value) {
  if (key.empty() || value.empty()) return -1;
  outconvertclass text_t2ascii;
  fileout << text_t2ascii << key << "=" << value << "\n";
  return 0;
}

int read_ini_line (ifstream &filein, text_t &key, text_t &value) {
  if (filein.eof()) return -1;

  key.clear();
  value.clear();
  char c;
  filein.get(c);

  int foundeq = 0;
  while (!filein.eof() && c != '\n') {
    if (!foundeq && c == '=') {foundeq = 1; filein.get(c);}

    if (foundeq) value.push_back(c);
    else key.push_back(c);
    filein.get(c);
  }
  if (key.empty()) return 0; // blank line maybe?
  return 0;
} 

// write out line of values to cfgfile
// does nothing fancy - make sure no values contain carriage returns
int write_cfg_line (ofstream &fileout, const text_tarray &values) {
  outconvertclass text_t2ascii;

  text_tarray::const_iterator here = values.begin();
  text_tarray::const_iterator end = values.end();

  bool first = true;
  while (here != end) {
    if (first) fileout << text_t2ascii << *here;
    else fileout << text_t2ascii << "  \"" << *here << "\"";
    first = false;
    here ++;
  }
  fileout << "\n";
  return 0;
}

// returns 0 on success, -1 on failure
int read_cfg_line (ifstream &filein, text_tarray &values) {
  //  outconvertclass text_t2ascii;

  values.erase(values.begin(), values.end());

  if (!filein.good()) return -1;

  text_t curvalue;
  char c, quote;

  bool linecontinues = true;
  filein.get(c);
  while (!filein.eof() && linecontinues) {
    // eat up all return characters
    while (!filein.eof() && (c=='\n' || c=='\r')) { filein.get(c); }

    // ignore comments
    if (c == '#') {
      while (!filein.eof() && c!='\n' && c!='\r') { filein.get(c); }
    }

    // deal with all the records on this line
    while (!filein.eof() && c!='\n' && c!='\r') {
      // ignore white space
      while (!filein.eof() && (c==' ' || c=='\t')) { filein.get(c); }

      // get the next record
      if (c!='\n' && c!='\r') {
	curvalue.clear();
	quote = 0;

	// see if this is a quoted record
	if (c=='\'' || c=='\"') {
	  quote = c;
	  filein.get(c);
	}

	// get the value
	while (!filein.eof() && c!='\n' && c!='\r') {
	  if (quote != 0 && c == quote) { // end of quote
	    filein.get(c);
	    break;
	  } else if (quote == 0 && (c == ' ' || c == '\t')) {
	    break; // space seperator
	  }
	  curvalue.push_back(c);
	  filein.get(c);
	}

	// see if the record continues on the next line
	if ((c=='\n' || c=='\r') && curvalue=="\\") {
	  linecontinues = true;
	} else {
	  //	  cerr << text_t2ascii << "\"" << curvalue << "\" ";
	  
	  values.push_back(curvalue);
	  curvalue.clear();
	  linecontinues = false;
	}
      }
    }
  }

  //  cerr << "\n";

  return 0;
}
