###########################################################################
#
# WordPlug.pm -- plugin for importing Microsoft Word documents
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

package WordPlug;

use ConvertToPlug;

sub BEGIN {
    @ISA = ('ConvertToPlug');
}

use strict;


sub get_default_process_exp {
    my $self = shift (@_);

    return q^(?i)\.doc$^;
}
    


# do plugin specific processing of doc_obj for HTML type
sub process {
    my $self = shift (@_);
    
    print STDERR "WordPlug: passing $_[3] onto $self->{'convert_to'} Plug\n" 
	if $self->{'verbosity'} > 1;
    
    return ConvertToPlug::process_type($self,"doc",@_);
}


1;

