###########################################################################
#
# plugin.pm -- functions to handle using plugins
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

package plugin;

require util;

sub load_plugins {
    my ($plugin_list) = shift @_;
    ($verbosity, $outhandle) = @_; # globals
    my @plugin_objects = ();

    $verbosity = 2 unless defined $verbosity;
    $outhandle = STDERR unless defined $outhandle;

    foreach $pluginoptions (@$plugin_list) {
	my $pluginname = shift @$pluginoptions;
	next unless defined $pluginname;

	# find the plugin
	my $colplugname = &util::filename_cat($ENV{'GSDLCOLLECTDIR'},"perllib/plugins", 
					      "${pluginname}.pm");
	my $mainplugname = &util::filename_cat($ENV{'GSDLHOME'},"perllib/plugins", 
					       "${pluginname}.pm");
	if (-e $colplugname) { require $colplugname; }
	elsif (-e $mainplugname) { require $mainplugname; }
	else { die "ERROR - couldn't find plugin \"$pluginname\"\n"; }

	# create a plugin object
	my ($plugobj);
	map { $_ = "\"$_\""; } @$pluginoptions;
	my $options = join (",", @$pluginoptions);
	$options =~ s/\$/\\\$/g;
	eval ("\$plugobj = new \$pluginname($options)");
	die "$@" if $@;
	
	# initialize plugin
	$plugobj->init($verbosity, $outhandle);

	# add this object to the list
	push (@plugin_objects, $plugobj);
    }

    return \@plugin_objects;
}


sub begin {
    my ($pluginfo, $base_dir, $processor, $maxdocs) = @_;

    map { $_->begin($pluginfo, $base_dir, $processor, $maxdocs); } @$pluginfo;
}

sub read {
    my ($pluginfo, $base_dir, $file, $metadata, $processor, $maxdocs, $aux) = @_;

    $maxdocs = -1 unless defined $maxdocs && $maxdocs =~ /\d/;
    my $rv = 0;

    # the .kill file is a handy (if not very elegant) way of aborting 
    # an import.pl or buildcol.pl process
    if (-e &util::filename_cat ($ENV{'GSDLCOLLECTDIR'}, ".kill")) {
	print $outhandle "Process killed by .kill file\n";
	die "\n";
    }
    
    # pass this file by each of the plugins in turn until one
    # is found which will process it
    foreach $plugobj (@$pluginfo) {
	$rv = $plugobj->read($pluginfo, $base_dir, $file, 
			     $metadata, $processor, $maxdocs, $aux);
	return $rv if defined $rv;
    }
    
    if ($verbosity >= 2) {
	print $outhandle "WARNING - no plugin could process " . 
	    &util::filename_cat($base_dir,$file) . "\n";
    }
    return 0;
}

sub end {
    my ($pluginfo, $processor) = @_;
    map { $_->end($processor); } @$pluginfo;
}

1;
