###########################################################################
#
# lang.pm --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# this module translates language descriptions to and from
# the ISO 639 standard

package lang;

@trans = (["ab", "Abkhazian"],      ["om", "Afan Oromo"],
	  ["om", "Oromo"],          ["aa", "Afar"],
	  ["af", "Afrikaans"],      ["sq", "Albanian"],
	  ["am", "Amharic"],        ["ar", "Arabic"],
	  ["hy", "Armenian"],       ["as", "Assamese"],
	  ["ay", "Aymara"],         ["az", "Azerbaijani"],

	  ["ba", "Bashkir"],        ["eu", "Basque"],
	  ["bn", "Bengali"],        ["bn", "Bangla"],
	  ["dz", "Bhutani"],        ["bh", "Bihari"],
	  ["bi", "Bislama"],        ["br", "Breton"],
	  ["bg", "Bulgarian"],      ["my", "Burmese"],
	  ["be", "Byelorussian"],

	  ["km", "Cambodian"],      ["ca", "Catalan"],
	  ["zh", "Chinese"],        ["co", "Corsican"],
	  ["hr", "Croatian"],       ["cs", "Czech"],

	  ["da", "Danish"],         ["nl", "Dutch"],

	  ["en", "English"],        ["eo", "Esperanto"],
	  ["et", "Estonian"],       ["fo", "Faroese"],
	  ["fj", "Fijian"],         ["fi", "Finnish"],
	  ["fr", "French"],         ["fy", "Frisian"],

	  ["gl", "Galician"],       ["ka", "Georgian"],
	  ["de", "German"],         ["el", "Greek"],
	  ["kl", "Greenlandic"],    ["gn", "Guarani"],
	  ["gu", "Gujarati"],

	  ["ha", "Hausa"],          ["iw", "Hebrew"],
	  ["hi", "Hindi"],          ["hu", "Hungarian"],

	  ["is", "Icelandic"],      ["in", "Indonesian"],
	  ["ia", "Interlingua"],    ["ie", "Interlingue"],
	  ["ik", "Inupiak"],        ["ga", "Irish"],
	  ["it", "Italian"],

	  ["ja", "Japanese"],       ["jv", "Javanese"],

	  ["kn", "Kannada"],        ["ks", "Kashmiri"],
	  ["kk", "Kazakh"],         ["rw", "Kinyarwanda"],
	  ["ky", "Kirghiz"],        ["rn", "Kirundi"],
	  ["ko", "Korean"],         ["ku", "Kurdish"],

	  ["lo", "Laothian"],       ["la", "Latin"],
	  ["lv", "Latvian"],        ["lv", "Lettish"],
	  ["ln", "Lingala"],        ["lt", "Lithuanian"],

	  ["mk", "Macedonian"],     ["mg", "Malagasy"],
	  ["ms", "Malay"],          ["ml", "Malayalam"],
	  ["mt", "Maltese"],        ["mi", "Maori"],
	  ["mr", "Marathi"],        ["mo", "Moldavian"],
	  ["mn", "Mongolian"],

	  ["na", "Nauru"],          ["ne", "Nepali"],
	  ["no", "Norwegian"],

	  ["oc", "Occitan"],        ["or", "Oriya"],

	  ["ps", "Pashto"],         ["ps", "Pushto"],
	  ["fa", "Persian"],        ["pl", "Polish"],
	  ["pt", "Portuguese"],     ["pa", "Punjabi"],

	  ["qu", "Quechua"],

	  ["rm", "Rhaeto-Romance"], ["ro", "Romanian"],
	  ["ru", "Russian"],

	  ["sm", "Samoan"],         ["sg", "Sangho"],
	  ["sa", "Sanskrit"],       ["gd", "Scots Gaelic"],
	  ["sr", "Serbian"],        ["sh", "Serbo-Croatian"],
	  ["st", "Sesotho"],        ["tn", "Setswana"],
	  ["sn", "Shona"],          ["sd", "Sindhi"],
	  ["si", "Singhalese"],     ["ss", "Siswati"],
	  ["sk", "Slovak"],         ["sl", "Slovenian"],
	  ["so", "Somali"],         ["es", "Spanish"],
	  ["su", "Sundanese"],      ["sw", "Swahili"],
	  ["sv", "Swedish"],

	  ["tl", "Tagalog"],        ["tg", "Tajik"],
	  ["ta", "Tamil"],          ["tt", "Tatar"],
	  ["te", "Telugu"],         ["th", "Thai"],
	  ["bo", "Tibetan"],        ["ti", "Tigrinya"],
	  ["to", "Tonga"],          ["ts", "Tsonga"],
	  ["tr", "Turkish"],        ["tk", "Turkmen"],
	  ["tw", "Twi"],

	  ["uk", "Ukrainian"],      ["ur", "Urdu"],
	  ["uz", "Uzbek"],

	  ["vi", "Vietnamese"],     ["vo", "Volapuk"],

	  ["cy", "Welsh"],          ["wo", "Wolof"],

	  ["xh", "Xhosa"],

	  ["ji", "Yiddish"],        ["yo", "Yoruba"],

	  ["zu", "Zulu"]);


sub one_english_to_iso639 {
    my ($english) = @_;
    my $iso639 = "";

    foreach $lang (@trans) {
	my $code = $lang->[0];
	my $enname = $lang->[1];
	if ($english =~ /\s*($code|$enname)\s*$/i) {
	    # found the language
	    $iso639 = $code;
	    last;

	}
    }

    return $iso639;
}


sub english_to_iso639 {
    my ($englishlist) = @_;
    my ($english);

    my @englishlist = split (",", $englishlist);
    my @iso639list = ();

    foreach $english (@englishlist) {
	push (@iso639list, &one_english_to_iso639($english));
    }

    return join (",", @iso639list);
}


sub one_iso639_to_english {
    my ($iso639) = @_;
    my $english = "";

    foreach $lang (@trans) {
	my $code = $lang->[0];
	my $enname = $lang->[1];
	if ($iso639 =~ /\s*($code|$enname)\s*$/i) {
	    # found the language
	    $english = $enname;
	    last;

	}
    }

    return $enname;
}


sub iso639_to_english {
    my ($iso639list) = @_;
    my ($iso639);

    my @iso639list = split (",", $iso639list);
    my @englishlist = ();

    foreach $iso639 (@iso639list) {
	push (@englishlist, &one_iso639_to_english($iso639));
    }

    return join (",", @englishlist);
}


1;
