###########################################################################
#
# AZSectionList.pm --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# classifier plugin for sorting sections alphabetically

# this is very similar to AZList except it sorts by
# section level metadata (excluding the top level)
# instead of just top level metadata

# the only change is to the classify() subroutine which 
# must now iterate through each section, adding each
# to the classification

package AZSectionList;

use AZList;
use sorttools;

sub BEGIN {
    @ISA = ('AZList');
}

sub print_usage {
    print STDERR "
  usage: classify AZSectionList [options]
  options:

   -metadata X    Metadata field used for classification,
                  list will be sorted by this element.

   -buttonname X  (OPTIONAL) Title field for this classification.
                  if not included title field will be Metaname. 

This is very similar to AZList except it sorts by section level metadata
(excluding the top level) instead of just top level metadata.
";
}

sub new {
    my $class = shift (@_);
    my $self = new AZList($class, @_);

    return bless $self, $class;
}

sub classify {
    my $self = shift (@_);
    my ($doc_obj) = @_;

    my $doc_OID = $doc_obj->get_OID();
    my $thissection = $doc_obj->get_next_section ($doc_obj->get_top_section());

    while (defined $thissection) {
	$self->classify_section ($thissection, $doc_obj);
	$thissection = $doc_obj->get_next_section ($thissection);
    }
}

sub classify_section {
    my $self = shift (@_);
    my ($section, $doc_obj) = @_;

    my $doc_OID = $doc_obj->get_OID();
    my $metavalue = $doc_obj->get_metadata_element ($section, $self->{'metaname'});

    # if this section doesn't contain the metadata element we're
    # sorting by we won't include it in this classification
    if (defined $metavalue && $metavalue ne "") {
	if ($self->{'metaname'} eq 'Creator') {
	    &sorttools::format_string_name_english (\$metavalue);
	} else {
	    &sorttools::format_string_english (\$metavalue);
	}
	if (defined $self->{'list'}->{"$doc_OID.$section"}) {
	    my $outhandle = $self->{'outhandle'};
	    print $outhandle "WARNING: AZSectionList::classify called multiple times " .
		"for $doc_OID.$section\n";
	} 
	$self->{'list'}->{"$doc_OID.$section"} = $metavalue;
    }
}


1;
