package preferences

# set within server

# collectionoption is only set when cross-collection searching is turned on
_collectionoption_ {}

# this macro will be set to "1" when the "source docs retrived from dl/web
# button is required - i.e. whenever PreferenceDocsFromWeb isn't set to false
# in collect.cfg
_PreferenceDocsFromWeb_ {}


#######################################################################
# java images/scripts
#######################################################################

# the _javalinks_ macros are the flashy image links at the top right of
# the page. this is overridden here as we don't want a 'preferences' 
# link on this page

_javalinks_ {_imagehome__imagehelp_}
_javalinks_ [v=1] {
_imagehome_<br>
_imagehelp_<br>
}


#######################################################################
# scripts
# note that changing either the "m" or the "o" argument
# from the preferences page necessitates reseting the "r"
# argument to 1
#######################################################################

_ccsfunctions_ {argcc = "";
savedccs = new Object();

function initialize () \{
  for (i = 0; i < document.links.length; i++)
    savedhrefs[i] = document.links[i].href;

  s = "_cgiargcc_";
  a = s.split (",");
  for (i = 0; i < a.length ;i++) \{
    for (j = 0; j < document.PrefForm.cc.length; j++) \{
      if (a[i] == document.PrefForm.elements["cc"][j].value) \{
        document.PrefForm.elements["cc"][j].checked = true;
        savedccs[a[i]] = 1;
        argcc = argcc + "&cc=" + a[i];
        break;
      \} else \{
        savedccs[a[i]] = 0;
      \}
    \}
  \}
  updatehrefs();
\}

function updatecc (collection) \{
  if (savedccs[collection] == 1) savedccs[collection] = 0;
  else savedccs[collection] = 1;
       
  var i;
  argcc = "";
  var changed = 0;
  for (i in savedccs)
    if (savedccs[i] == 1) \{
       argcc += "&cc=" + i;
       changed = 1;
    \}
  if (changed == 1) argcc += "&r=1";
  updatehrefs();
\}
}

_standardfunctions_ {
function initialize () \{
  for (i = 0; i < document.links.length; i++)
    savedhrefs[i] = document.links[i].href;
\}
}

_getargsfunction_ {
function getargs () \{
  return argk + args + argm + argo + argrd + arghd + argb + argqb + argfqn_If_(_collectionoption_,_ccsargs_)_If_(_htmloptions_,_htmlargs_);
\}
}

_ccsargs_ {+ argcc}
_htmlargs_ {+ argel + argil + argfc + arghl}

_htmlfunctions_ {argel = "";
argil = "";
argfc = "";
arghl = "";

function updateel () \{
  value = document.PrefForm.el.options[document.PrefForm.el.selectedIndex].value;
  if (value != "_cgiargel_") argel = "&el=" + value;
  else argel = "";
  updatehrefs();
\}

function updateil () \{
  value = document.PrefForm.il.options[document.PrefForm.il.selectedIndex].value;
  if (value != "_cgiargil_") argil = "&il=" + value;
  else argil = "";
  updatehrefs();
\}

function updatefc () \{
  if (document.PrefForm.fc.checked)
    _If_("_cgiargfc_" eq "1",_argfcblank_,_argfcon_)
  else 
    _If_("_cgiargfc_" ne "1",_argfcblank_,_argfcoff_)
  updatehrefs();
\}

function updatehl () \{
  if (document.PrefForm.hl.checked)
    _If_("_cgiarghl_" eq "1",_arghlblank_,_arghlon_)
  else 
    _If_("_cgiarghl_" ne "1",_arghlblank_,_arghloff_)
  updatehrefs();
\}
}

_argfcblank_ {argfc = "";}
_argfcon_ {argfc = "&fc=1&f=1";}
_argfcoff_ {argfc = "&fc=0&f=0";}

_arghlblank_ {arghl = "";}
_arghlon_ {arghl = "&hl=1";}
_arghloff_ {arghl = "&hl=0";}

_pagescriptextra_ {
// preferences scripts generated from \_preferences:pagescriptextra\_

savedhrefs = new Object();

argk = "";
args = "";		
argm = "";
argrd = "";
argo = "";
argb = "";
arghd = "";
argqb = "";
argfqn = "";

_If_(_collectionoption_,_ccsfunctions_,_standardfunctions_)
_If_(_htmloptions_,_htmlfunctions_)
_getargsfunction_
function updatehrefs () \{
  for (i = 0; i < document.links.length; i++)
    document.links[i].href = savedhrefs[i] + getargs();
\}

function updatek (value) \{
  if (value != _cgiargk_) argk = "&k=" + value;
  else argk = "";
  updatehrefs();
\}

function updates (value) \{
  if (value != _cgiargs_) args = "&s=" + value;
  else args = "";
  updatehrefs();
\}

function updatem () \{
  value = document.PrefForm.m.options[document.PrefForm.m.selectedIndex].value;
  if (value != _cgiargm_) argm = "&r=1&m=" + value;
  else argm = "";
  updatehrefs();
\}

function updaterd () \{
  if (document.PrefForm.rd.checked)
    _If_("_cgiargrd_" eq "1",argrd="";,argrd="&rd=1";)
  else 
    _If_("_cgiargrd_" ne "1",argrd="";,argrd="&rd=0";)
  updatehrefs();
\}

function updateo () \{
  value = document.PrefForm.o.options[document.PrefForm.o.selectedIndex].value;
  if (value != _cgiargo_) argo = "&r=1&o=" + value;
  else argo = "";
  updatehrefs();
\}

function updatefqn () \{
  value = document.PrefForm.fqn.options[document.PrefForm.fqn.selectedIndex].value;
  if (value != _cgiargfqn_) argfqn = "&fqn=" + value;
  else argfqn = "";
  updatehrefs();
\}

function updateb (value) \{
  if (value != _cgiargb_) argb = "&b=" + value;
  else argb = "";
  updatehrefs();
\}

function updatehd() \{
  arghd="";
  if (document.PrefForm.hd[0].checked) \{
     if ("_cgiarghd_" != "0") arghd = "&hd=0";
  \}
  else \{
     value = document.PrefForm.hdn[document.PrefForm.hdn.selectedIndex].value;
     if (_cgiarghd_ != value) arghd = "&hd="+value;
  \}
  updatehrefs();
\}

function updateqb(value) \{
  if (value != _cgiargqb_) argqb = "&qb=" + value;
  else argqb = "";
  updatehrefs();
\}

function updatel () \{
  value = document.PrefForm.l.options[document.PrefForm.l.selectedIndex].value;
  location.href = location.href + "&nl=1&l=" + value + getargs();
\}

function updatev () \{
  value = document.PrefForm.v.options[document.PrefForm.v.selectedIndex].value;
  location.href = location.href + "&v=" + value + getargs();
\}

function updatew () \{
  value = document.PrefForm.w.options[document.PrefForm.w.selectedIndex].value;
  location.href = location.href + "&nl=0&nw=" + value + getargs();
\}

function updateqt () \{
  value = document.PrefForm.qt.options[document.PrefForm.qt.selectedIndex].value;
  location.href = location.href + "&qt=" + value + getargs();
\}
}


#######################################################################
# headers
# these are overridden so we can put an onLoad event handler
# in the <body> tag of this page
#######################################################################


_header_ {_cgihead_
_htmlhead_(background="_httpiconchalk_" onLoad="initialize();")_startspacer__pagebanner_
}

# this declaration ends up being the same as style=restrict, never mind
_header_[v=1] {_cgihead_
_htmlhead_(onLoad="initialize();")_pagebanner_
}


#######################################################################
# page content
#######################################################################

_pagetitle_ {_collectionname_: _textpreferences_}
_imagethispage_ {_iconthispage_}

_htmloptions_ {}

_htmloptionson_ {
<p>
<tr><td colspan=2>_fcoption_</td></tr>
<p>
<tr><td colspan=2>_hloption_</td></tr>
<p>
<tr>_extlinkoption_</tr>
_If_(_PreferenceDocsFromWeb_,<p>
<tr>_intlinkoption_</tr>)
}

_fcoption_ {
<input type=checkbox name=fc onClick="updatefc();"_If_("_cgiargfc_" eq "1", checked)> 
_textfcoption_
}

_hloption_ {
<input type=checkbox name=hl onClick="updatehl();"_If_("_cgiarghl_" eq "1", checked)> 
_texthloption_
}

#search pref options
_boxsizeoption_{
<td valign=baseline>_textqueryboxsize_</td>
<td><input type=radio name=qb value=0 onClick="updateqb(0);"
		_If_(_cgiargqb_,, checked)>_textregbox_<br>
<input type=radio name=qb value=1 onClick="updateqb(1);"
		_If_(_cgiargqb_, checked)>_textbigbox_</td>
}

_caseoption_ {
<td valign=baseline>_textcasediffs_</td>
<td><input type=radio name=k value=1 onClick="updatek(1);"
		_If_(_cgiargk_, checked)>_textignorecase_<br>
<input type=radio name=k value=0 onClick="updatek(0);"
		_If_(_cgiargk_,, checked)>_textmatchcase_</td>
}

_caseoption_ [l=ar] {}
_caseoption_ [l=zh] {}

_stemoption_ {
<td valign=baseline>_textwordends_</td>
<td><input type=radio name=s value=1 onClick="updates(1);"
  _If_(_cgiargs_, checked)>_textstem_<br>
<input type=radio name=s value=0 onClick="updates(0);"
  _If_(_cgiargs_,, checked)>_textnostem_</td>
}

_stemoption_ [l=zh] {}


_modeoption_ {
<td valign=baseline>_textquerymode_</td>
<td><input type=radio name=b value=0 onClick="updateb(0);"
		_If_(_cgiargb_,, checked)>_textsimplemode_<br>
<input type=radio name=b value=1 onClick="updateb(1);"
		_If_(_cgiargb_, checked)>_textadvancedmode_</td>
}


_searchhistoryop_ {
<td valign=baseline>_textsearchhistory_</td>
<td><input type=radio name="hd" value=0 onClick="updatehd();"
                _If_("_cgiarghd_" eq "0", checked)>_textnohistorydisplay_<br>
<input type=radio name="hd" value=1 onClick="updatehd();"
		_If_("_cgiarghd_" eq "0",, checked)>_texthistorydisplay_</td>   
}

_relateddocop_ {
<td colspan=2><nobr><input type=checkbox name="rd" onClick="updaterd();" _If_("_cgiargrd_" eq "1", checked)>
Display related documents</nobr></td>
}

_historynumrecords_{<select name="hdn" onChange="updatehd();">
    <option value="5"_If_("_cgiarghd_" eq "5", selected)>5
    <option value="10"_If_("_cgiarghd_" eq "10", selected)>10
    <option value="15"_If_("_cgiarghd_" eq "15", selected)>15
    <option value="20"_If_("_cgiarghd_" eq "20", selected)>20
</select>}

_maxdocoption_ {
<select name="m" onChange="updatem();">
  <option value="50"_If_("_cgiargm_" eq "50", selected)>50
  <option value="100"_If_("_cgiargm_" eq "100", selected)>100
  <option value="200"_If_("_cgiargm_" eq "200", selected)>200
</select>
}

_hitsperpageoption_ {
<select name="o" onChange="updateo();">
  <option value="10"_If_("_cgiargo_" eq "10", selected)>10  
  <option value="20"_If_("_cgiargo_" eq "20", selected)>20
  <option value="50"_If_("_cgiargo_" eq "50", selected)>50
  <option value="100")_If_("_cgiargo_" eq "100", selected)>_textall_
</select>
}

_extlinkoption_ {
<td>_textextlink_</td>
<td><select name="el" onChange="updateel();">
  <option value="prompt"_If_("_cgiargel_" eq "prompt", selected)>
     _textlinkinterm_
  <option value="direct"_If_("_cgiargel_" eq "direct", selected)>
     _textlinkdirect_
</select></td>
}

_intlinkoption_ {
<td>_textintlink_</td>
<td><select name="il" onChange="updateil();">
  <option value="l"_If_("_cgiargil_" eq "l", selected)>
     _textdigitlib_
  <option value="w"_If_("_cgiargil_" eq "w", selected)>
     _textweb_
</select></td>
}

# set from within pageaction
_languageoption_ {}
_encodingoption_ {}

_formatoption_ {
<td>_textformat_</td>
<td><select name="v" onChange="updatev();">
  <option value="0"_If_("_cgiargv_" eq "0", selected)>_textgraphical_
  <option value="1"_If_("_cgiargv_" eq "1", selected)>_texttextual_
</select></td>
}

_content_ {
<center>
_navigationbar_
</center>

<blockquote>

<form name=PrefForm method=get action="_gwcgi_">

<input type="hidden" name="e" value="_decodedcompressedoptions_">

_If_(_collectionoption_,_collectionprefs_)
_presentationprefs_
_If_("_cgiargct_" eq "1",_mgppsearchprefs_,_mgsearchprefs_)

</blockquote>
</form>
}

#search prefs for mg collections
_mgsearchprefs_ {
<h3>_textsearchprefs_</h3>
<table>
<tr>_boxsizeoption_</tr>

<tr>_caseoption_</tr>

<tr>_stemoption_</tr>

<tr>_modeoption_</tr>

<tr>_searchhistoryop_</tr>

<tr>_relateddocop_</tr>

<tr><td colspan=2>_textprefop_</td></tr>
</table>
</blockquote>
_iconblankbar_
<blockquote>
}

_collectionprefs_ {
<h3>_textcollectionprefs_</h3>
_collectionoption_
</blockquote>
_iconblankbar_
<blockquote>
}

_presentationprefs_ {
<h3>_textpresentationprefs_</h3>
<table>_htmloptions_

_If_(_languageoption_,<tr><td>_textlanguage_</td><td>_languageoption_</td></tr>)

_If_(_encodingoption_,<tr><td>_textencoding_</td><td>_encodingoption_</td></tr>)

<tr>_formatoption_</tr></table>
</blockquote>
_iconblankbar_
<blockquote>
}

#######################################################
## new stuff for prefs for form vs text search - for mgpp collections
_mgppsearchprefs_ {
<h3>_textsearchprefs_</h3>
<table>
<tr>_searchtypeop_</tr>

_If_(_cgiargqt_,_formsearchoptions_,_textsearchoptions_)

<tr>_caseoption_</tr>

<tr>_stemoption_</tr>

<tr>_searchhistoryop_</tr>

<tr><td colspan=2>_textprefop_</td></tr></table>
</blockquote>
_iconblankbar_
<blockquote>
}


_searchtypeop_ {
<td>_texttypesearch_</td>
<td><select name="qt" onChange="updateqt();">
  <option value="0"_If_("_cgiargqt_" eq "0", selected)>_texttextsearch_
  <option value="1"_If_("_cgiargqt_" eq "1", selected)>_textformsearch_
</select></td>
}

_formsearchoptions_ {
<tr>_formmodeoption_</tr>
}

_textsearchoptions_ {
<tr>_boxsizeoption_</tr>
<tr>_modeoption_</tr>
}

_formmodeoption_{
<td valign=baseline>_textformtype_</td>
<td><input type=radio name=b value=0 onClick="updateb(0);"
		_If_(_cgiargb_,, checked)>_textsimple_<br>
<input type=radio name=b value=1 onClick="updateb(1);"
		_If_(_cgiargb_, checked)>_textadvanced_<br>
_formnumoption_</td>
}

_formnumoption_ {_textwith_
<select name="fqn" onChange="updatefqn();">
  <option value="2"_If_("_cgiargfqn_" eq "2", selected)>2  
  <option value="4"_If_("_cgiargfqn_" eq "4", selected)>4
  <option value="6"_If_("_cgiargfqn_" eq "6", selected)>6
  <option value="8"_If_("_cgiargfqn_" eq "8", selected)>8
</select>_textfields_</td>
}


#######################################################################
# icons
#######################################################################

_iconthispage_ {<img src="_httpiconhpref_" alt="_textpreferences_" width="_widthhpref_" height="_heighthpref_">}
