######################################################################
#
# Dutch Language text and icon macros, translated 8.9.2000
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.
#
# Under the 'text macros' comments are text macros of the form:
# _macroname_ {macro value}
# Everything between the {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Under the 'icons' comments are macros concerned with displaying
# icons which themselves contain text.
# Above each macro (or group of macros) for an icon is a comment line
# that looks something like '## "HOME" ## top_nav_button ## chome ##'.
# The first field of the comment ("HOME" in this case) is the text
# that appears in the english version of the icon. This is the text
# that must be translated, nothing needs to be done to the macros 
# themselves. The other two fields of the comments are used by 
# automatic icon generating software which reads the newly translated
# file and generates appropriate icons.
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################


######################################################################
# Global (base) package
package Global
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultcontent_ [l=nl] {De vereisde pagina kon niet worden gevonden. 
Gebruik de terug knop van de browser of de home knop om naar de hoofdpagina 
van de Greenstone Digitale Bibliotheek terug te keren.}

_textdefaulttitle_ [l=nl] {GSDL Error}

_collectionextra_ [l=nl] {Deze collectie bevat _about:numdocs_ documenten. 
De collectie werd _about:builddate_ dagen geleden vervaardigd.}

_textimagecollection_ [l=nl] {}
_textimageabout_ [l=nl] {Informatie-pagina}
_textimagehome_ [l=nl] {Hoofdpagina}
_textimagehelp_ [l=nl] {Helppagina}
_textimagepref_ [l=nl] {Preferenctie-pagina}
_textimagegreenstone_ [l=nl] {Greenstone Digital Library Software}

_textimagesearch_ [l=nl] {Zoeken specifieke termen}
_textimageTitle_ [l=nl] {Browsen titels in alfabetische orde}
_textimageList_ [l=nl] {Browsen documenten lijst}
_textimageCreator_ [l=nl] {Browsen alfabeitsche lijst van auteurs}
_textimageSeries_ [l=nl] {Browsen volgens uitgaven}
_textimageDate_ [l=nl] {Browsen volgens datum}
_textimageSubject_ [l=nl] {Browsen volgens onderwerpen}
_textimageTo_ [l=nl] {Browsen volgens geadresseerde}
_textimageFrom_ [l=nl] {Browsen volges afzender}
_textimageOrganization_ [l=nl] {Browsen volgens organisaties}
_textimageHowto_ [l=nl] {Browsen volgens help onderwerpen}
_textimageTopic_ [l=nl] {Browsen volgens speciale themas}
_textimageBrowse_ [l=nl] {Browsen}
_textimagePeople_ [l=nl] {Browsen alfabetische personenlijst}
_textimageLanguage_ [l=nl] {Browsen volgens taal}
_textimageAcronyms_ [l=nl] {Browsen volgens afkortingen}

_texticontabsearchgreen_ [l=nl] {Zoeken}
_texticontabdategreen_ [l=nl] {Datums}
_texticontabseriesgreen_ [l=nl] {Reeksen}
_texticontabauthorgreen_ [l=nl] {Auteurs A-Z}
_texticontabtitlegreen_ [l=nl] {Titels A-Z}
_texticontablistgreen_ [l=nl] {Lijsten}
_texticontabsubjectgreen_ [l=nl] {Onderwerpen}
_texticontabtogreen_ [l=nl] {Geadresseerde}
_texticontabfromgreen_ [l=nl] {Afzender}
_texticontaborggreen_ [l=nl] {Organisatie}
_texticontabhowgreen_ [l=nl] {Help}
_texticontabtopicgreen_ [l=nl] {Themas}
_texticontabbrwsegreen_ [l=nl] {Browsen}
_texticontabPeoplegreen_ [l=nl] {Personen A-Z}
_texticontabLanguagegreen_ [l=nl] {Taalen}
_texticontabAcronymsgreen_ [l=nl] {Afkortingen}

_texticontext_ [l=nl] {Documenten weergeven}
_texticonclosedbook_ [l=nl] {Dokument openen en inhoud op het scherm brengen}
_texticonnext_ [l=nl] {naar de volgende sectie}
_texticonprev_ [l=nl] {naar de vooafgaande sectie}

_page_ [l=nl] {pagina }
_pages_ [l=nl] {paginas}
_of_ [l=nl] { uit }
_vol_ [l=nl] {Deel}
_num_ [l=nl] {Nummer}

_textmonth00_ [l=nl] {}
_textmonth01_ [l=nl] {Januari}
_textmonth02_ [l=nl] {Februari}
_textmonth03_ [l=nl] {Maart}
_textmonth04_ [l=nl] {April}
_textmonth05_ [l=nl] {Mei}
_textmonth06_ [l=nl] {Juni}
_textmonth07_ [l=nl] {Juli}
_textmonth08_ [l=nl] {Augustus}
_textmonth09_ [l=nl] {September}
_textmonth10_ [l=nl] {Oktober}
_textmonth11_ [l=nl] {November}
_textmonth12_ [l=nl] {December}

_Document_ [l=nl] {Document}
_Section_ [l=nl] {Sectie}
_Paragraph_ [l=nl] {Alinea}

_magazines_ [l=nl] {tijdschriften}

_nzdlpagefooter_ [l=nl] {<p>_iconblankbar_
<p><a href="http://www.nzdl.org">New Zealand Digital Library Project</a>
<br><a href="http://www.cs.waikato.ac.nz/cs">Department of Computer Science</a>, 
<a href="http://www.waikato.ac.nz">University of Waikato</a>, 
New Zealand}

#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "HOOFDPAGINA" ## top_nav_button ## chome ##
_httpiconchomeof_ [l=nl] {_httpimg_/nl/chomeof.gif}
_httpiconchomeon_ [l=nl] {_httpimg_/nl/chomeon.gif}
_widthchomex_ [l=nl] {92}
_heightchomex_ [l=nl] {20}

## "HELP" ## top_nav_button ## chelp ##
_httpiconchelpof_ [l=nl] {_httpimg_/nl/chelpof.gif}
_httpiconchelpon_ [l=nl] {_httpimg_/nl/chelpon.gif}
_widthchelpx_ [l=nl] {32}
_heightchelpx_ [l=nl] {20}

## "PREFERENTIES" ## top_nav_button ## cpref ##
_httpiconcprefof_ [l=nl] {_httpimg_/nl/cprefof.gif}
_httpiconcprefon_ [l=nl] {_httpimg_/nl/cprefon.gif}
_widthcprefx_ [l=nl] {85}
_heightcprefx_ [l=nl] {20}

## "help" ## green_title ## h_help ##
_httpiconhhelp_ [l=nl] {_httpimg_/nl/h\_help.gif}
_widthhhelp_ [l=nl] {200}
_heighthhelp_ [l=nl] {57}

## "auteurs a-z" ## nav_bar_button ## tauth ##
_httpicontauthgr_ [l=nl] {_httpimg_/nl/tauthgr.gif}
_httpicontauthof_ [l=nl] {_httpimg_/nl/tauthof.gif}
_httpicontauthon_ [l=nl] {_httpimg_/nl/tauthon.gif}
_widthtauthx_ [l=nl] {100}
_heighttauthx_ [l=nl] {17}

## "reksen" ## nav_bar_button ## tser ##
_httpicontsergr_ [l=nl] {_httpimg_/nl/tsergr.gif}
_httpicontserof_ [l=nl] {_httpimg_/nl/tserof.gif}
_httpicontseron_ [l=nl] {_httpimg_/nl/tseron.gif}
_widthtserx_ [l=nl] {87}
_heighttserx_ [l=nl] {17}

## "datums" ## nav_bar_button ## tdate ##
_httpicontdategr_ [l=nl] {_httpimg_/nl/tdategr.gif}
_httpicontdateof_ [l=nl] {_httpimg_/nl/tdateof.gif}
_httpicontdateon_ [l=nl] {_httpimg_/nl/tdateon.gif}
_widthtdatex_ [l=nl] {87}
_heighttdatex_ [l=nl] {17}

## "onderwerpen" ## nav_bar_button ## tsubj ##
_httpicontsubjgr_ [l=nl] {_httpimg_/nl/tsubjgr.gif}
_httpicontsubjon_ [l=nl] {_httpimg_/nl/tsubjon.gif}
_httpicontsubjof_ [l=nl] {_httpimg_/nl/tsubjof.gif}
_widthtsubjx_ [l=nl] {110}
_heighttsubjx_ [l=nl] {17}

## "geadresseerde" ## nav_bar_button ## tto ##
_httpiconttogr_ [l=nl] {_httpimg_/nl/ttogr.gif}
_httpiconttoon_ [l=nl] {_httpimg_/nl/ttoon.gif}
_httpiconttoof_ [l=nl] {_httpimg_/nl/ttoof.gif}
_widthttox_ [l=nl] {122}
_heightttox_ [l=nl] {17}

## "afzender" ## nav_bar_button ## tfrom ##
_httpicontfromgr_ [l=nl] {_httpimg_/nl/tfromgr.gif}
_httpicontfromon_ [l=nl] {_httpimg_/nl/tfromon.gif}
_httpicontfromof_ [l=nl] {_httpimg_/nl/tfromof.gif}
_widthtfromx_ [l=nl] {87}
_heighttfromx_ [l=nl] {17}

## "organisatie" ## nav_bar_button ## torg ##
_httpicontorggr_ [l=nl] {_httpimg_/nl/torggr.gif}
_httpicontorgon_ [l=nl] {_httpimg_/nl/torgon.gif}
_httpicontorgof_ [l=nl] {_httpimg_/nl/torgof.gif}
_widthtorgx_ [l=nl] {94}
_heighttorgx_ [l=nl] {17}

## "help onderwerpen" ## nav_bar_button ## thow ##
_httpiconthowgr_ [l=nl] {_httpimg_/nl/thowgr.gif}
_httpiconthowon_ [l=nl] {_httpimg_/nl/thowon.gif}
_httpiconthowof_ [l=nl] {_httpimg_/nl/thowof.gif}
_widththowx_ [l=nl] {151}
_heightthowx_ [l=nl] {17}

## "thema" ## nav_bar_button ## ttopic ##
_httpiconttopicgr_ [l=nl] {_httpimg_/nl/ttopicgr.gif}
_httpiconttopicon_ [l=nl] {_httpimg_/nl/ttopicon.gif}
_httpiconttopicof_ [l=nl] {_httpimg_/nl/ttopicof.gif}
_widthttopicx_ [l=nl] {87}
_heightttopicx_ [l=nl] {17}

## "browsen" ## nav_bar_button ## tbrwse ##
_httpicontbrwsegr_ [l=nl] {_httpimg_/nl/tbrwsegr.gif}
_httpicontbrwseon_ [l=nl] {_httpimg_/nl/tbrwseon.gif}
_httpicontbrwseof_ [l=nl] {_httpimg_/nl/tbrwseof.gif}
_widthtbrwsex_ [l=nl] {87}
_heighttbrwsex_ [l=nl] {17}

## "zoeken" ## nav_bar_button ## tsrch ##
_httpicontsrchgr_ [l=nl] {_httpimg_/nl/tsrchgr.gif}
_httpicontsrchof_ [l=nl] {_httpimg_/nl/tsrchof.gif}
_httpicontsrchon_ [l=nl] {_httpimg_/nl/tsrchon.gif}
_widthtsrchx_ [l=nl] {87}
_heighttsrchx_ [l=nl] {17}

## "titels a-z" ## nav_bar_button ## ttitl ##
_httpiconttitlgr_ [l=nl] {_httpimg_/nl/ttitlgr.gif}
_httpiconttitlof_ [l=nl] {_httpimg_/nl/ttitlof.gif}
_httpiconttitlon_ [l=nl] {_httpimg_/nl/ttitlon.gif}
_widthttitlx_ [l=nl] {87}
_heightttitlx_ [l=nl] {17}

## "personen" ## nav_bar_button ## tpeop ##
_httpicontpeopgr_ [l=nl] {_httpimg_/nl/tpeopgr.gif}
_httpicontpeopof_ [l=nl] {_httpimg_/nl/tpeopof.gif}
_httpicontpeopon_ [l=nl] {_httpimg_/nl/tpeopon.gif}
_widthtpeopx_ [l=nl] {87}
_heighttpeopx_ [l=nl] {17}

## "taal" ## nav_bar_button ## tlang ##
_httpicontlanggr_ [l=nl] {_httpimg_/nl/tlanggr.gif}
_httpicontlangon_ [l=nl] {_httpimg_/nl/tlangon.gif}
_httpicontlangof_ [l=nl] {_httpimg_/nl/tlangof.gif}
_widthtlangx_ [l=nl] {87}
_heighttlangx_ [l=nl] {17}

## "afkortingen" ## nav_bar_button ## tacro ##
_httpicontacrogr_ [l=nl] {_httpimg_/nl/tacrogr.gif}
_httpicontacroof_ [l=nl] {_httpimg_/nl/tacroof.gif}
_httpicontacroon_ [l=nl] {_httpimg_/nl/tacroon.gif}
_widthtacrox_ [l=nl] {98}
_heighttacrox_ [l=nl] {17}





######################################################################
# 'about' page
package about
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textabcol_ [l=nl] {informatie over deze collectie}

_textsubcols1_ [l=nl] {<p>De volledige collectie bevat _1_ subcollecties:
<blockquote>}

_textsubcols2_ [l=nl] {</blockquote>
Voor het controleren en veranderen van subcollecties in gebruik 
ga naar de preferentie pagina.}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "informatie" ## green_title ## h_about ##
_httpiconhabout_ [l=nl] {_httpimg_/nl/h\_about.gif}
_widthhabout_ [l=nl] {200}
_heighthabout_ [l=nl] {57}



######################################################################
# document package
package document
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textTitlepage_ [l=nl] {_texticonhtitle_}
_textCreatorpage_ [l=nl] {_texticonhauth_}
_textSubjectpage_ [l=nl] {_texticonhsubj_}
_textTopage_ [l=nl] {_texticonhto_}
_textFrompage_ [l=nl] {_texticonhfrom_}
_textSeriespage_ [l=nl] {_texticonhser_}
_textDatepage_ [l=nl] {_texticonhdate_}
_textHowtopage_ [l=nl] {_texticonhhow_}
_textOrganizationpage_ [l=nl] {_texticonhorg_}
_textBrowsepage_ [l=nl] {_texticonhbrwse_}
_textPeoplepage_ [l=nl] {_texticonhpeople_}
_textLanguagepage_ [l=nl] {_texticonhlanguage_}
_textAcronymspage_ [l=nl] {_texticonhacronyms_}

_texticonhtitle_ [l=nl] {Titels A-Z}
_texticonhauth_ [l=nl] {Auteurs A-Z}
_texticonhsubj_ [l=nl] {Onderwerpen}
_texticonhto_ [l=nl] {Geadresseerde}
_texticonhfrom_ [l=nl] {Afzender}
_texticonhser_ [l=nl] {Reeksen}
_texticonhdate_ [l=nl] {Datums}
_texticonhhow_ [l=nl] {Help onderwerpen}
_texticonhorg_ [l=nl] {Organizaties}
_texticonhbrwse_ [l=nl] {Browsen}
_texticonhpeople_ [l=nl] {Personen A-Z}
_texticonhlanguage_ [l=nl] {Taalen}
_texticonhacronyms_ [l=nl] {Afkortingen}

_texticonopenbookshelf_ [l=nl] {Sluit dit gedeelte van de bibliotheek}
_texticonclosedbookshelf_ [l=nl] {Open dit tgedeelte van de bibliotheek en bring de inhoud op het scherm.}
_texticonopenbook_ [l=nl] {Sluit dit boek}
_texticonclosedfolder_ [l=nl] {Open deze map en breng de inhoud op het scherm}
_texticonclosedfolder2_ [l=nl] {Open deze onder-sectie:}
_texticonopenfolder_ [l=nl] {Sluit deze map: }
_texticonopenfolder2_ [l=nl] {Sluit deze onder sectie: }
_texticonsmalltext_ [l=nl] {Geef deze sectie van de tekst weer}
_texticonsmalltext2_ [l=nl] {Geef tekst weer: }
_texticonpointer_ [l=nl] {Actueele sectie}
_texticondetach_ [l=nl] {Open en nieuw venster voor deze pagina}
_texticonhighlight_ [l=nl] {Accentueer zoek termen}
_texticonnohighlight_ [l=nl] {Accentueer zoek termen niet}
_texticoncontracttoc_ [l=nl] {Inhoudsopgave inkorten}
_texticonexpandtoc_ [l=nl] {Inhouds opgave uitbreiden}
_texticonexpandtext_ [l=nl] {Hele tekst weergeven}
_texticoncontracttext_ [l=nl] {Alleen maar geselecteerde tekst weergeven}
_texticonwarning_ [l=nl] {<b>Waarschuiving: </b>}
_texticoncont_ [l=nl] {Voortzetten?}

_textltwarning_ [l=nl] {
<p><center>
<table cellspacing=0 cellpadding=0 width=_pagewidth_>
<tr valign=top><td>_iconwarning_Het Uitbreiden van deze tekst zal 
een grote hoeveelheid data produceeren om _imagecont_ door de browser 
weer te geven.
</td></tr></table></center>
}

_textgoto_ [l=nl] {Ga naar pagina}
_textintro_ [l=nl] { <i>(Inleidende tekst)</i>}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "titels a-z" ## green_title ## h_title ##
_httpiconhtitle_ [l=nl] {_httpimg_/nl/h\_title.gif}
_widthhtitle_ [l=nl] {200}
_heighthtitle_ [l=nl] {57}

## "auteurs a-z" ## green_title ## h_auth ##
_httpiconhauth_ [l=nl] {_httpimg_/nl/h\_auth.gif}
_widthhauth_ [l=nl] {200}
_heighthauth_ [l=nl] {57}

## "onderwerpen" ## green_title ## h_subj ##
_httpiconhsubj_ [l=nl] {_httpimg_/nl/h\_subj.gif}
_widthhsubj_ [l=nl] {200}
_heighthsubj_ [l=nl] {57}

## "geadresseerde" ## green_title ## h_to ##
_httpiconhto_ [l=nl] {_httpimg_/nl/h\_to.gif}
_widthhto_ [l=nl] {200}
_heighthto_ [l=nl] {57}

## "afzenders" ## green_title ## h_from ##
_httpiconhfrom_ [l=nl] {_httpimg_/nl/h\_from.gif}
_widthhfrom_ [l=nl] {200}
_heighthfrom_ [l=nl] {57}

## "reeksen" ## green_title ## h_ser ##
_httpiconhser_ [l=nl] {_httpimg_/nl/h\_ser.gif}
_widthhser_ [l=nl] {200}
_heighthser_ [l=nl] {57}

## "datums" ## green_title ## h_date ##
_httpiconhdate_ [l=nl] {_httpimg_/nl/h\_date.gif}
_widthhdate_ [l=nl] {200}
_heighthdate_ [l=nl] {57}

## "help onderwerpen" ## green_title ## h_how ##
_httpiconhhow_ [l=nl] {_httpimg_/nl/h\_how.gif}
_widthhhow_ [l=nl] {200}
_heighthhow_ [l=nl] {57}

## "themas" ## green_title ## h_topic ##
_httpiconhtopic_ [l=nl] {_httpimg_/nl/h\_topic.gif}
_widthhtopic_ [l=nl] {200}
_heighthtopic_ [l=nl] {57}

## "organisaties" ## green_title ## h_org ##
_httpiconhorg_ [l=nl] {_httpimg_/nl/h\_org.gif}
_widthhorg_ [l=nl] {250}
_heighthorg_ [l=nl] {57}

## "browsen" ## green_title ## h_brwse ##
_httpiconhbrwse_ [l=nl] {_httpimg_/nl/h\_brwse.gif}
_widthhbrwse_ [l=nl] {200}
_heighthbrwse_ [l=nl] {57}

## "personen" ## green_title ## h_people ##
_httpiconhpeople_ [l=nl] {_httpimg_/nl/h\_people.gif}
_widthhpeople_ [l=nl] {200}
_heighthpeople_ [l=nl] {57}

## "taalen" ## green_title ## h_lang ##
_httpiconhlanguage_ [l=nl] {_httpimg_/nl/h\_lang.gif}
_widthhlanguage_ [l=nl] {200}
_heighthlanguage_ [l=nl] {57}

## "afkortingen" ## green_title ## h_acro ##
_httpiconhacronyms_ [l=nl] {_httpimg_/nl/h\_acro.gif}
_widthhacronyms_ [l=nl] {200}
_heighthacronyms_ [l=nl] {57}

## "VOORTZETTEN?" ## top_nav_button ## cont ##
_httpiconcontoff_ [l=nl] {_httpimg_/nl/contoff.gif}
_httpiconconton_ [l=nl] {_httpimg_/nl/conton.gif}
_widthcontx_ [l=nl] {97}
_heightcontx_ [l=nl] {17}

## "     TEKST
UITBREIDEN" ## document_button ## eallt ## 
_httpiconealltof_ [l=nl] {_httpimg_/nl/ealltof.gif}
_httpiconeallton_ [l=nl] {_httpimg_/nl/eallton.gif}
_widthealltx_ [l=nl] {65}
_heightealltx_ [l=nl] {30}

## "  INHOUD
INKRIMPEN" ## document_button ## econc ##
_httpiconeconcof_ [l=nl] {_httpimg_/nl/econcof.gif}
_httpiconeconcon_ [l=nl] {_httpimg_/nl/econcon.gif}
_widtheconcx_ [l=nl] {65}
_heighteconcx_ [l=nl] {30}

## "  NIEUW
VENSTER" ## document_button ## edtch ##
_httpiconedtchof_ [l=nl] {_httpimg_/nl/edtchof.gif}
_httpiconedtchon_ [l=nl] {_httpimg_/nl/edtchon.gif}
_widthedtchx_ [l=nl] {65}
_heightedtchx_ [l=nl] {30}

## "  INHOUD 
UITBREIDEN" ## document_button ## eexpc ##
_httpiconeexpcof_ [l=nl] {_httpimg_/nl/eexpcof.gif}
_httpiconeexpcon_ [l=nl] {_httpimg_/nl/eexpcon.gif}
_widtheexpcx_ [l=nl] {65}
_heighteexpcx_ [l=nl] {30}

## "   TEKST
INKRIMPEN" ## document_button ## etsec ##
_httpiconetsecof_ [l=nl] {_httpimg_/nl/etsecof.gif}
_httpiconetsecon_ [l=nl] {_httpimg_/nl/etsecon.gif}
_widthetsecx_ [l=nl] {65}
_heightetsecx_ [l=nl] {30}

## "ACCENTUEREN" ## document_button ## ehl ##
_httpiconehlof_ [l=nl] {_httpimg_/nl/ehlof.gif}
_httpiconehlon_ [l=nl] {_httpimg_/nl/ehlon.gif}
_widthehlx_ [l=nl] {74}
_heightehlx_ [l=nl] {30}

## "        NIET
ACCENTUEREN" ## document_button ## enhl ##
_httpiconenhlof_ [l=nl] {_httpimg_/nl/enhlof.gif}
_httpiconenhlon_ [l=nl] {_httpimg_/nl/enhlon.gif}
_widthenhlx_ [l=nl] {74}
_heightenhlx_ [l=nl] {30}



######################################################################
# 'search' page
package query
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches
_textquerytitle_ [l=nl] {_If_(_thislast_, _thisfirst_ - _thislast_ resultaten voor de zoekactie: _cgiargq_,geen resultaat voor de zoekactie: _cgiargq_)}
_textnoquerytitle_ [l=nl] {Zoek pagina}

_texticonthispage_ [l=nl] {doorzoeken van}
_textsome_ [l=nl] {_If_(_cgiargb_,gestaffelde,somige)}
_textall_ [l=nl] {_If_(_cgiargb_,boolse,alle)}
_texticonqueryresultsbar_ [l=nl] {}
_textfreqmsg1_ [l=nl] {aantal woorden: }
_textpostprocess_ [l=nl] {_If_(_quotedquery_,<br><i>verder verwerkt om _quotedquery_ te vinden</i>
)}

_textmorethan_ [l=nl] {Meer dan }
_textapprox_ [l=nl] {Ongeveer }
_textnodocs_ [l=nl] {Geen documenten gevonden.}
_text1doc_ [l=nl] {1 document gevonden.}
_textlotsdocs_ [l=nl] {documenten gevonden.}
_textmatches_ [l=nl] {passende teksten }
_textbeginsearch_ [l=nl] {Begin zoekactie}

# _hselection_, _jselection_ and _nselection_ are set from within the server
# some or all of them may remain unset
_textsimplesearch_ [l=nl] {Doorzoek _If_(_hselection_, _hselection_)_If_(_jselection_,_textjselect_)_If_(_gselection_, op het _gselection_ niveau)_If_(_nselection_, in _nselection_ taal) 
naar _querytypeselection_ van de volgende woorden}

_textadvancedsearch_ [l=nl] {Doorzoek _If_(_hselection_, _hselection_, _defaultindextext_)_If_(_jselection_,_textjselect_)_If_(_gselection_, op het _gselection_ niveau)_If_(_nselection_, in _nselection_ taal) 
met een _querytypeselection_ zoekvraag}

_textjselect_ [l=nl] {_If_(_hselection_, of) _jselection_}

_textstemon_ [l=nl] { (Woord einden negeeren)}
_textclearhistory_ [l=nl] {Vroegere zoekacties wissen}
_textexpand_ [l=nl] {Uitbreiden}
_textcontract_ [l=nl] {Inkrimpen}
_textsearchhistory_ [l=nl] {Vroegere zoekacties doorzoeken}
_textquery_ [l=nl] {Zoekvraag}
_textresults_ [l=nl] {Resultaten}
_textview_ [l=nl] {Weergeven}
_textnohistory_ [l=nl] {Vroegere zoekacties zijn niet beschikbaar}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "zoeken" ## green_title ## h_search ##
_httpiconhsearch_ [l=nl] {_httpimg_/nl/h\_search.gif}
_widthhsearch_ [l=nl] {200}
_heighthsearch_ [l=nl] {57}

## "resultaten" ## green_bar_left_aligned ## qryresb ##
_httpiconqryresb_ [l=nl] {_httpimg_/nl/qryresb.gif}
_widthqryresb_ [l=nl] {_pagewidth_}
_heightqryresb_ [l=nl] {17}

## "weergave" ## hand_made ##
_httpicondisplay_ [l=nl] {_httpimg_/display.gif}
_widthdisplay_ [l=nl] {60}
_heightdisplay_ [l=nl] {20}



######################################################################
# 'preferences' page
package preferences
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsearchprefs_ [l=nl] {Zoek preferenties}
_textcollectionprefs_ [l=nl] {Collectie preferenties}
_textpresentationprefs_ [l=nl] {Presentatie preferenties}
_textpreferences_ [l=nl] {Preferenties}
_textignorecase_ [l=nl] { Negeer Hoofdletters}
_textmatchcase_ [l=nl] { Kleine letters en hoofdletters moeten exact overeenstemmen}
_textstem_ [l=nl] { Negeer woord einden }
_textnostem_ [l=nl] { Geheel woord moet overeenstemmen}
_textprefop_ [l=nl] {Weergeven van maximaal _maxdocoption_ treffers met maximaal _hitsperpageoption_ treffers per pagina.}
_textextlink_ [l=nl] {Toegang tot externe Web paginas: }
_textintlink_ [l=nl] {Bronnen documenten opgevraagd van:}
_textlanguage_ [l=nl] {Interface taal: }
_textencoding_ [l=nl] {Encodering: }
_textformat_ [l=nl] {Interface formaat: }
_textall_ [l=nl] {alle}
_textsimplemode_ [l=nl] { Eenvoudige zoek modus}
_textadvancedmode_ [l=nl] { Geavanceerde zoek modus (zoek termen gekombineerd met boolse termen mogelijk b.v. !, &, |, en parentheses)}
_textlinkinterm_ [l=nl] {via tussen pagina}
_textlinkdirect_ [l=nl] {Ga direct naar de Webpagina}
_textdigitlib_ [l=nl] {de digitale bibliotheek}
_textweb_ [l=nl] {Het Web}
_textlangeng_ [l=nl] {Engelse}
_textlanggerman_ [l=nl] {Duitse}
_textlangfrench_ [l=nl] {Franse}
_textlangspanish_ [l=nl] {Spaanse}
_textlangmaori_ [l=nl] {M_amn_ori}
_textlangchinese_ [l=nl] {Chinese}
_textlangarabic_ [l=nl] {Arabische}
_textgraphical_ [l=nl] {Grafisch}
_texttextual_ [l=nl] {Tekst}
_textcollectionoption_ [l=nl] {<p>
Ondercollecties die ingesloten moeten worden:
<br>}
_textfcoption_ [l=nl] {Plaats navigatie lijst bovenaan de documenten pagina}
_texthloption_ [l=nl] {Accentueer zoektermen in document tekst}
_texthistorydisplay_ [l=nl] {Weergave vroegere zoekresultaten}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "preferenties" ## green_title ## h_pref ##
_httpiconhpref_ [l=nl] {_httpimg_/nl/h\_pref.gif}
_widthhpref_ [l=nl] {200}
_heighthpref_ [l=nl] {57}



######################################################################
# 'delete search history' page
package delhistory
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdsh_ [l=nl] {Vroegere zoekacties verwijderen}

_textselectdelete_ [l=nl] {<a href="_httpclearhistory_&hdh=1">Alle gegevens verwijderen</a> of selecteer gegevens <select name=hmode><option value=save>om deze niet te verwijderederen
<option value=delete selected>te vwijderen</select><br> Gegevens kunnen worden geselecteerd door het nummer in de box in te voeren,<br> of door alle velden van de gegeven aan te clicken.<br> Nummers die geaccepteerd worden: 1,2,3-6,7- etc }

_textclearselected_ [l=nl] {Verwijder geselecteerde gegevens}
_textselect_ [l=nl] {Selecteer}


#------------------------------------------------------------
# icons
#------------------------------------------------------------



######################################################################
# 'help' page -- this is lower priority for translating than the
# rest of this file
package help
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textHelp_ [l=nl] {Help}
_textSearchshort_ [l=nl] {naar bepaalde woorden zoeken}
_textSeriesshort_ [l=nl] {publicaties gesorteerd volgens reksen}
_textDateshort_ [l=nl] {publicaties gesorteerd volgens datum}
_textSubjectshort_ [l=nl] {publicaties gesorteerd volgens onderwerpen}
_textToshort_ [l=nl] {publicaties gesorteerd volgens geadresseerden}
_textFromshort_ [l=nl] {publicaties gesorteerd volgens afzenders}
_textTitleshort_ [l=nl] {publicaties gesorteerd volgens titels}
_textBrowseshort_ [l=nl] {alle publicaties}
_textCreatorshort_ [l=nl] {publicaties gesorteerd volgens auteurs}
_textOrganizationshort_ [l=nl] {publicaties gesorteerd volgens organisaties}
_textHowtoshort_ [l=nl] {publicaties gesorteerd volgens help onderwerpen}
_textTopicshort_ [l=nl] {publicaties gesorteerd volgens themas}
_textPeopleshort_ [l=nl] {publicaties gesorteerd volgens personen}
_textLanguageshort_ [l=nl] {publicaties gesorteerd volgens taalen}
_textAcronymshort_ [l=nl] {publicaties gesorteerd volgens afkortingen}
_textdefaultshorttext_ [l=nl] {ongedefineerde classificatie}

_textSearchlong_ [l=nl] { <p>U kunt <i>naar bepalde woorden zoeken</i> die in de tekst 
van de zoek pagina voorkomen. De zoekpagina komt op het scherm als U begint 
en kan vanuit andere paginas opgezocht worden door op de knop <i>zoeken</i> te clicken. }

_textTitlelong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens titels</i> opzoeken door op 
de knop <i>titels a-z</i> te clicken.  Deze actie zal een lijst met alfabetisch gesorteerde 
boekentitels op het scherm brengen.  }

_textOrganizationlong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens organisaties</i>  opzoeken door op 
de knop <i>organisaties</i> te clicken.  Deze actie zal een lijst met 
organisaties op het scherm brengen.  }

_textHowtolong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens help onderwerpen</i>
opzoeken door op de knop <i>help onderwerpen</i> te clicken.  Deze actie zal een lijst met 
help onderwerpen op het scherm brengen.  }

_textCreatorlong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens auteurs</i> opzoeken door op de knop <i>auteurs a-z</i> te clicken.  Deze actie zal een lijst met 
met boeken gesorteerd volgens de auteur op het scherm brengen.  }

_textTopiclong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens themas</i> opzoeken door op de knop <i>themas</i> te clicken.  Deze actie zal een lijst met 
themas op het scherm brengen om te browsen.  }

_textSubjectlong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens onderwerpen</i> opzoeken door op de knop <i>onderwerpen</i> te clicken.  Deze actie zal een lijst met 
onderwerpen op het scherm brengen gerepresenteerd door boekenkasten.  }

_textTolong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens geadresseerden</i> opzoeken door op de knop <i>geadresseerde</i> te clicken.  Deze actie zal een lijst met 
geadresseerden op het scherm brengen.  }

_textFromlong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens afzenders</i> opzoeken door op de knop <i>afzenders</i> te clicken.  Deze actie zal een lijst met 
help onderwerpen op het scherm brengen.  }

_textSerieslong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens reksen</i> opzoeken door op de knop <i>reeksen</i> te clicken.  Deze actie zal een lijst met 
reeksen op het scherm brengen die op dit moment in de collectie aanwezig zijn.  }

_textDatelong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens datum</i> opzoeken door op de knop <i>datums</i> te clicken.  Deze actie zal een lijst met chronologisch gesorteerde
publicaties op het scherm brengen.  }

_textBrowselong_ [l=nl] { <p>U kunt <i>alle publicaties</i> opzoeken door op de knop <i>alle publicaties</i> te clicken.  }

_textPeoplelong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens personen</i> opzoeken door op de knop <i>personen a-z</i> te clicken.  Deze actie zal een lijst met 
personen op het scherm brengen alfabetisch gesorteerd volgens familie naam.  }

_textLanguagelong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens taalen</i> opzoeken door op de knop <i>taalen</i> te clicken.  Deze actie zal een lijst met 
publicaties op het scherm brengen gesorteerd volgens taalen.  }

_textAcronymslong_ [l=nl] { <p>U kunt <i>publicaties gesorteerd volgens afkortingen</i> opzoeken door op de knop <i>afkortingen</i> te clicken.  Deze actie zal een lijst met 
afkortingen op het scherm brengen en de tekst stukken waarin deze voorkomen.  }

_textdefaultlongtext_ [l=nl] { <p>Click de knop <i>ongedefineerd</i> om publicaties te browsen die volgens een onbekend veld gesorteerd zijn.}

_texthelptopics_ [l=nl] {
<h2 align=left>Topics</h2>
<ul>
  <li><a href="\#finding-information">_textsimplehelpheading_</a>
  _topicreadingdocs_
  <li><a href="\#searching">Hoe kan ik voor bepaalde woorden zoeken?</a>
<ul>
  <li><a href="\#query-terms">Zoek termen</a>
  <li><a href="\#query-type">Type zoek vraag</a>
  <li><a href="\#scope-of-queries">Omvang zoek vraag</a>
</ul>
  <li><a href="\#preferences">_textchangeprefs_</a>
<ul>
  <li><a href="\#col-prefs">Collectie preferenties</a>
  <li><a href="\#pres-prefs">Weergave preferenties</a>
  <li><a href="\#search-prefs">Zoek preferenties</a>
</ul>
</ul>
}

# there are 4 versions of this section of the help text.
# which version is used is currently set within the server
# (it should probably use the macro language e.g. [type=book])
# 1 = html (like fao collections) -- section is empty
# 2 = book (like hdl collection) -- macros beginning with book
# 3 = bibliographic (like csbib) -- macros beginning with bib
# 4 = standard (like gberg) -- the default

_topicreadingdocs_ [l=nl] {<li><a href="\#reading-docs">_textreadingdocs_</a>}

_textreadingdocs_ [l=nl] {Hoe can ik documenten lezen?}
_booktextreadingdocs_ [l=nl] {Hoe can ik boeken lezen?}
_bibtextreadingdocs_ [l=nl] {Hoe can ik meer informatie krijgen over een bibliografisch onderwerp?}

_texthelpreadingdocs_ [l=nl] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>U bent bij een document aangekomen, als de titel en de auteur links boovenaan de pagina 
verschijnen.  Daarnaast bevinden zich het pagina nummer van de actuele pagina, een box om 
een nieuwe pagina nummer te kiezen en pijlen om de volgende of voorafgaande pagina te kiezen. 

<p>Onder de pagina nummers bevind zich de tekst van de sectie.  U kunt gebruik maken van de 
pijlen onderaan de pagina om naar de volgende of voorafgaande sectie komen.

<p>Onder de titel en de auteur bevinden zich drie knoppen. Click op de knop <i>tekst uitbreiden</i> 
om de hele tekst te zien.  Als U groote documenten uitbreid, zou dit heel wat tijd en geheugen in 
beslag kunnen nemen!
Click op de knop <i>nieuw venster</i> om een nieuw venster voer een document te opeuen.  
(Dit zou handig kunnen zijn, als U twee documenten wilt lezen of als U twee documenten wilt 
vergelijken.) Na het uitvoeren van een zoekactie, worden de woorden waarnaar U gezocht hebt 
geaccentueerd. Wilt U dit ongedaan maken, dan clickt U op de knop <i>niet accentueren</i>.
<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Druk op de pijl om naar de volgende sectie te gaan ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... of terug naar de voorafgaande sectie.</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Geef de hele tekst weer, of niet</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>pen een nieuw venster voor deze pagina</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Accentueer zoektermen of niet</td></tr>
</table>

}

_booktexthelpreadingdocs_ [l=nl] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>U bent bij een book aangekomen als een afbeelding van de voorplaat van het book links bovenaan 
de pagina veschijnt.  Naast het plaatje bevind zich een inhoudsopgave. Een pijltje geeft het gedeelte 
aan waar U zich momenteel bevindt.  De inhouds opgave kan nitgebreidt worden: click op de map om de 
inhoudsopgave te openen en te sluiten.
Click op een open boek om het te sluiten.

<p>Onderaan bevind zich de tekst van de actuele sectie.  Met de pijlen onderaan de pagina kunt U naar 
de volgende of voorafgaande sectie gaan.

<p>Onder het plaatje bevinden zich vier knoppen.  Druk de knop <i>tekst uitbreiden</i>om de hele 
tekst van een sectie of book te kunnen zien.  Het uitbreiden van omvangrijke boeken kan veel tijd 
en geheugen in beslag nemen! 
Click op het knopje <i>inhoudsopgave uitbreiden</i> om de koppen van alle hoofdstukken te kunnen zien.
Click op de knop <i>nieuw venster</i>  om een nieuw venster voor een boek te openen.  Dit zou handig 
zijn als U boeken vergelijkt of twee boeken tegelijker tijd wilt lezen.
 Na een zoekactie worden de zoektermen in de tekst geaccentueerd.  Click op de knop <i>niet accentueren</i> 
als U geen geaccentueerde zoektermen wilt.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconbshelf_" border="0"></td><td>Onderwerp openen </td></tr>
<tr><td><img src="_httpiconopenbook_" border="0"></td><td><img 
src="_httpiconbook_" border="0"></td><td>Boek openen/sluiten, </td></tr>
<tr><td colspan=2><img src="_httpiconitext_" border="0"></td><td>Deze sectie van de tekst weergeven</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>De hele tekst weergeven of niet</td></tr>
<tr><td><img src="_document:httpiconeexpcof_" border="0"></td><td><img
src="_document:httpiconeconcof_" border="0"></td><td>Inhoudsopgave uitbreiden of niet</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Open een nieuw venster voor deze pagina</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Zoektermen accentueren of niet</td></tr>
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Click op de pijl om naar de volgende sectie te gaan ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... of terug naar de voorafgaande sectie</td></tr>
</table>
}

_bibtexthelpreadingdocs_ [l=nl] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>Sommige bibliografische items bevatten aavullende informatie (b.v. een abstract)
Dit blijkt uit icons op de zoek responsie-pagina. ls een item aanvullende informatie bevat dan wordt het door_icontext_ icon in plaats 
van _iconblanktext_ weergegeven.

<p>Als U op het icon _icontext_ clickt word de aavullende informatie van het bibliografisch item weergegeven.

<p> Onderaan het bibliografisch item bevinden zich twee knoppen.  Click op de knop <i>niew venster</i> 
om een nieuw browser-venster voor dit boek te openen.  (Dit zou handig zijn als U bibliografische 
items wilt vergelijken). Na een zoekactie worden de zoektermen in de doorzochte tekst geaccentueerd.  
Click op <i>niet accentureren</i> om de accentuering te onderdrukken.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Open een nieuw venster voor deze pagina</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Accentueer zoek termen of niet.</td></tr>
</table>
}

_texthelpsearching_ [l=nl] {
<h2>Zoeken naar bepaalde worden</h2>
<p>
  Vanuit de zoek pagina moeten volgende stappen uitgevoerd worden:<p>
  
  <ol><li>Kies de documenten die doorzocht moeten worden.
      <li>Kies of U naar somige of alle woorden wilt zoeken.
      <li>Typ in de woorden waarnaar gezocht moet worden.
      <li>Click op de knop <i>Begin zoeken<i>
  </ol>

<p>Na het uitvoeren van een zoekactie worden de titels van maximaal 20 gevonden documenten 
per pagina weergengeven. Er is een knop onderaan de pagina om naar de volgende 20 titels te gaan.  
Vandaar kunt U of terug naar de vooafgaande pagina of  vooruit naar de volgende pagina gaan. 
Click op de titel of op het knopje ernaast om een document weer te geven.

<p>Er wordt een maximum van 100 gevonden documenten weergengeven.  U kunt het maximum gwonden 
documenten veranderen via de knop <i>preferenties</I> bovenaan de pagina.<p>

<p>_iconblankbar_
<a name=query-terms>
<h3>Zoektermen</h3>

<p>Alle woorden in de zoekvraag box worden als zoektermen geinterpreteerd Zoektermen mogen alleen 
letters en nummers bevatten. Zoektermen worden gesepareerd door een spatie. Alle anderen tekens 
(zoals kommas of vraagtekens) worden als seperatoren geinterpreteerd.  Ze zijn dus identiek met 
spaties en worden genegeerd als onderdeel van zoektermen.  Het is dus niet mogelijk om naar 
worden te zoeken die dit soort tekens bevatten.

<p>Bij voorbeeld de zoekvraag <p>
    <ul><kbd>s'Maandags</kbd></ul>
      <p>s het zelfde als <p>
      <ul><kbd>s Maandags</kbd></ul><p>

<p>_iconblankbar_
<a name=query-type>
<h3>ypen zoekvragen</h3>

<p>Er zijn twee sorten zoekvragen.
<ul>
  <li>Zoekvragen haar <b>alle</b> woorden.  Deze zoekvragen zoeken naar documenten die alle 
gespecificeerde zoektermen bevatten.  Documenten die aan deze zoekvraag voldoen worden in 
alphabetische orde weergengeven..<p>

  <li>Zoekvragen naar <b>somige woorden</b>.  Deze zoekvragen zoeken naar documenten die een of 
merdere zoektermen bevatten.  Voer woorden in, die waarschiijnlijk in de gewensde documenten aanwezig 
zijn.  Documenten worden weergegeven naar mate zij aan de zoekvraag voldoen.  

      <p><ul>
        <li> Hoe meer zoektermen een dokument bevat, hoe beter het maat van voldoening met dit soort zoekvragen.
        <li> Rare woorden werken beter dan gebruiklijke woorden.
        <li> Korte documenten voeldoen beter aan zoekvragen dan omvangrijke documenten.
      </ul>
</ul>

<p>U kunt elk aantal zoektermen invoeren, hele zinnen en hele alineas.  Als U maar een zoekterm 
invoert zullen de gevonden documenten worden weergegeven in orde van het aantal keren dat de 
zoekterm werd aangetroffen in een document.<p>

_texthelpscope_
}

_textchangeprefs_ [l=nl] {Het veranderen van preferenties}

_texthelppreferences_ [l=nl] {<h2>_textchangeprefs_</h2>

<p>Bovenaan de pagina bevindt zich de knop <i>preferenties</i>.  Als U deze knop drukt kunt U de 
eigensdrappen van het interface veranderen zodat het aan Uw eisen voldoet.

<p>_iconblankbar_
<a name=col-prefs>
<h3 align=left>Collectie preferenties</h3>

SoSomige collecties bevatten meerdene sub-collecties.  Deze kunnen individueel doorzocht worden of 
als een geheel.  Op de preferentie pagina kunt U kiezen welke sub-collecties in de zoekacties 
inbegrepen moeten worden.

<p>_iconblankbar_
<a name=pres-prefs>
<h3 align=left>Presentatie preferenties</h3>

Afhankelijk van de type collectie bestaan veschillende opties om de presentatie van 
de collectie te veranderen.

In collecties van Web paginas kan de Greenstone navigatie lijst onderdrukt worden.  De Greenstone 
navigatie lijst wordt normaliter bavenaan de dokumenten pagina weergengeven.  Als U kiest om 
deze lijst te verwijderen zal een zoekactie U naar een Webpagina zonder Greenstone navigatie 
lijst brengen. 	Om in deze situatie een nieuwe zoek actie uit te voeren moet U gebruik maken van 
de 'terug'-knop van de browser. Greenstone brengt waarschuings-boodschappen op het scherm als 
U op een link clickt dat buiten de digitale bibliotheek en op het Web gaat.  Deze 
waarschuings-boodschappen kunnen onderdrukt worden. In somige Web collecties is het mogelijk 
om te kiezen of de links van de zoek resultaten pagina direct naar de URL verwijzen of naar de 
kopie in de digitale bibliotheek.

Collecties, die in verschillende taalen kunnen worden weergegeven, bieden de mogelijkheid om een 
interface taal te kiezen.  In het geval van Chinees kunt U, degene standard Chinees encodering 
kiezen die door Uw browser wordt gebruikt.

In alle collecties kunt U kiezen tussen een tekst interface en een graphisch interface.  
Deze optie is bijzonder helpful voor visueel gehandicapten die extra groote letters willen gebruiken.

<p>_iconblankbar_
<a name=search-prefs>
<h3 align=left>Zoek preferenties</h3>
Met twee paaren van knoppen kunt U het gbruik van Hoofdletters/kleine letters en het gebruik van 
woordstammen controleren. Met het eeste paar knoppen kunt U kiezen of Hoofdletters in zoektermen 
in acht genomen moeten worden of niet. Met het tweede paar knoppen kunt U regelen of woordeinden 
genegeerd moeten worden, of niet.


<p>Als b.v. de knoppen <i>negeer hoofdletters</i> en <i>negeer woordeinden</i> geselecteerd zijn, 
dan zal de zoekvraag <p>
	<ul><kbd>Africaanse gebouwen</kbd></ul>
	<p>net zo worden behandelt als de zoekvraag<p>
	<ul><kbd>Africa gebouw</kbd></ul><p>
Dit is so, omdat de hoofdletter 'A' naar de kleine letter 'a' word veranderd en de woordeinden 
"anse" en "en" worden weggelaten.

<p>U kunt ook voor een geavanceerde form van zoekvragen kiezen.  In de geavanceerde zoekvraag 
kunt U termen combineren door AND (&), OR (I), and NOT (!) te gebruiken.  Op die manier kunt U 
precisesere zoekvragen formuleren. 

<p>U kunt ook het maximum aantal gevonden documenten en het 
maximum aantal documenten per pagina veranderen.

}

_texttanumbrowseoptions_ [l=nl] {Er zijn _numbrowseoptions_ moglijkheden om informatie in 
deze collectie op te sporen:}

_textsimplehelpheading_ [l=nl] {Het opsporen van informatie}

_texthelpscope_ [l=nl] {
<p>_iconblankbar_
<a name=scope-of-queries>
<h3 align=left>Omvang van zoekvragen</h3>

<p>
In de meeste collecties kunt U verschillende indicees kiezen voor Uw zoekacties.  Er zouden auteurs- 
en titel indicees aanwezig kunnen zijn of hoofdstuk- en alinea indecees. Geheel passende documenten 
zullen altijd worden gevonden onafhankelijk van de gebruikte index.  
<p> Boeken worden geopened op het relevante stuk tekst.
}
