#!/usr/bin/perl -w

###########################################################################
#
# pluginfo.pl --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################


# This program will print info about a plugin

BEGIN {
    die "GSDLHOME not set\n" unless defined $ENV{'GSDLHOME'};
    die "GSDLOS not set\n" unless defined $ENV{'GSDLOS'};
    unshift (@INC, "$ENV{'GSDLHOME'}/perllib");
    unshift (@INC, "$ENV{'GSDLHOME'}/perllib/plugins");
}

use strict;
use plugin;
use util;
use parsargv;

sub print_usage {
    print STDERR "\n";
    print STDERR "pluginfo.pl: Prints information about a plugin.\n\n";
    print STDERR "  usage: $0 [options] plugin\n\n";
    print STDERR "  options:\n";
    print STDERR "   -collect collection-name  Giving a collection name will make pluginfo.pl\n";
    print STDERR "                             look in collect/collection-name/perllib/plugins\n";
    print STDERR "                             for plugin first. If it doesn't find it there\n";
    print STDERR "                             it will look in the general perllib/plugins\n";
    print STDERR "                             directory\n\n";
}


&main ();

sub main {
    my $collect = "";
    if (!parsargv::parse(\@ARGV, 'collect.*/', \$collect)) {
	&print_usage();
	die "\n";
    }

    my $plugin = shift (@ARGV);
    if (!defined $plugin || $plugin eq "") {
	print STDERR "You must provide a plugin name\n";
	&print_usage();
	die "\n";
    }

    if ($collect ne "") {
	$ENV{'GSDLCOLLECTDIR'} = &util::filename_cat ($ENV{'GSDLHOME'}, "collect", $collect);
    } else {
	$ENV{'GSDLCOLLECTDIR'} = $ENV{'GSDLHOME'};
    }

    my $pluginfo = &plugin::load_plugins ([[$plugin]]);

    my $plugobj = shift @$pluginfo;

    print STDERR "\n$plugin info:\n\n";
	
    print STDERR "Options may be passed to any plugin by including them in your collect.cfg\n";
    print STDERR "configuration file.\n\n";

    print STDERR "Plugins may take two types of options:\n\n";

    print STDERR "General options are defined within the base class (BasPlug.pm) and are\n";
    print STDERR "inherited by any plugin that has been correctly derived from BasPlug.\n\n";

    print STDERR "Specific options are defined within the plugin itself and are available\n";
    print STDERR "only to this particular plugin.\n\n";

    print STDERR "$plugin takes the following specific options:\n";
    $plugobj->print_usage();

    print STDERR "$plugin takes the following general options\n";
    &BasPlug::print_general_usage($plugin);

    print STDERR "The default process_exp for $plugin is\n";
    print STDERR "\"" . $plugobj->get_default_process_exp() . "\"\n\n";

    print STDERR "The default block_exp for $plugin is\n";
    print STDERR "\"" . $plugobj->get_default_block_exp() . "\"\n\n";

}

