/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;
import jaws.filterPackage.Range;

public class UnaryNumericTransformFilter
extends Filter
implements OptionHandler {
    private Range m_Cols;
    private Class m_Class;
    private Method m_Method;
    private static Class[] PARAM = new Class[]{Double.TYPE};

    public UnaryNumericTransformFilter() {
        this.m_InputFormat = null;
        this.setOutputFormat(null);
        this.b_NewBatch = true;
        this.m_Cols = new Range();
        this.m_Class = null;
        this.m_Method = null;
    }

    public boolean inputFormat(Instances instances) throws Exception {
        if (this.m_Class == null) {
            throw new Exception("No class has been set.");
        }
        if (this.m_Method == null) {
            throw new Exception("No method has been set.");
        }
        this.m_InputFormat = new Instances(instances, 0);
        this.setOutputFormat(this.m_InputFormat);
        this.b_NewBatch = true;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        Object[] objectArray = new Double[1];
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        double[] dArray = new double[instance.numAttributes()];
        int n = 0;
        while (n < instance.numAttributes()) {
            if (instance.isMissing(n)) {
                dArray[n] = Instance.missingValue();
            } else {
                double d = instance.value(n);
                if (this.m_Cols.isInRange(n) && instance.attribute(n).isNumeric()) {
                    objectArray[0] = new Double(d);
                    Double d2 = (Double)this.m_Method.invoke(null, objectArray);
                    dArray[n] = d2.isNaN() || d2.isInfinite() ? Instance.missingValue() : d2;
                } else {
                    dArray[n] = d;
                }
            }
            ++n;
        }
        this.push(new Instance(instance.weight(), dArray));
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSpecify list of columns to transform. First and last are valid indexes.\n\t(default none). Non-numeric columns are skipped.", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        vector.addElement(new Option("\tSets the class.", "C", 1, "-C <string>"));
        vector.addElement(new Option("\tSets the method.", "M", 1, "-M <string>"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.setAttributeIndices(string2);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string3 = Utils.getOption('C', stringArray);
        if (string3.length() != 0) {
            this.setClassName(string3);
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMethodName(string);
        }
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public String getClassName() {
        return this.m_Class.getName();
    }

    public void setClassName(String string) throws Exception {
        this.m_Class = Class.forName(string);
    }

    public String getMethodName() {
        return this.m_Method.getName();
    }

    public void setMethodName(String string) throws Exception {
        this.m_Method = this.m_Class.getMethod(string, PARAM);
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Cols.setInvert(bl);
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_Cols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = n == 0 ? String.valueOf(nArray[n] + 1) : String.valueOf(string) + "," + (nArray[n] + 1);
            ++n;
        }
        this.setAttributeIndices(string);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new UnaryNumericTransformFilter(), stringArray);
                return;
            }
            Filter.filterFile(new UnaryNumericTransformFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

