/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.filterPackage.Filter;

public class ReplaceMissingValuesFilter
extends Filter {
    private double[] theModesAndMeans = null;

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        this.b_NewBatch = true;
        this.setOutputFormat(new Instances(instances, 0));
        this.theModesAndMeans = null;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        if (this.theModesAndMeans != null) {
            this.convertInstance(instance);
            return true;
        }
        this.m_InputFormat.add(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.theModesAndMeans == null) {
            this.computeModesAndMeans();
            int n = 0;
            while (n < this.m_InputFormat.numInstances()) {
                Instance instance = this.m_InputFormat.instance(n);
                this.convertInstance(instance);
                ++n;
            }
            this.m_InputFormat = new Instances(this.m_InputFormat, 0);
        }
        this.b_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void computeModesAndMeans() throws Exception {
        this.theModesAndMeans = new double[this.m_InputFormat.numAttributes()];
        int n = 0;
        while (n < this.m_InputFormat.numAttributes()) {
            this.theModesAndMeans[n] = this.m_InputFormat.meanOrMode(n);
            ++n;
        }
    }

    private void convertInstance(Instance instance) throws Exception {
        Instance instance2 = new Instance(instance);
        int n = 0;
        while (n < this.m_InputFormat.numAttributes()) {
            if (instance.isMissing(n)) {
                instance2.setValue(n, this.theModesAndMeans[n]);
            }
            ++n;
        }
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new ReplaceMissingValuesFilter(), stringArray);
                return;
            }
            Filter.filterFile(new ReplaceMissingValuesFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

