/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.InstanceEvent;
import jaws.filterPackage.InstanceListener;
import jaws.filterPackage.InstanceProducer;
import jaws.filterPackage.Queue;

public abstract class Filter
implements Serializable,
InstanceProducer,
InstanceListener {
    private Vector listeners = new Vector();
    private boolean b_Debug = false;
    private Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    protected Instances m_InputFormat = null;
    protected boolean b_NewBatch = true;

    protected void setOutputFormat(Instances instances) {
        this.m_OutputFormat = instances;
        this.m_OutputQueue = new Queue();
        if (this.m_OutputFormat != null) {
            this.notifyInstanceProduced(new InstanceEvent(this, 1));
        }
    }

    protected Instances outputFormatPeek() {
        return this.m_OutputFormat;
    }

    protected void push(Instance instance) {
        if (instance != null) {
            this.m_OutputQueue.push(instance);
            this.notifyInstanceProduced(new InstanceEvent(this, 2));
        }
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.b_NewBatch = true;
        return false;
    }

    public Instances outputFormat() throws Exception {
        if (this.m_OutputFormat == null) {
            throw new Exception("No output format defined.");
        }
        return new Instances(this.m_OutputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.m_OutputQueue = new Queue();
            this.b_NewBatch = false;
        }
        this.m_InputFormat.add(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        this.b_NewBatch = true;
        this.notifyInstanceProduced(new InstanceEvent(this, 3));
        return this.numPendingOutput() != 0;
    }

    public Instance output() throws Exception {
        if (this.m_OutputFormat == null) {
            throw new Exception("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.pop();
        instance.setDataset(this.m_OutputFormat);
        return instance;
    }

    public Instance outputPeek() throws Exception {
        if (this.m_OutputFormat == null) {
            throw new Exception("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.peek();
        return instance;
    }

    public int numPendingOutput() throws Exception {
        if (this.m_OutputFormat == null) {
            throw new Exception("No output instance format defined");
        }
        return this.m_OutputQueue.size();
    }

    public boolean isOutputFormatDefined() {
        return this.m_OutputFormat != null;
    }

    public static Instances useFilter(Instances instances, Filter filter) throws Exception {
        Instance instance;
        int n = 0;
        while (n < instances.numInstances()) {
            filter.input(instances.instance(n));
            ++n;
        }
        filter.batchFinished();
        Instances instances2 = filter.outputFormat();
        while ((instance = filter.output()) != null) {
            instances2.add(instance);
        }
        return instances2;
    }

    /*
     * Unable to fully structure code
     */
    public static void filterFile(Filter var0, String[] var1_1) throws Exception {
        block24: {
            block25: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = null;
                var5_5 = null;
                try {
                    if (Utils.getFlag('h', var1_1)) {
                        throw new Exception("Help requested.\n");
                    }
                    if (Utils.getFlag('d', var1_1)) {
                        var2_2 = true;
                    }
                    var4_4 = (var6_6 = Utils.getOption('i', var1_1)).length() != 0 ? new BufferedInputStream(new FileInputStream(var6_6)) : new BufferedInputStream(System.in);
                    var3_3 = new Instances(var4_4, 1);
                    var3_3.setClassIndex(var3_3.numAttributes() - 1);
                    var6_6 = Utils.getOption('o', var1_1);
                    var5_5 = var6_6.length() != 0 ? new PrintStream(new FileOutputStream(var6_6)) : System.out;
                    if (var0 instanceof OptionHandler) {
                        ((OptionHandler)var0).parseOptions(var1_1);
                    }
                    Utils.checkForRemainingOptions(var1_1);
                    break block24;
                }
                catch (Exception var6_7) {
                    var7_9 = "";
                    if (!(var0 instanceof OptionHandler)) break block25;
                    var7_9 = String.valueOf(var7_9) + "\nFilter options:\n\n";
                    var8_10 = ((OptionHandler)var0).listOptions();
                    ** while (var8_10.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    var9_11 = (Option)var8_10.nextElement();
                    var7_9 = String.valueOf(var7_9) + var9_11.synopsis() + '\n' + var9_11.description() + "\n";
                    continue;
                }
            }
            var8_10 = "\nGeneral options:\n\n-h\n\tGet help on available options. (use -b -h for help on batch mode.)\n-i <file>\n\tThe name of the file containing input instances. If not supplied\n\tthen input instances will be read from stdin.\n-o <file>\n\tThe name of the file output instances will be written to. If not supplied\n\tthen input instances will be read from stdin.\n";
            throw new Exception(String.valueOf('\n') + var6_7.getMessage() + var7_9 + (String)var8_10);
        }
        if (var2_2) {
            System.err.println("Setting input format");
        }
        var6_8 = false;
        if (var0.inputFormat(var3_3)) {
            if (var2_2) {
                System.err.println("Getting output format");
            }
            var5_5.println(var0.outputFormat().toString());
            var6_8 = true;
        }
        while (var3_3.readInstance(var4_4)) {
            if (var2_2) {
                System.err.println("Input instance to filter");
            }
            if (var0.input(var3_3.instance(0))) {
                if (var2_2) {
                    System.err.println("Filter said collect immediately");
                }
                if (!var6_8) {
                    System.err.println("Filter didn't return true from inputFormat() earlier!");
                    System.exit(0);
                }
                if (var2_2) {
                    System.err.println("Getting output instance");
                }
                var5_5.println(var0.output().toString());
            }
            var3_3.delete(0);
        }
        if (var2_2) {
            System.err.println("Setting end of batch");
        }
        if (var0.batchFinished()) {
            if (var2_2) {
                System.err.println("Filter said collect output");
            }
            if (!var6_8) {
                if (var2_2) {
                    System.err.println("Getting output format");
                }
                var5_5.println(var0.outputFormat().toString());
            }
            if (var2_2) {
                System.err.println("Getting output instance");
            }
            while (var0.numPendingOutput() > 0) {
                var5_5.println(var0.output().toString());
                if (!var2_2) continue;
                System.err.println("Getting output instance");
            }
        }
        if (var2_2) {
            System.err.println("Done");
        }
        if (var5_5 != null) {
            var5_5.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void batchFilterFile(Filter var0, String[] var1_1) throws Exception {
        block26: {
            block27: {
                var2_2 = null;
                var3_3 = null;
                var4_4 = null;
                var5_5 = null;
                var6_6 = null;
                var7_7 = null;
                try {
                    if (Utils.getFlag('h', var1_1)) {
                        throw new Exception("Help requested.\n");
                    }
                    var8_8 = Utils.getOption('i', var1_1);
                    if (var8_8.length() == 0) {
                        throw new Exception("No first input file given.\n");
                    }
                    var4_4 = new BufferedInputStream(new FileInputStream(var8_8));
                    var2_2 = new Instances(var4_4, 1);
                    var2_2.setClassIndex(var2_2.numAttributes() - 1);
                    var8_8 = Utils.getOption('I', var1_1);
                    if (var8_8.length() == 0) {
                        throw new Exception("No second input file given.\n");
                    }
                    var5_5 = new BufferedInputStream(new FileInputStream(var8_8));
                    var3_3 = new Instances(var5_5, 1);
                    var3_3.setClassIndex(var3_3.numAttributes() - 1);
                    if (!var3_3.equalHeaders(var2_2)) {
                        throw new Exception("Input file formats differ.\n");
                    }
                    var8_8 = Utils.getOption('o', var1_1);
                    if (var8_8.length() == 0) {
                        throw new Exception("No first output file given.\n");
                    }
                    var6_6 = new PrintStream(new FileOutputStream(var8_8));
                    var8_8 = Utils.getOption('O', var1_1);
                    if (var8_8.length() == 0) {
                        throw new Exception("No second output file given.\n");
                    }
                    var7_7 = new PrintStream(new FileOutputStream(var8_8));
                    if (var0 instanceof OptionHandler) {
                        ((OptionHandler)var0).parseOptions(var1_1);
                    }
                    Utils.checkForRemainingOptions(var1_1);
                    break block26;
                }
                catch (Exception var8_9) {
                    var9_11 = "";
                    if (!(var0 instanceof OptionHandler)) break block27;
                    var9_11 = String.valueOf(var9_11) + "\nFilter options:\n\n";
                    var10_12 = ((OptionHandler)var0).listOptions();
                    ** while (var10_12.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    var11_13 = (Option)var10_12.nextElement();
                    var9_11 = String.valueOf(var9_11) + var11_13.synopsis() + '\n' + var11_13.description() + "\n";
                    continue;
                }
            }
            var10_12 = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-i <file>\n\tThe name of the file containing first input instances.\n-o <file>\n\tThe name of the file first output instances will be written to.\n-I <file>\n\tThe name of the file containing second input instances.\n-O <file>\n\tThe name of the file second output instances will be written to.\n";
            throw new Exception(String.valueOf('\n') + var8_9.getMessage() + var9_11 + (String)var10_12);
        }
        var8_10 = false;
        if (var0.inputFormat(var2_2)) {
            var6_6.println(var0.outputFormat().toString());
            var8_10 = true;
        }
        while (var2_2.readInstance(var4_4)) {
            if (var0.input(var2_2.instance(0))) {
                if (!var8_10) {
                    System.err.println("Filter didn't return true from inputFormat() earlier!");
                    System.exit(0);
                }
                var6_6.println(var0.output().toString());
            }
            var2_2.delete(0);
        }
        if (var0.batchFinished()) {
            if (!var8_10) {
                var6_6.println(var0.outputFormat().toString());
            }
            while (var0.numPendingOutput() > 0) {
                var6_6.println(var0.output().toString());
            }
        }
        if (var6_6 != null) {
            var6_6.close();
        }
        var8_10 = false;
        if (var0.isOutputFormatDefined()) {
            var7_7.println(var0.outputFormat().toString());
            var8_10 = true;
        }
        while (var3_3.readInstance(var5_5)) {
            if (var0.input(var3_3.instance(0))) {
                if (!var8_10) {
                    System.err.println("Filter didn't return true from isOutputFormatDefined() earlier!");
                    System.exit(0);
                }
                var7_7.println(var0.output().toString());
            }
            var3_3.delete(0);
        }
        if (var0.batchFinished()) {
            if (!var8_10) {
                var7_7.println(var0.outputFormat().toString());
            }
            while (var0.numPendingOutput() > 0) {
                var7_7.println(var0.output().toString());
            }
        }
        if (var7_7 != null) {
            var7_7.close();
        }
    }

    public void setDebug(boolean bl) {
        this.b_Debug = bl;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.listeners.addElement(instanceListener);
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.listeners.removeElement(instanceListener);
    }

    protected void notifyInstanceProduced(InstanceEvent instanceEvent) {
        if (this.listeners.size() > 0) {
            Vector vector;
            if (this.b_Debug) {
                System.err.println(String.valueOf(this.getClass().getName()) + "::notifyInstanceProduced()");
            }
            Filter filter = this;
            synchronized (filter) {
                vector = (Vector)this.listeners.clone();
            }
            int n = 0;
            while (n < vector.size()) {
                ((InstanceListener)vector.elementAt(n)).instanceProduced(instanceEvent);
                ++n;
            }
            try {
                if (instanceEvent.getID() == 2) {
                    this.output();
                    return;
                }
            }
            catch (Exception exception) {
                System.err.println("Problem: notifyInstanceProduced() was\ncalled with INSTANCE_AVAILABLE, but output()\nthrew an exception: " + exception.getMessage());
                return;
            }
        }
    }

    public void instanceProduced(InstanceEvent instanceEvent) {
        Object object = instanceEvent.getSource();
        if (object instanceof InstanceProducer) {
            try {
                InstanceProducer instanceProducer = (InstanceProducer)object;
                switch (instanceEvent.getID()) {
                    case 1: {
                        if (this.b_Debug) {
                            System.err.println(String.valueOf(this.getClass().getName()) + "::instanceProduced() - Format available");
                        }
                        this.inputFormat(instanceProducer.outputFormat());
                        return;
                    }
                    case 2: {
                        if (this.b_Debug) {
                            System.err.println(String.valueOf(this.getClass().getName()) + "::instanceProduced() - Instance available");
                        }
                        this.input(instanceProducer.outputPeek());
                        return;
                    }
                    case 3: {
                        if (this.b_Debug) {
                            System.err.println(String.valueOf(this.getClass().getName()) + "::instanceProduced() - End of instance batch");
                        }
                        this.batchFinished();
                        return;
                    }
                }
                System.err.println(String.valueOf(this.getClass().getName()) + "::instanceProduced() - unknown event type");
                return;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return;
            }
        }
        System.err.println(String.valueOf(this.getClass().getName()) + "::instanceProduced() - Unknown source object type");
    }
}

