/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

public class Statistics {
    private static double logSqrtPi = Math.log(Math.sqrt(Math.PI));
    private static double rezSqrtPi = 1.0 / Math.sqrt(Math.PI);
    private static double bigx = 20.0;

    public static double binomialStandardError(double d, int n) {
        if (n == 0) {
            return 0.0;
        }
        return Math.sqrt(d * (1.0 - d) / (double)n);
    }

    public static double chiSquaredProbability(double d, int n) {
        double d2;
        boolean bl;
        double d3 = 0.0;
        if (d <= 0.0 || n < 1) {
            return 1.0;
        }
        double d4 = 0.5 * d;
        boolean bl2 = bl = 2 * (n / 2) == n;
        if (n > 1) {
            d3 = Math.exp(-d4);
        }
        double d5 = d2 = bl ? d3 : 2.0 * Statistics.normalProbability(-Math.sqrt(d));
        if (n > 2) {
            double d6;
            d = 0.5 * ((double)n - 1.0);
            double d7 = d6 = bl ? 1.0 : 0.5;
            if (d4 > bigx) {
                double d8 = bl ? 0.0 : logSqrtPi;
                double d9 = Math.log(d4);
                while (d6 <= d) {
                    d8 = Math.log(d6) + d8;
                    double d10 = d9 * d6 - d4 - d8;
                    d2 += Math.exp(d10);
                    d6 += 1.0;
                }
                return d2;
            }
            double d11 = bl ? 1.0 : rezSqrtPi / Math.sqrt(d4);
            double d12 = 0.0;
            while (d6 <= d) {
                d12 += (d11 *= d4 / d6);
                d6 += 1.0;
            }
            return d12 * d3 + d2;
        }
        return d2;
    }

    private static double FCriticalValue(double d, int n, int n2) {
        double d2 = 99999.0;
        double d3 = 1.0E-6;
        if (d <= 0.0 || d >= 1.0) {
            return 0.0;
        }
        double d4 = 1.0 / d;
        while (Math.abs(d2 - d3) > 1.0E-6) {
            if (Statistics.FProbability(d4, n, n2) < d) {
                d2 = d4;
            } else {
                d3 = d4;
            }
            d4 = (d2 + d3) * 0.5;
        }
        return d4;
    }

    private static double FProbability(double d, int n, int n2) {
        double d2;
        double d3;
        double d4;
        if (Math.abs(d) < 1.0E-9 || n <= 0 || n2 <= 0) {
            return 1.0;
        }
        int n3 = n % 2 == 1 ? 1 : 2;
        int n4 = n2 % 2 == 1 ? 1 : 2;
        double d5 = d * (double)n / (double)n2;
        double d6 = 1.0 / (1.0 + d5);
        if (n3 == 1) {
            if (n4 == 1) {
                d4 = Math.sqrt(d5);
                d3 = 0.3183098861837907;
                d2 = d3 * d6 / d4;
                d4 = 2.0 * d3 * Math.atan(d4);
            } else {
                d4 = Math.sqrt(d5 * d6);
                d2 = 0.5 * d4 * d6 / d5;
            }
        } else if (n4 == 1) {
            d4 = Math.sqrt(d6);
            d2 = 0.5 * d6 * d4;
            d4 = 1.0 - d4;
        } else {
            d2 = d6 * d6;
            d4 = d5 * d6;
        }
        d3 = 2.0 * d5 / d6;
        int n5 = n4 + 2;
        while (n5 <= n2) {
            d4 = n3 == 1 ? d4 + (d2 *= (1.0 + (double)n3 / ((double)n5 - 2.0)) * d6) * d3 / ((double)n5 - 1.0) : (d4 + d5) * d6;
            n5 += 2;
        }
        d3 = d5 * d6;
        d6 = 2.0 / d6;
        n4 = n2 - 2;
        int n6 = n3 + 2;
        while (n6 <= n) {
            n5 = n6 + n4;
            d4 -= d6 * (d2 *= d3 * (double)n5 / ((double)n6 - 2.0)) / (double)n5;
            n6 += 2;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        } else if (d4 > 1.0) {
            d4 = 1.0;
        }
        return 1.0 - d4;
    }

    public static double normalProbability(double d) {
        double d2;
        if (d == 0.0) {
            d2 = 0.0;
        } else {
            double d3 = 0.5 * Math.abs(d);
            if (d3 >= 3.0) {
                d2 = 1.0;
            } else if (d3 < 1.0) {
                double d4 = d3 * d3;
                d2 = ((((((((1.24818987E-4 * d4 - 0.001075204047) * d4 + 0.005198775019) * d4 - 0.019198292004) * d4 + 0.059054035642) * d4 - 0.151968751364) * d4 + 0.319152932694) * d4 - 0.5319230073) * d4 + 0.797884560593) * d3 * 2.0;
            } else {
                d2 = (((((((((((((-4.5255659E-5 * (d3 -= 2.0) + 1.5252929E-4) * d3 - 1.9538132E-5) * d3 - 6.76904986E-4) * d3 + 0.001390604284) * d3 - 7.9462082E-4) * d3 - 0.002034254874) * d3 + 0.006549791214) * d3 - 0.010557625006) * d3 + 0.011630447319) * d3 - 0.009279453341) * d3 + 0.005353579108) * d3 - 0.002141268741) * d3 + 5.35310849E-4) * d3 + 0.999936657524;
            }
        }
        if (d > 0.0) {
            return (d2 + 1.0) / 2.0;
        }
        return (1.0 - d2) / 2.0;
    }

    public static double studentTConfidenceInterval(int n, double d, double d2) {
        return Math.sqrt(Statistics.FCriticalValue(d, 1, n)) * d2;
    }
}

