/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import jaws.classifierPackage.PrismRule;
import jaws.classifierPackage.Test;
import jaws.corePackage.Attribute;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.evaluationPackage.Classifier;
import jaws.evaluationPackage.Evaluation;

public class Prism
extends Classifier {
    private PrismRule rules;

    public double classifyInstance(Instance instance) {
        int n = this.rules.resultRules(instance);
        if (n == -1) {
            return Instance.missingValue();
        }
        return n;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Attribute attribute;
        PrismRule prismRule = null;
        Test test = null;
        if (instances.classAttribute().isNumeric()) {
            throw new Exception("Prism can't handle a numeric class!");
        }
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            if (attribute.isNumeric()) {
                throw new Exception("Prism can't handle numeric attributes!");
            }
            Enumeration enumeration2 = instances.enumerateInstances();
            while (enumeration2.hasMoreElements()) {
                if (!((Instance)enumeration2.nextElement()).isMissing(attribute)) continue;
                throw new Exception("Prism can't handle attributes with missing values!");
            }
        }
        instances.deleteWithMissingClass();
        int n = 0;
        while (n < instances.numClasses()) {
            Instances instances2 = instances;
            while (Prism.contains(instances2, n)) {
                prismRule = this.addRule(prismRule, new PrismRule(instances2, n));
                Instances instances3 = instances2;
                while (prismRule.errors != 0) {
                    test = this.addTest(prismRule, test, new Test());
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    enumeration = instances3.enumerateAttributes();
                    while (enumeration.hasMoreElements()) {
                        attribute = (Attribute)enumeration.nextElement();
                        if (Prism.isMentionedIn(attribute, prismRule.test)) {
                            ++n2;
                            continue;
                        }
                        int n5 = attribute.numValues();
                        int[] nArray = new int[n5];
                        int[] nArray2 = new int[n5];
                        int n6 = 0;
                        while (n6 < n5) {
                            nArray2[n6] = 0;
                            nArray[n6] = 0;
                            ++n6;
                        }
                        Enumeration enumeration3 = instances3.enumerateInstances();
                        while (enumeration3.hasMoreElements()) {
                            Instance instance = (Instance)enumeration3.nextElement();
                            int n7 = (int)instance.value(attribute);
                            nArray[n7] = nArray[n7] + 1;
                            if ((int)instance.classValue() != n) continue;
                            int n8 = (int)instance.value(attribute);
                            nArray2[n8] = nArray2[n8] + 1;
                        }
                        int n9 = 0;
                        while (n9 < n5) {
                            int n10 = nArray2[n9] * n3 - n4 * nArray[n9];
                            if (test.attr == -1 || n10 > 0 || n10 == 0 && nArray2[n9] > n4) {
                                n4 = nArray2[n9];
                                n3 = nArray[n9];
                                test.attr = attribute.index();
                                test.val = n9;
                                prismRule.errors = n3 - n4;
                            }
                            ++n9;
                        }
                    }
                    instances3 = prismRule.coveredBy(instances3);
                    if (n2 == instances.numAttributes() - 1) break;
                }
                instances2 = prismRule.notCoveredBy(instances2);
            }
            ++n;
        }
    }

    public PrismRule addRule(PrismRule prismRule, PrismRule prismRule2) {
        if (prismRule == null) {
            this.rules = prismRule2;
        } else {
            prismRule.next = prismRule2;
        }
        return prismRule2;
    }

    public Test addTest(PrismRule prismRule, Test test, Test test2) {
        if (prismRule.test == null) {
            prismRule.test = test2;
        } else {
            test.next = test2;
        }
        return test2;
    }

    public static boolean contains(Instances instances, int n) throws Exception {
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            if ((int)((Instance)enumeration.nextElement()).classValue() != n) continue;
            return true;
        }
        return false;
    }

    public static boolean isMentionedIn(Attribute attribute, Test test) {
        if (test == null) {
            return false;
        }
        if (test.attr == attribute.index()) {
            return true;
        }
        return Prism.isMentionedIn(attribute, test.next);
    }

    public String toString() {
        return "Prism rules\n----------\n" + this.rules.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Prism(), stringArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            return;
        }
    }
}

