/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import jaws.corePackage.Attribute;
import jaws.corePackage.Instances;

class OneRRule {
    private Instances instances;
    Attribute attr;
    int correct;
    int[] classifications;
    int missingValueClass = -1;
    double[] breakpoints;

    OneRRule(Instances instances, Attribute attribute) {
        this.instances = instances;
        this.attr = attribute;
        this.correct = 0;
        this.classifications = new int[this.attr.numValues()];
    }

    OneRRule(Instances instances, Attribute attribute, int n) {
        this.instances = instances;
        this.attr = attribute;
        this.correct = 0;
        this.classifications = new int[n];
        this.breakpoints = new double[n - 1];
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(this.attr.name()) + ":\n");
            int n = 0;
            while (n < this.classifications.length) {
                stringBuffer.append("\t");
                if (this.attr.isNominal()) {
                    stringBuffer.append(this.attr.value(n));
                } else if (n < this.breakpoints.length) {
                    stringBuffer.append("< " + this.breakpoints[n]);
                } else {
                    stringBuffer.append(">= " + this.breakpoints[n - 1]);
                }
                stringBuffer.append("\t-> " + this.instances.classAttribute().value(this.classifications[n]) + "\n");
                ++n;
            }
            if (this.missingValueClass != -1) {
                stringBuffer.append("\t?\t-> " + this.instances.classAttribute().value(this.missingValueClass) + "\n");
            }
            stringBuffer.append("(" + this.correct + "/" + this.instances.numInstances() + " instances correct)\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print OneR classifier!";
        }
    }
}

