/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.DistributionClassifier;
import jaws.evaluationPackage.Evaluation;

public class KernelDensity
extends DistributionClassifier {
    private double[] theCounts;
    private Instances theInstances;
    private double[] minArray;
    private double[] maxArray;
    private static double CO = Math.sqrt(Math.PI * 2);

    private double normalKernel(double d) {
        return Math.exp(-(d * d) / 2.0) / CO;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new Exception("Class attribute has to be nominal!");
        }
        this.theInstances = instances;
        this.minArray = new double[this.theInstances.numAttributes()];
        this.maxArray = new double[this.theInstances.numAttributes()];
        int n = 0;
        while (n < this.theInstances.numAttributes()) {
            this.maxArray[n] = Double.NaN;
            this.minArray[n] = Double.NaN;
            ++n;
        }
        this.theCounts = new double[this.theInstances.numClasses()];
        int n2 = 0;
        while (n2 < this.theInstances.numInstances()) {
            Instance instance = this.theInstances.instance(n2);
            if (!instance.classIsMissing()) {
                int n3 = (int)instance.classValue();
                this.theCounts[n3] = this.theCounts[n3] + instance.weight();
            }
            this.updateMinMax(instance);
            ++n2;
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return Utils.maxIndex(this.distributionForInstance(instance));
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.theInstances.numClasses()];
        double d = Math.sqrt(Utils.sum(this.theCounts));
        this.updateMinMax(instance);
        int n = 0;
        while (n < this.theInstances.numInstances()) {
            Instance instance2 = this.theInstances.instance(n);
            if (!instance2.classIsMissing()) {
                double d2 = 1.0;
                int n2 = 0;
                while (n2 < this.theInstances.numAttributes()) {
                    if (n2 != this.theInstances.classIndex()) {
                        d2 *= this.normalKernel(this.distance(instance, instance2, n2) * d) * d;
                    }
                    ++n2;
                }
                int n3 = (int)instance2.classValue();
                dArray[n3] = dArray[n3] + d2;
            }
            ++n;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        return "Kernel Density Estimator";
    }

    private double distance(Instance instance, Instance instance2, int n) {
        double d = 0.0;
        if (this.theInstances.attribute(n).isNominal()) {
            if (instance.isMissing(n) || instance2.isMissing(n) || (int)instance.value(n) != (int)instance2.value(n)) {
                d += 1.0;
            }
        } else {
            double d2;
            if (instance.isMissing(n) || instance2.isMissing(n)) {
                if (instance.isMissing(n) && instance2.isMissing(n)) {
                    d2 = 1.0;
                } else {
                    d2 = instance2.isMissing(n) ? this.norm(instance.value(n), n) : this.norm(instance2.value(n), n);
                    if (d2 < 0.5) {
                        d2 = 1.0 - d2;
                    }
                }
            } else {
                d2 = this.norm(instance.value(n), n) - this.norm(instance2.value(n), n);
            }
            d += d2;
        }
        return d;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.minArray[n]) || Utils.eq(this.maxArray[n], this.minArray[n])) {
            return 0.0;
        }
        return (d - this.minArray[n]) / (this.maxArray[n] - this.minArray[n]);
    }

    private void updateMinMax(Instance instance) {
        int n = 0;
        while (n < this.theInstances.numAttributes()) {
            if (this.theInstances.attribute(n).isNumeric() && !instance.isMissing(n)) {
                if (Double.isNaN(this.minArray[n])) {
                    this.minArray[n] = instance.value(n);
                    this.maxArray[n] = instance.value(n);
                } else if (instance.value(n) < this.minArray[n]) {
                    this.minArray[n] = instance.value(n);
                } else if (instance.value(n) > this.maxArray[n]) {
                    this.maxArray[n] = instance.value(n);
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new KernelDensity(), stringArray));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

