/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import jaws.corePackage.Attribute;
import jaws.corePackage.ContingencyTables;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.DistributionClassifier;
import jaws.evaluationPackage.Evaluation;

public class DecisionStump
extends DistributionClassifier {
    private int m_AttIndex;
    private double m_SplitPoint;
    private double[][] m_Distribution;
    private Instances theInstances;

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double[][] dArray = new double[3][instances.numClasses()];
        int n2 = -1;
        this.theInstances = new Instances(instances);
        this.theInstances.deleteWithMissingClass();
        int n3 = this.theInstances.classAttribute().isNominal() ? this.theInstances.numClasses() : 1;
        int n4 = 0;
        while (n4 < this.theInstances.numAttributes()) {
            if (n4 != this.theInstances.classIndex()) {
                this.m_Distribution = new double[3][n3];
                double d3 = this.theInstances.attribute(n4).isNominal() ? this.findSplitNominal(n4) : this.findSplitNumeric(n4);
                if (Utils.sm(d3, d)) {
                    d = d3;
                    n2 = n4;
                    d2 = this.m_SplitPoint;
                    n = 0;
                    while (n < 3) {
                        System.arraycopy(this.m_Distribution[n], 0, dArray[n], 0, n3);
                        ++n;
                    }
                }
            }
            ++n4;
        }
        this.m_AttIndex = n2;
        this.m_SplitPoint = d2;
        this.m_Distribution = dArray;
        if (this.theInstances.classAttribute().isNominal()) {
            n = 0;
            while (n < this.m_Distribution.length) {
                Utils.normalize(this.m_Distribution[n]);
                ++n;
            }
        }
        this.theInstances = new Instances(this.theInstances, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.theInstances.classAttribute().isNominal()) {
            return Utils.maxIndex(this.distributionForInstance(instance));
        }
        return this.m_Distribution[this.whichSubset(instance)][0];
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.theInstances.classAttribute().isNominal()) {
            throw new Exception("Class is numeric!");
        }
        return this.m_Distribution[this.whichSubset(instance)];
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Decision Stump\n\n");
            Attribute attribute = this.theInstances.attribute(this.m_AttIndex);
            if (attribute.isNominal()) {
                stringBuffer.append(String.valueOf(attribute.name()) + " = " + attribute.value((int)this.m_SplitPoint) + "\n");
                stringBuffer.append(this.printDist(this.m_Distribution[0]));
                stringBuffer.append(String.valueOf(attribute.name()) + " != " + attribute.value((int)this.m_SplitPoint) + "\n");
                stringBuffer.append(this.printDist(this.m_Distribution[1]));
            } else {
                stringBuffer.append(String.valueOf(attribute.name()) + " <= " + this.m_SplitPoint + "\n");
                stringBuffer.append(this.printDist(this.m_Distribution[0]));
                stringBuffer.append(String.valueOf(attribute.name()) + " > " + this.m_SplitPoint + "\n");
                stringBuffer.append(this.printDist(this.m_Distribution[1]));
            }
            stringBuffer.append(String.valueOf(attribute.name()) + " is missing\n");
            stringBuffer.append(this.printDist(this.m_Distribution[2]));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print decision stump classifier!";
        }
    }

    private String printDist(double[] dArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.theInstances.classAttribute().isNominal()) {
            int n = 0;
            while (n < this.theInstances.numClasses()) {
                stringBuffer.append(String.valueOf(this.theInstances.classAttribute().value(n)) + "\t");
                ++n;
            }
            stringBuffer.append("\n");
            int n2 = 0;
            while (n2 < this.theInstances.numClasses()) {
                stringBuffer.append(String.valueOf(dArray[n2]) + "\t");
                ++n2;
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append(String.valueOf(dArray[0]) + "\t");
        }
        return stringBuffer.toString();
    }

    private double findSplitNominal(int n) throws Exception {
        if (this.theInstances.classAttribute().isNominal()) {
            return this.findSplitNominalNominal(n);
        }
        return this.findSplitNominalNumeric(n);
    }

    private double findSplitNominalNominal(int n) throws Exception {
        int n2;
        double d = Double.MAX_VALUE;
        double[][] dArray = new double[this.theInstances.attribute(n).numValues() + 1][this.theInstances.numClasses()];
        double[] dArray2 = new double[this.theInstances.numClasses()];
        double[][] dArray3 = new double[3][this.theInstances.numClasses()];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.theInstances.numInstances()) {
            Instance instance = this.theInstances.instance(n4);
            if (instance.isMissing(n)) {
                ++n3;
                double[] dArray4 = dArray[this.theInstances.attribute(n).numValues()];
                int n5 = (int)instance.classValue();
                dArray4[n5] = dArray4[n5] + instance.weight();
            } else {
                double[] dArray5 = dArray[(int)instance.value(n)];
                int n6 = (int)instance.classValue();
                dArray5[n6] = dArray5[n6] + instance.weight();
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < this.theInstances.attribute(n).numValues() + 1) {
            n2 = 0;
            while (n2 < this.theInstances.numClasses()) {
                int n8 = n2;
                dArray2[n8] = dArray2[n8] + dArray[n7][n2];
                ++n2;
            }
            ++n7;
        }
        System.arraycopy(dArray[this.theInstances.attribute(n).numValues()], 0, this.m_Distribution[2], 0, this.theInstances.numClasses());
        n2 = 0;
        while (n2 < this.theInstances.attribute(n).numValues()) {
            int n9 = 0;
            while (n9 < this.theInstances.numClasses()) {
                this.m_Distribution[0][n9] = dArray[n2][n9];
                this.m_Distribution[1][n9] = dArray2[n9] - dArray[n2][n9];
                ++n9;
            }
            double d2 = ContingencyTables.entropyConditionedOnRows(this.m_Distribution);
            if (Utils.sm(d2, d)) {
                d = d2;
                this.m_SplitPoint = n2;
                int n10 = 0;
                while (n10 < 3) {
                    System.arraycopy(this.m_Distribution[n10], 0, dArray3[n10], 0, this.theInstances.numClasses());
                    ++n10;
                }
            }
            ++n2;
        }
        if (n3 == 0) {
            System.arraycopy(dArray2, 0, dArray3[2], 0, this.theInstances.numClasses());
        }
        this.m_Distribution = dArray3;
        return d;
    }

    private double findSplitNominalNumeric(int n) throws Exception {
        double d = Double.MAX_VALUE;
        double[] dArray = new double[this.theInstances.attribute(n).numValues()];
        double[] dArray2 = new double[this.theInstances.attribute(n).numValues()];
        double[] dArray3 = new double[this.theInstances.attribute(n).numValues()];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[][] dArray6 = new double[3][1];
        int n2 = 0;
        while (n2 < this.theInstances.numInstances()) {
            Instance instance = this.theInstances.instance(n2);
            if (instance.isMissing(n)) {
                double[] dArray7 = this.m_Distribution[2];
                dArray7[0] = dArray7[0] + instance.classValue() * instance.weight();
                dArray4[2] = dArray4[2] + instance.classValue() * instance.classValue() * instance.weight();
                dArray5[2] = dArray5[2] + instance.weight();
            } else {
                int n3 = (int)instance.value(n);
                dArray3[n3] = dArray3[n3] + instance.weight();
                int n4 = (int)instance.value(n);
                dArray2[n4] = dArray2[n4] + instance.classValue() * instance.weight();
                int n5 = (int)instance.value(n);
                dArray[n5] = dArray[n5] + instance.classValue() * instance.classValue() * instance.weight();
            }
            ++n2;
        }
        int n6 = 0;
        while (n6 < this.theInstances.attribute(n).numValues()) {
            d4 += dArray3[n6];
            d2 += dArray[n6];
            d3 += dArray2[n6];
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.theInstances.attribute(n).numValues()) {
            this.m_Distribution[0][0] = dArray2[n7];
            dArray4[0] = dArray[n7];
            dArray5[0] = dArray3[n7];
            this.m_Distribution[1][0] = d3 - dArray2[n7];
            dArray4[1] = d2 - dArray[n7];
            dArray5[1] = d4 - dArray3[n7];
            double d5 = this.variance(this.m_Distribution, dArray4, dArray5);
            if (Utils.sm(d5, d)) {
                d = d5;
                this.m_SplitPoint = n7;
                int n8 = 0;
                while (n8 < 3) {
                    dArray6[n8][0] = this.m_Distribution[n8][0] / dArray5[n8];
                    ++n8;
                }
            }
            ++n7;
        }
        if (Utils.eq(dArray5[2], 0.0)) {
            dArray6[2][0] = d3 / d4;
        }
        this.m_Distribution = dArray6;
        return d;
    }

    private double findSplitNumeric(int n) throws Exception {
        if (this.theInstances.classAttribute().isNominal()) {
            return this.findSplitNumericNominal(n);
        }
        return this.findSplitNumericNumeric(n);
    }

    private double findSplitNumericNominal(int n) throws Exception {
        double d = Double.MAX_VALUE;
        int n2 = 0;
        double[] dArray = new double[this.theInstances.numClasses()];
        double[][] dArray2 = new double[3][this.theInstances.numClasses()];
        int n3 = 0;
        while (n3 < this.theInstances.numInstances()) {
            Instance instance = this.theInstances.instance(n3);
            if (!instance.isMissing(n)) {
                double[] dArray3 = this.m_Distribution[1];
                int n4 = (int)instance.classValue();
                dArray3[n4] = dArray3[n4] + instance.weight();
            } else {
                double[] dArray4 = this.m_Distribution[2];
                int n5 = (int)instance.classValue();
                dArray4[n5] = dArray4[n5] + instance.weight();
                ++n2;
            }
            ++n3;
        }
        System.arraycopy(this.m_Distribution[1], 0, dArray, 0, this.theInstances.numClasses());
        this.theInstances.sort(n);
        int n6 = 0;
        while (n6 < this.theInstances.numInstances() - (n2 + 1)) {
            Instance instance = this.theInstances.instance(n6);
            Instance instance2 = this.theInstances.instance(n6 + 1);
            double[] dArray5 = this.m_Distribution[0];
            int n7 = (int)instance.classValue();
            dArray5[n7] = dArray5[n7] + instance.weight();
            double[] dArray6 = this.m_Distribution[1];
            int n8 = (int)instance.classValue();
            dArray6[n8] = dArray6[n8] - instance.weight();
            if (Utils.sm(instance.value(n), instance2.value(n))) {
                double d2 = (instance.value(n) + instance2.value(n)) / 2.0;
                double d3 = ContingencyTables.entropyConditionedOnRows(this.m_Distribution);
                if (Utils.sm(d3, d)) {
                    this.m_SplitPoint = d2;
                    d = d3;
                    int n9 = 0;
                    while (n9 < 3) {
                        System.arraycopy(this.m_Distribution[n9], 0, dArray2[n9], 0, this.theInstances.numClasses());
                        ++n9;
                    }
                }
            }
            ++n6;
        }
        if (n2 == 0) {
            System.arraycopy(dArray, 0, dArray2[2], 0, this.theInstances.numClasses());
        }
        this.m_Distribution = dArray2;
        return d;
    }

    private double findSplitNumericNumeric(int n) throws Exception {
        double d = Double.MAX_VALUE;
        int n2 = 0;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[][] dArray3 = new double[3][1];
        int n3 = 0;
        while (n3 < this.theInstances.numInstances()) {
            Instance instance = this.theInstances.instance(n3);
            if (!instance.isMissing(n)) {
                double[] dArray4 = this.m_Distribution[1];
                dArray4[0] = dArray4[0] + instance.classValue() * instance.weight();
                dArray[1] = dArray[1] + instance.classValue() * instance.classValue() * instance.weight();
                dArray2[1] = dArray2[1] + instance.weight();
            } else {
                double[] dArray5 = this.m_Distribution[2];
                dArray5[0] = dArray5[0] + instance.classValue() * instance.weight();
                dArray[2] = dArray[2] + instance.classValue() * instance.classValue() * instance.weight();
                dArray2[2] = dArray2[2] + instance.weight();
                ++n2;
            }
            ++n3;
        }
        double d2 = this.m_Distribution[1][0] / dArray2[1];
        this.theInstances.sort(n);
        int n4 = 0;
        while (n4 < this.theInstances.numInstances() - (n2 + 1)) {
            Instance instance = this.theInstances.instance(n4);
            Instance instance2 = this.theInstances.instance(n4 + 1);
            double[] dArray6 = this.m_Distribution[0];
            dArray6[0] = dArray6[0] + instance.classValue() * instance.weight();
            dArray[0] = dArray[0] + instance.classValue() * instance.classValue() * instance.weight();
            dArray2[0] = dArray2[0] + instance.weight();
            double[] dArray7 = this.m_Distribution[1];
            dArray7[0] = dArray7[0] - instance.classValue() * instance.weight();
            dArray[1] = dArray[1] - instance.classValue() * instance.classValue() * instance.weight();
            dArray2[1] = dArray2[1] - instance.weight();
            if (Utils.sm(instance.value(n), instance2.value(n))) {
                double d3 = (instance.value(n) + instance2.value(n)) / 2.0;
                double d4 = this.variance(this.m_Distribution, dArray, dArray2);
                if (Utils.sm(d4, d)) {
                    this.m_SplitPoint = d3;
                    d = d4;
                    int n5 = 0;
                    while (n5 < 3) {
                        dArray3[n5][0] = this.m_Distribution[n5][0] / dArray2[n5];
                        ++n5;
                    }
                }
            }
            ++n4;
        }
        if (n2 == 0) {
            dArray3[2][0] = d2;
        }
        this.m_Distribution = dArray3;
        return d;
    }

    private double variance(double[][] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            if (Utils.gr(dArray3[n], 0.0)) {
                d += dArray2[n] - dArray[n][0] * dArray[n][0] / dArray3[n];
            }
            ++n;
        }
        return d;
    }

    private int whichSubset(Instance instance) throws Exception {
        if (instance.isMissing(this.m_AttIndex)) {
            return 2;
        }
        if (instance.attribute(this.m_AttIndex).isNominal()) {
            if ((double)((int)instance.value(this.m_AttIndex)) == this.m_SplitPoint) {
                return 0;
            }
            return 1;
        }
        if (Utils.smOrEq(instance.value(this.m_AttIndex), this.m_SplitPoint)) {
            return 0;
        }
        return 1;
    }

    public static void main(String[] stringArray) {
        try {
            DecisionStump decisionStump = new DecisionStump();
            System.out.println(Evaluation.evaluateModel(decisionStump, stringArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            return;
        }
    }
}

