#define N1		0
#define NT1		1
#define L1		2
#define L1N		3
#define L2		4
#define L2N		5
#define TIE		6
#define HIGH		7
#define LOW		8
#define BD		9

#define MAX_T_SER       30
#define MAX_EQ          (MAX_T_SER * (MAX_T_SER - 1)) + 2
#define MAX_H_PITCH     (MAX_T_SER * MAX_T_SER) + (MAX_T_SER / 2) + 4
#define MAX_CONT        MAX_T_SER + 2

#define C4_INEXPR(c)	((c) ? (c->inExprABL) : (NULL))
#define C4_TREXPR(c)	((c) ? (c->trExprABL) : (NULL))

#define C4_NBINP(c)	((c) ? (c->nbInp) : (-1))
#define C4_NBCUT(c)	((c) ? (c->nbCut) : (-1))
#define C4_NBPITCH(c)	((c) ? (c->nbCut + c->nbInp + c->result->polarity + 1)  \
				: (-1))

#define C4_NBPCHAN(c)	((c) ? (c->nbCh[1]) : (-1))
#define C4_NBNCHAN(c)	((c) ? (c->nbCh[0]) : (-1))
#define C4_NBPCHAN0(c)	((c) ? (c->nbMaxCh[1]) : (-1))
#define C4_NBNCHAN0(c)	((c) ? (c->nbMaxCh[0]) : (-1))

#define C4_NBPTRAN(c)	((c) ? (c->result->nbTPSer) : (-1))
#define C4_NBNTRAN(c)	((c) ? (c->result->nbTNSer) : (-1))

#define C4_POLARITY(c)	((c) ? (c->result->polarity) : (-1))

#define C4_ASSOCLST(c)	((c) ? (c->assocList) : (NULL))

#define C4_CHECKok(c)	((c) ? (c->status.checkExprOK) : (NULL))
#define C4_PLACEok(c)	((c) ? (c->status.placeInputsOK) : (NULL))
#define C4_CONNECTok(c)	((c) ? (c->status.createInterconOK) : (NULL))
#define C4_VROUTok(c)	((c) ? (c->status.routTransOK) : (NULL))

#define C4_COMPok(c)	((c) ? ((c->status.defMemFigOK)			       \
				&& (c->status.checkExprOK)		       \
				&& (c->status.placeInputsOK)		       \
				&& (c->status.createInterconOK)		       \
				&& (c->status.routTransOK)) : (NULL))

#define C4_ROUTok(c)	((c) ? ((C4_COMPok(c))				       \
				&& (C4_NBPCHAN(c) <= C4_NBPCHAN0(c))	       \
				&& (C4_NBNCHAN(c) <= C4_NBNCHAN0(c))) : (NULL))

#define STRLEN_(c)	((long)(c == NULL ? 0 : strlen(c)))

typedef struct trGraph {
  char *trName;
  short loPEq, hiPEq, loNEq, hiNEq;
} TrGraph;

#define blkType		loPEq

typedef struct metalEq {
  short 	noEq;
  short 	noCh;
  short 	nbCont;
  short 	contPos[MAX_CONT];
} MetalEq;

typedef struct resCheck {
  char		polarity;
  char		nbTPSer;
  char		nbTNSer;
  int 	        nbNot;
} ResCheck;

typedef struct funcState {
  unsigned char	defMemFigOK : 1;
  unsigned char	checkExprOK : 1;
  unsigned char	placeInputsOK : 1;
  unsigned char	createInterconOK : 1;
  unsigned char	routTransOK : 1;
} FuncState;

typedef struct vertSeg {
  short		xPos, y1, y2;
} VertSeg;

typedef struct memFig {
  chain_list 	*inExprABL;
  chain_list 	*trExprABL;
  chain_list 	*assocList;
  ResCheck	*result;
  TrGraph 	*tGraph[MAX_H_PITCH];
  MetalEq	*mRout[2][MAX_EQ];
  VertSeg	segInv, segTrsp;
  char		*fName;
  short 	nbEq[2];
  short		nbCut;
  short		nbInp;
  short		nbCh[2];
  short		nbMaxCh[2];
  befig_list 	*beh;
  FuncState	status;
} MemFig;


char *_C4cutSymb;

		/* declaration des ex-static */

char intLev,waitCut;
short inpProc,pEqIndex,nEqIndex;

#define C4_setCutId(s)	(_C4cutSymb = namealloc(s))
#define C4_getCutId	(_C4cutSymb)

MemFig *defMemFig();
void checkExpr();
void placeInputs();
void createIntercon();
void routTrans();
void genFiles();
void undefMemFig();

MemFig *c4_comp();
void c4_gen();
void c4_genfree();
void c4_free();

ptype_list *caracLofig();
