/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_scp2mbk.c                                               */
/*     Contents : function sauvegarde_figure wich save the final placement    */
/*                through MBK data base                                       */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

/******************* ecriture du placement dans mbk physique ******************/

phfig_list *sauvegarde_figure(ptlofig)
lofig_list *ptlofig;
{
	static phfig_list *ptphfig=NULL;
	int ind_cell;
	int ind_row;
	int fig_width = 0, fig_height = 0; 
	float position;

	/******************  chargement du pointeur figure ********************/

    	ptphfig = addphfig(ptlofig->NAME);             /*  ptlofig->NAME */
	
	/**************** calcul de la taille de la figure ********************/

	for (ind_row=0;ind_row<NBROW;ind_row++)        /* bande la plus large */
		if (ROW[ind_row].length>fig_width) 
			fig_width=ROW[ind_row].length;	

	fig_height = NBROW*HEIGHT;

	ptphfig->XAB1 = 0;
	ptphfig->YAB1 = 0; 
	ptphfig->XAB2 = fig_width*SCALE_X;
	ptphfig->YAB2 = fig_height*SCALE_X; 

	/********************* placement des cellules *************************/
	
	for (ind_cell=0;ind_cell < NBCELL;ind_cell++)
	{		
		addphins(ptphfig
			,CELL_REF[ind_cell].figname
			,CELL_REF[ind_cell].insname
			,NOSYM
			,(CELL[ind_cell].pos-CELL[ind_cell].width/2)
					*SCALE_X
			,CELL[ind_cell].row*HEIGHT*SCALE_X);
	}

	/********************** placement des connecteurs *********************/ 
	for (ind_cell=NBCELL;ind_cell<NBCELL+NB_PREP_CON;ind_cell++)
	{
    		position = (float) (CELL[ind_cell].next + 1) 
			   / (NB_CON[CELL[ind_cell].last] + 1);
    		switch (CELL[ind_cell].last)
    		{
        		case 0 : addphcon(ptphfig                 /* face est */
                         		 ,EAST
                         		 ,CELL_REF[ind_cell].figname
                         		 ,fig_width * SCALE_X
                         		 ,(int)(fig_height * position * SCALE_X)
                         		 ,ALU1
                         		 ,1 * SCALE_X);
				 break;

        		case 1 : addphcon(ptphfig               /* face ouest */
                         		 ,WEST
                         		 ,CELL_REF[ind_cell].figname
                         	 	 ,0
                         		 ,(int)(fig_height * position * SCALE_X)
                         		 ,ALU1
                         		 ,1 * SCALE_X);
                 		 break;

        		case 2 : addphcon(ptphfig                 /* face sud */
                         		 ,SOUTH
                         		 ,CELL_REF[ind_cell].figname
                         		 ,(int)(fig_width * position * SCALE_X)
                         		 ,0
                         		 ,ALU2
                         		 ,2 * SCALE_X);
                 		 break;

        		case 3 : addphcon(ptphfig                /* face nord */
                         		 ,NORTH
                         		 ,CELL_REF[ind_cell].figname
                         		 ,(int)(fig_width * position * SCALE_X)
                         		 ,fig_height * SCALE_X
                         		 ,ALU2
                         		 ,2 * SCALE_X);
     		}
	}
	return(ptphfig);
}

