/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Testability Design Rule Checker                             */
/*     File     : @(#)                                                        */
/*     Contents :                                                             */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

void initialisation_connecteurs()
{
    int ind_cell;
    int ind_rang;
    int ind_face;
    int min;
    int cell_min;
    float position;

    /************** recuperation de l'ordre des connecteurs ***************/
 
    for (ind_face = 0;ind_face < 5;ind_face++)
    {
        min = 100000;
        for (ind_rang =0;ind_rang<NB_CON[ind_face];ind_rang++)
        {
            for (ind_cell=NBCELL;ind_cell<NBCELL+NB_PREP_CON;ind_cell++)
            {
                if (CELL[ind_cell].last == ind_face)
                    if (CELL[ind_cell].width < min)
                    {
                        min = CELL[ind_cell].width;
                        cell_min = ind_cell;
                    }
            }
            CELL[cell_min].width = 100000;
            CELL[cell_min].next = ind_rang;
            min = 100000;
        }
    }

    /********************** position des cellules fantomes ********************/

    for (ind_cell=NBCELL;ind_cell<NBCELL+NB_PREP_CON;ind_cell++)
    {
      	position = (float) (CELL[ind_cell].next + 1) 
				/ (NB_CON[CELL[ind_cell].last] + 1);
    	switch (CELL[ind_cell].last)
    	{
       	    case 0 : CELL[ind_cell].pos = IDEAL_ROW_LENGTH;       /* face est */
                     CELL[ind_cell].row = NBROW * position;

            case 1 : CELL[ind_cell].pos = 0;                    /* face ouest */
                     CELL[ind_cell].row = NBROW * position;

            case 2 : CELL[ind_cell].row = 0;                      /* face sud */
                     CELL[ind_cell].pos = IDEAL_ROW_LENGTH * position;

            case 3 : CELL[ind_cell].row = NBROW;                 /* face nord */
                     CELL[ind_cell].pos = IDEAL_ROW_LENGTH * position;
        }
    }
}
