/****************************************************************************
 *                                                                          *
 *           Functions to access the  Technological tables                  *
 *                                                                          *
 ****************************************************************************/

#include "rdsneric.h"
#include RPR_H
#include "rprparse.h"
#include "rpracces.h"

/****************************************************************************
 * GetPostParam: given the physical layer , returns the pointer on the
 *               line referenced by this physical layer in the Postreat table.
 ***************************************************************************/

LinePost *GetPostParam( physical_layer)
char physical_layer;
{
    post_record *pt;

    for( pt = post_tab; pt; pt = pt->NEXT)
          if( physical_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : Post table inconsistency  \n");
	exit(1);
    }
    return( pt );
}


/****************************************************************************
 * GetSegParam: given the symbolic layer (mbk), returns the pointer on 
 *                  the line referenced by this symbolic layer in the 
 *                  Symb_to_Phys table.
 ***************************************************************************/

LineSeg *GetSegParam( symbolic_layer)
char symbolic_layer;
{
    seg_record *pt;

    for( pt = seg_tab; pt; pt = pt->NEXT)
        if( symbolic_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : rfm_segment table inconsistency %d \n", symbolic_layer );
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetConParam: given the physical layer , returns the pointer on the line 
 *              referenced by this physical layer in the connector table.
 ***************************************************************************/

LineCon *GetConParam( physical_layer)
char physical_layer;
{
    con_record *pt;

    for( pt = con_tab; pt; pt = pt->NEXT)
        if( physical_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : rfm_connector table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetViaParam: given the symbolic contact type (mbk), returns the pointer on
 *              the line rferenced by this symbolic contact  in the via table.
 ***************************************************************************/

LineVia *GetViaParam( contact_type)
char contact_type;
{
    via_record *pt;

    for( pt = via_tab; pt; pt = pt->NEXT)
        if( contact_type == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : rfm_via table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetCifLayerParam: given the physical layer , returns the corresponding 
 *                   Cif layer by inspecting the Cif_Layer table.
 ***************************************************************************/

LineCifLayer *GetCifLayerParam( physical_layer)
char physical_layer;
{
    cif_lay_record *pt;

    for( pt = cif_lay_tab; pt; pt = pt->NEXT)
        if( physical_layer== pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : cif_layer table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetGdsLayerParam: given the physical layer , returns the corresponding 
 *                   Gds layer by inspecting the Gds_Layer table.
 ***************************************************************************/

LineGdsLayer *GetGdsLayerParam( symbolic_layer)
char symbolic_layer;
{
    gds_lay_record *pt;

    for( pt = gds_lay_tab; pt; pt = pt->NEXT)
        if( symbolic_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : gds_layer table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetGdsLayerInvParam: given the Gds layer number, returns the corresponding 
 *                      physical layer by inspecting the Gds_Layer table.
 ***************************************************************************/

LineGdsLayerInv *GetGdsLayerInvParam( gds_layer)
char gds_layer;
{

    gds_lay_record *pt;

    for( pt = gds_lay_tab; pt; pt = pt->NEXT)
        if( gds_layer == pt->gds_lay_rec_val)
            break;
    return( pt );
}

/****************************************************************************
 * GetGdslayerwidthParam: given the physical layer, returns the corresponding 
 *                   resize quantity by inspecting the layerwidth table.
 ***************************************************************************/

LineOversize *GetOversizeParam( physical_layer)
char physical_layer;
{
    oversize_record *pt;

    for( pt = oversize_tab; pt; pt = pt->NEXT)
        if( physical_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : oversize table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetRingWidthParam: given the physical layer it returns the corresponding 
 *                  minimum couron width by inspecting the ringwidth table.
 ***************************************************************************/

LineRingWidth *GetRingWidthParam( physical_layer)
char physical_layer;
{
    ringwidth_record *pt;

    for( pt = ringwidth_tab; pt; pt = pt->NEXT)
        if( physical_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : ringwidth table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

/****************************************************************************
 * GetLayerWidthParam: given the physical layer it returns the corresponding 
 *                   minimum segment width by inspecting the LayerWidth table.
 ***************************************************************************/

LineLayerWidth *GetLayerWidthParam( physical_layer)
char physical_layer;
{
    layerwidth_record *pt;

    for( pt = layerwidth_tab; pt; pt = pt->NEXT)
        if( physical_layer == pt->key)
            break;
    if( ! pt) {
	(void)fprintf(stderr, "*** rpr error *** : LayerWdith table inconsistency  \n");
	exit(1);
    }
    return( pt );
}

