/*------------------------------------------------------\
|                                                       |
|  Title   :   Structures and fonctions for RDS Param   |
|                                                       |
|  Date    :               21.09.92                     |  
|                                                       |
|  Author  :           Jacomme Ludovic                  |
|                                                       |
\------------------------------------------------------*/

#ifndef _RPR_    /* Why not PS, PCF or UDF ? */
#define _RPR_

/*------------------------------------------------------\
|              Technology file parameters               |
\------------------------------------------------------*/

#define       RDS_TECHNO_DEFAULT "idps"
extern char * RDS_TECHNO_NAME;

/*------------------------------------------------------\
|                    Les constantes                     |
\------------------------------------------------------*/

#define MAX_RDS_UNIT          100000L
#define MAX_N_SEG_LAYER       3 
#define MAX_N_CON_LAYER       1	/* this value cannot be changed */
#define MAX_N_VIA_LAYER       4
#define N_POST_FIELDS         2
#define N_SEG_FIELDS          ( MAX_N_SEG_LAYER * 3 )
#define N_CON_FIELDS          ( MAX_N_CON_LAYER * 3 )
#define N_VIA_FIELDS          ( MAX_N_VIA_LAYER * 2 )

/*------------------------------------------------------\
|                     Les types                         |
\------------------------------------------------------*/

typedef char  post_rec_typ     [ N_POST_FIELDS ];
typedef long  seg_rec_typ      [ N_SEG_FIELDS  ];
typedef long  con_rec_typ      [ N_CON_FIELDS  ];                    
typedef long  via_rec_typ      [ N_VIA_FIELDS  ];
typedef char *cif_lay_rec_typ;
typedef char  gds_lay_rec_typ;
typedef long  oversize_rec_typ;
typedef long  ringwidth_rec_typ;
typedef long  layerwidth_rec_typ;

typedef struct post_rec
{
    struct post_rec *NEXT;
    char key;
    post_rec_typ post_rec_val;
} post_record;

typedef struct seg_rec
{
    struct seg_rec *NEXT;
    char key;
    seg_rec_typ seg_rec_val;  
} seg_record;


typedef struct con_rec
{
    struct con_rec *NEXT;
    char key;
    con_rec_typ con_rec_val;                    
} con_record;

typedef struct via_rec
{
    struct via_rec *NEXT;
    char key;
    via_rec_typ via_rec_val;
} via_record;

typedef struct cif_lay_rec
{
    struct cif_lay_rec *NEXT;   
    char key;
    cif_lay_rec_typ cif_lay_rec_val;
} cif_lay_record;

typedef struct gds_lay_rec
{
    struct gds_lay_rec *NEXT;
    char key;
    gds_lay_rec_typ gds_lay_rec_val;
} gds_lay_record;

typedef struct oversize_rec
{
    struct oversize_rec *NEXT;
    char key;
    oversize_rec_typ oversize_rec_val;
} oversize_record;

typedef struct ringwidth_rec
{
    struct ringwidth_rec *NEXT;
    char key;
    ringwidth_rec_typ ringwidth_rec_val;
} ringwidth_record;

typedef struct layerwidth_rec{
    struct layerwidth_rec *NEXT;
    char key;
    layerwidth_rec_typ layerwidth_rec_val;
} layerwidth_record;

typedef post_record      LinePost;
typedef seg_record       LineSeg;
typedef con_record       LineCon;
typedef via_record       LineVia;
typedef cif_lay_record   LineCifLayer;
typedef gds_lay_record   LineGdsLayer;
typedef gds_lay_record   LineGdsLayerInv;
typedef oversize_record  LineOversize;
typedef ringwidth_record LineRingWidth;
typedef layerwidth_record LineLayerWidth;

/*------------------------------------------------------\
|                   Variables globales                  |
\------------------------------------------------------*/

extern long   PHYSICAL_GRID_PARAM;
extern long   RDS_UNIT_PARAM;
extern long   LAMBDA_PARAM;

/*------------------------------------------------------\
|                       Les Macros                      |
\------------------------------------------------------*/

/*------------------------------------------------------\
|         acces aux parametres de table seg_tab         |
| line est un pointeur sur une ligne du tableau seg_tab |
| il repere un layer symbolique et les differents layers|
| physiques correspondants                              |
| index est le numero de transformation dans la ligne   |
| index varie de 0 a max_seg_layer                      |
| un layer symbolique est transforme en max_seg_layer   |
| layers physiques maximum                              |
| les macro donnent acces aux donnees caracterisant la  |
| transformation reperee par index                      |
\------------------------------------------------------*/
 
#define GET_SEG_LAYER(line,index)\
        ( (line)->seg_rec_val[0 + (index)*3 ] )
 
#define GET_SEG_DLR(line,index)\
        ( (line)->seg_rec_val[1 + (index)*3 ] )
 
#define GET_SEG_DWR(line,index) \
        ( (line)->seg_rec_val[2 + (index)*3 ] )
 
/*------------------------------------------------------\
|         acces aux parametres de table con_tab         |
| line est un pointeur sur une ligne du tableau con_tab | 
| il repere un layer symbolique et les differents layers|
| physiques correspondants                              | 
| index est le numero de transformation dans la ligne   |
| index varie de 0 a max_con_layer                      | 
| un layer symbolique est transforme en max_con_layer   |
| layers physiques maximum                              |
| les macro donnent acces aux donnees caracterisant la  |
| transformation reperee par index                      |
\------------------------------------------------------*/

#define GET_CON_LAYER(line)\
        ( (line)->con_rec_val[ 0 ] ) 

#define GET_CON_DER(line)\
        ( (line)->con_rec_val[ 1 ] ) 

#define GET_CON_DWR(line) \
        ( (line)->con_rec_val[ 2 ] ) 

/*------------------------------------------------------\
|        acces aux parametres de table via_tab          |
| line est un pointeur sur une ligne du tableau via_tab |
| il repere un via symbolique et les differents layers  |
| physiques correspondant                               | 
| index est le numero de transformation dans la ligne   |
| index varie de 0 a max_via_layer                      | 
| un via est transforme en max_via_layer layers         |
| physiques maximum                                     |
| les macro donnent acces aux donnees caracterisant la  |
| transformation reperee par index                      |
\------------------------------------------------------*/

#define GET_VIA_LAYER(line,index)\
        ( (line)->via_rec_val[     (index)*2 ] ) 

#define GET_VIA_SIZE(line,index)\
        ( (line)->via_rec_val[ 1 + (index)*2 ] ) 

/*------------------------------------------------------\
|         acces aux parametres de table post_tab        |
| line est un pointeur sur une ligne du tableau postreat|
\------------------------------------------------------*/

#define GET_POST_Y_OR_N(line)           \
        ( (line)->post_rec_val[ 0 ] ) 

#define GET_POST_COMPLEMENTARY(line) \
        ( (line)->post_rec_val[ 1 ] ) 

/*------------------------------------------------------\
|         acces aux parametres de table ciflayer        |
| line est un pointeur sur une ligne du tableau ciflayer|
\------------------------------------------------------*/

#define GET_CIF_LAYER(line) ( (line)->cif_lay_rec_val )

/*------------------------------------------------------\
|         acces aux parametres de table gdslayer        |
| line est un pointeur sur une ligne du tableau gdslayer|
\------------------------------------------------------*/

#define GET_GDS_LAYER(line) ( (line)->gds_lay_rec_val )

/*------------------------------------------------------\
|         acces aux parametres de table oversize        |
| line est un pointeur sur une ligne du tableau oversize|
\------------------------------------------------------*/

#define GET_OVERSIZE(line) ( (line)->oversize_rec_val )

/*------------------------------------------------------\
|         acces aux parametres de table ringwidth       |
| line est un pointeur sur une ligne du tabl ringwidth  |
\------------------------------------------------------*/

#define GET_RING_WIDTH(line) ( (line)->ringwidth_rec_val )

/*------------------------------------------------------\
|         acces aux parametres de table layerwitdh      |
| line est un pointeur sur une ligne du tableau minwidth |
\------------------------------------------------------*/

#define GET_LAYER_WIDTH(line) ( (line)->layerwidth_rec_val )

/*------------------------------------------------------\
|                      Les fonctions                    |
\------------------------------------------------------*/

extern LinePost        *GetPostParam();
extern LineSeg         *GetSegParam();
extern LineCon         *GetConParam();
extern LineVia         *GetViaParam();
extern LineCifLayer    *GetCifLayerParam();
extern LineGdsLayer    *GetGdsLayerParam();
extern LineGdsLayerInv *GetGdsLayerInvParam();
extern LineOversize    *GetOversizeParam();
extern LineRingWidth   *GetRingWidthParam();
extern LineLayerWidth  *GetLayerWidthParam();
extern void             LoadParam();

/*------------------------------------------------------\
|                    The define for Grale now a day     |
\------------------------------------------------------*/
extern long MBK_VIA_TO_LAYER_RDS[][3];
extern long SEGMENT_EXTENTION[];
extern long SEGMENT_WIDTH[];
extern long TRANSISTOR_WIDTH;
extern long TRANSISTOR_EXTENTION;
extern long REFERENCE_SIZE;
#define TransistorWidth \
	(TRANSISTOR_WIDTH * RDS_UNIT_PARAM / SCALE_X)
#define TransistorExtension \
	(TRANSISTOR_EXTENTION * RDS_UNIT_PARAM / SCALE_X)
#define ReferenceSize \
	(REFERENCE_SIZE * RDS_UNIT_PARAM / SCALE_X)
#define SegmentWidth(rdslayer) \
	(SEGMENT_WIDTH[rdslayer] * RDS_UNIT_PARAM / SCALE_X)
#define SegmentExtension(rdslayer) \
	(SEGMENT_EXTENTION[rdslayer] * RDS_UNIT_PARAM / SCALE_X)
#define MbkViaToLayerRds(viatype, rdssize) \
	(MBK_VIA_TO_LAYER_RDS[viatype][rdssize] * RDS_UNIT_PARAM / SCALE_X)
#endif 
