
%start inside_pattern outside_pattern detect_format

letter		[a-zA-Z]

%%
\:						{
		BEGIN inside_pattern;
		return (Colon);
						}
\;						{
		BEGIN outside_pattern;
		return (Semicolon);
						}
\.						{
		BEGIN outside_pattern;
		return (Dot);
						}
\,						{ return (Comma); }
\(						{ return (LeftParen); }
\)						{
		BEGIN detect_format;
		return (RightParen);
						}
\?						{ return (QuestionMark); }
\<=						{ return (_LESym); }
<detect_format>[xobXOB]				{
		yylval.immd = yytext[0];
		return (Format);
						}
\'[01]\'					{
		strcpy (buff,yytext);
		return (BitStringLit);
						}
[xX]\"[0-9a-fA-F]+\"				{
		strcpy (buff,yytext);
		return (BitStringLit);
						}
[oO]\"[0-7]+\"					{
		strcpy (buff,yytext);
		return (BitStringLit);
						}
[bB]?\"[01]+\"					{
		strcpy (buff,yytext);
		return (BitStringLit);
						}
<INITIAL,outside_pattern,detect_format>(0|[1-9][0-9]*)	{
		yylval.valu = atoi (yytext);
		return (AbstractLit);
						}
<inside_pattern>[0-9a-fA-F\*\+\-]		{
		yylval.immd = yytext[0];
		return (Literal);
						}
<INITIAL,outside_pattern,detect_format>{letter}(_?({letter}|[0-9]))*	{
		int         code;
		static ht  *hash = NULL;

		yylval.text = namealloc (yytext);
		if ((code = lcl_search (&hash,yylval.text)) == -1)
		  {
		  BEGIN detect_format;
		  return (Identifier);
		  }
		else
		  return (code);
						}
\#.*$						{
		yylval.text = namealloc (&yytext[1]);
		return (Comment);
						}
<INITIAL,outside_pattern,detect_format>\-\-.*$		;
[ \t]						;
\n						{ linnum++; }
.						{ return (UnknownChar); }
%%

/* ###--------------------------------------------------------------### */
/* function	: lcl_search						*/
/* description	: check that an identifier is a reserved word or not	*/
/* called func.	: addht, addhtitem, gethtitem, namealloc		*/
/* ###--------------------------------------------------------------### */

static int lcl_search (pt_hash,key)

ht   **pt_hash;
char  *key;
  {
  if (*pt_hash == NULL)
    {
    *pt_hash = addht (20);

    addhtitem (*pt_hash, namealloc("before")  , BEFORE);
    addhtitem (*pt_hash, namealloc("save")    , SAVE);
    addhtitem (*pt_hash, namealloc("in")      , _IN);
    addhtitem (*pt_hash, namealloc("out")     , _OUT);
    addhtitem (*pt_hash, namealloc("inout")   , _INOUT);
    addhtitem (*pt_hash, namealloc("register"), REGISTER);
    addhtitem (*pt_hash, namealloc("signal")  , SIGNAL);
    addhtitem (*pt_hash, namealloc("begin")   , BEGIN_);
    addhtitem (*pt_hash, namealloc("end")     , END_);
    addhtitem (*pt_hash, namealloc("to")      , TO);
    addhtitem (*pt_hash, namealloc("downto")  , DOWNTO);
    }
  return (gethtitem (*pt_hash,key));
  }
