
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat_drvpat.c						*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: pat format driver from pat structures			*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <mut309.h>
#include <pat103.h>

static void dclini (fp, ptpat)

FILE *fp;
struct papat *ptpat;

  {
  struct paini *ptini = ptpat->PAINI;
  char buffer[256];
  char name[256];
  char oldname[256];
  char *direc;
  int  oldred, redvar, left, right, indx;

  int  i = 0;

  fprintf (fp,"\n-- registers modified before execution of %s\n",
           ptpat->LABEL);
  oldred = sscanf (ptini->NAME,"%s %d",oldname,&left);
  buffer[i] = ptini->VALUE;
  i++;
  ptini = ptini->NEXT;
  while (ptini != NULL)
    {
    redvar = sscanf (ptini->NAME,"%s %d",name,&indx);

    if (!strcmp (name,oldname))
      right = indx;
    else
      {
      buffer[i] = '\0';
      if (oldred == 1)
        fprintf (fp,"%s <= B\"%s\" before %s;\n",oldname,buffer,ptpat->LABEL);
      else
        {
        if (left < right)
          direc = "to";
        else
          direc = "downto";
        fprintf (fp,"%s (%d %s %d) <= B\"%s\" before %s;\n",oldname,left,direc,
                 right,buffer,ptpat->LABEL);
        }
      i      = 0;
      left   = indx;
      oldred = redvar;
      strcpy (oldname,name);
      }
    buffer[i] = ptini->VALUE;
    i++;
    ptini = ptini->NEXT;
    }

  buffer[i] = '\0';
  if (redvar == 1)
    fprintf (fp,"%s <= B\"%s\" before %s;\n",name,buffer,ptpat->LABEL);
  else
    {
    if (left < right)
      direc = "to";
    else
      direc = "downto";
    fprintf (fp,"%s (%d %s %d) <= B\"%s\" before %s;\n",name,left,direc,
             right,buffer,ptpat->LABEL);
    }

  }

/* ###--------------------------------------------------------------### */
/* function	: pat_drvpat						*/
/* dexcription	: produce a text file corresponding to a paseq struct.	*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

void pat_drvpat (ptseq, fp)

struct paseq *ptseq;			/* paseq structure to be drived	*/
FILE         *fp;			/* result file pointer		*/

  {
  struct papat *ptpat;
  struct paevt *ptevt;
  struct pacom *ptcom;
  struct pagrp *ptgrp;
  struct paini *ptini;
  struct paiol *ptiol;
  int           iol_idx = 0;
  int           stt_nbr = 0;
  char         *model;
  char         *buffer;
  char         *signam;
  int           length;
  int           indx;
  int           left;
  int           right;
  int           redvar;
  int           oldred;
  char          name[256];
  char          oldname[256];
  int           line = 1;
  int           column = 5;
  int           maxlabel = 0;
  int           i,j,compare;
  char          sflag = 'S';
  char          format;
  char          seprt;
  int           tmpc;
  time_t        clock;
  char         *mode;
  char         *direc;
  char         *blank = ";;;;;;;;;;;;;;;;;\n";

  if (ptseq != NULL)
    {
	/* ###------------------------------------------------------### */
	/*    for an empty structure exit with out making any action.	*/
	/* Otherwise print the header message.				*/
	/* ###------------------------------------------------------### */

    if (ptseq->SUBSEQ == 1)
      {
      fprintf (fp,"\n-- Pattern description generated by Pat driver v102\n");
      time    (&clock);
      fprintf (fp,"--\t\tdate : %s\n",ctime(&clock));
      fprintf (fp,"-- input / output list :\n");
      }

	/* ###------------------------------------------------------### */
	/*    check the consistency of the sequence of patterns		*/
	/* ###------------------------------------------------------### */

    if (ptseq->ERRFLG != 0)
      {
      fprintf (stderr,"cannot drive unconsistent sequence of patterns\n");
      fprintf (fp    ,"cannot drive unconsistent sequence of patterns\n");
      }
    else
      {
      if (ptseq->SUBSEQ == 1)
        {
        }
      ptcom = ptseq->PACOM;
      ptgrp = ptseq->PAGRP;
      ptiol = ptseq->PAIOL;

	/* ###------------------------------------------------------### */
	/*    scan the input-output list to :				*/
	/*       - print the input-output declaration (only for the	*/
	/*         first sub-sequence)					*/
	/*       - compute the number of characters in a pattern	*/
	/*         (excluding pattern labels) : column			*/
	/*       - compute the maximum length of input-outputs' name :	*/
	/*         line							*/
	/* ###------------------------------------------------------### */

      while (ptiol != NULL)
        {
	/* ###------------------------------------------------------### */
	/*    print a comment line if needed				*/
	/* ###------------------------------------------------------### */

        if ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
          fprintf (fp,"\n");
        while ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
          {
          fprintf (fp,"# %s\n",ptcom->TEXT);
          ptcom = ptcom->NEXT;
          stt_nbr = 0;
          }

	/* ###------------------------------------------------------### */
	/*    prepare input-output's format and mode (only for the	*/
	/* first sub_sequence)						*/
	/* ###------------------------------------------------------### */

        if (ptseq->SUBSEQ == 1)
          {
          format = ptiol->FORMAT;
          switch (ptiol->MODE)
            {
            case 'I':
              mode = "in      "; break;
            case 'O':
            case 'B':
            case 'Z':
              mode = "out     "; break;
            case 'R':
              mode = "register"; break;
            case 'T':
              mode = "inout   "; break;
            case 'S':
            case 'W':
            case 'X':
            case 'U':
              mode = "signal  "; break;
            }
          }

	/* ###------------------------------------------------------### */
	/*    increment the length of the pattern for an output ('?')	*/
	/* ###------------------------------------------------------### */

        if (ptiol->MODE != 'I')
          column++;

        if ((ptgrp != NULL) && (iol_idx == ptgrp->FINDEX))
          {
	/* ###------------------------------------------------------### */
	/*    for an actual or virtual array ...			*/
	/* ###------------------------------------------------------### */

          switch (ptiol->FORMAT)
            {
	/* ###------------------------------------------------------### */
	/*    increment the length of the pattern by the number of	*/
	/* characters needed for the value of the array (including	*/
	/* extra blank characters)					*/
	/* ###------------------------------------------------------### */

            case 'X':
              column += ((ptgrp->LENGTH - 1) / 4) + 1;
              break;
            case 'O':
              column += ((ptgrp->LENGTH - 1) / 3) + 1;
              break;
            case 'B':
              column += ptgrp->LENGTH;
              break;
            }
          column += ptiol->BLANK;

	/* ###------------------------------------------------------### */
	/*    change the maximum length of input-outputs if the	 length	*/
	/* of the current array's name is bigger			*/
	/* ###------------------------------------------------------### */

          length = strlen (ptgrp->NAME);
          if (line < length)
            line = length;

          if (ptseq->SUBSEQ == 1)
            {
	/* ###------------------------------------------------------### */
	/*    for the first sub-sequence ...				*/
	/* ###------------------------------------------------------### */

            if (ptgrp->FLAG == 0)
              {
	/* ###------------------------------------------------------### */
	/*    print out the declaration of an actual array		*/
	/* ###------------------------------------------------------### */

              sscanf (ptiol->NAME,"%s %d",name,&left);
              ptiol += ptgrp->LENGTH - 1;
              sscanf (ptiol->NAME,"%s %d",name,&right);

              if (left < right)
                direc = "to";
              else
                direc = "downto";

              fprintf(fp,"%s %s (%d %s %d) %c",mode,name,left,direc,right,format);
              }
            else
              {
	/* ###------------------------------------------------------### */
	/*    print out the declaration of a virtual array :		*/
	/*       - mode and name					*/
	/*       - for each subelement, its name and if it is an array,	*/
	/*         its left and right bound and direction		*/
	/* ###------------------------------------------------------### */

              fprintf (fp,"%s %s ",mode,ptgrp->NAME);
              seprt = '(';
              oldred = sscanf (ptiol->NAME,"%s %d",oldname,&left);
              ptiol = ptiol->NEXT;
              for (i=1 ; i<ptgrp->LENGTH; i++)
                {
                redvar = sscanf (ptiol->NAME,"%s %d",name,&indx);
          
                if (!strcmp (name,oldname))
                  right = indx;
                else
                  {
                  if (oldred == 1)
                    fprintf (fp,"%c %s",seprt,oldname);
                  else
                    {
                    if (left < right)
                      direc = "to";
                    else
                      direc = "downto";
                    fprintf(fp,"%c %s (%d %s %d)",seprt,oldname,left,direc,right);
                    }
                  left   = indx;
                  oldred = redvar;
                  strcpy (oldname,name);
                  seprt = ',';
                  }
                ptiol++;
                }
          
              ptiol--;
              if (redvar == 1)
                fprintf (fp,"%c %s ) %c",seprt,name,format);
              else
                {
                if (left < right)
                  direc = "to";
                else
                  direc = "downto";
                fprintf (fp,"%c %s (%d %s %d) ) %c",seprt,name,left,direc,
                         right,format);
                }
              }
            }

          iol_idx += ptgrp->LENGTH;
          ptgrp    = ptgrp->NEXT;
          }
        else
          {
	/* ###------------------------------------------------------### */
	/*    for a scalar input-output :				*/
	/*       - print the declaration (only for the first sub-	*/
	/*         sequence)						*/
	/*       - change the maximum length of input-outputs' name	*/
	/*       - increment the length of the pattern			*/
	/* ###------------------------------------------------------### */

          if (ptseq->SUBSEQ == 1)
            {
            redvar = sscanf (ptiol->NAME,"%s %d",name,&indx);
            if (redvar == 1)
              fprintf (fp,"%s %s %c",mode,name,format);
            else
              fprintf (fp,"%s %s (%d) %c",mode,name,indx,format);
            }

          length = strlen (ptiol->NAME);
          if (line < length)
            line = length;

          column += ptiol->BLANK + 1;
          iol_idx++;
          }

	/* ###------------------------------------------------------### */
	/*    print semicolons and '\n'					*/
	/* ###------------------------------------------------------### */

        if (ptseq->SUBSEQ == 1)
          fprintf (fp,"%s",&blank[16 - ptiol->BLANK]);
        ptiol = ptiol->NEXT;
        stt_nbr++;
        }

	/* ###------------------------------------------------------### */
	/*    add the length of longest pattern's label to the length	*/
	/* of the pattern. If the pattern contains an initialization	*/
	/* print it.							*/
	/* ###------------------------------------------------------### */

      ptpat = ptseq->PAPAT;
      while (ptpat != NULL)
        {
        if (ptpat->LABEL != NULL)
          {
          length = strlen (ptpat->LABEL);
          if (maxlabel < length)
            maxlabel = length;
           }
        if (ptpat->PAINI != NULL)
          dclini (fp,ptpat);
        ptpat = ptpat->NEXT;
        }
      column += maxlabel;

	/* ###------------------------------------------------------### */
	/*    make enough allocation for 2 patterns : model, buffer	*/
	/* and, for input-output's names : signam			*/
	/* ###------------------------------------------------------### */

      model  = mbkalloc (sizeof(char) * column * 2);
      signam = mbkalloc (sizeof(char) * column * line);

	/* ###------------------------------------------------------### */
	/*    begin initialisation of model and signam			*/
	/* model represents the format of the pattern : "    :     ;"	*/
	/* signam : "--        \n" x number of lines			*/
	/* ###------------------------------------------------------### */

      for (i=0 ; i<column ; i++)
        model[i] = ' ';
      for (i=0 ; i<line ; i++)
        {
        signam[    (i * column)] = '-';
        signam[1 + (i * column)] = '-';
        for (j=2 ; j<column ; j++)
          signam[j + (i * column)] = ' ';
        signam[j - 1 + (i * column)] = '\n';
        }
      signam[(line * column) - 1] = '\0';
      model [column - 2]         = ';';
      model [column - 1]          = '\0';

      buffer = model + column;
      i      = maxlabel + 1;
      model[i] = ':';
      i += 2;

	/* ###------------------------------------------------------### */
	/*    continue initialization of model and signam		*/
	/* model represents the format of the pattern : "    : ?1234;"	*/
	/* 1,2,3,4 : the value of 1, 2, 3 or, 4, input-outputs is to be	*/
	/*           read to form this character			*/
	/* signam will contain the name of input-outputs one character	*/
	/* per line							*/
	/* ###------------------------------------------------------### */

      ptgrp   = ptseq->PAGRP;
      ptiol   = ptseq->PAIOL;
      iol_idx = 0;
      while (ptiol != NULL)
        {
        if (ptiol->MODE != 'I')
          model[i++] = '?';

        if ((ptgrp != NULL) && (iol_idx == ptgrp->FINDEX))
          {
          j = 0;
          while (ptgrp->NAME[j] != '\0')
            {
            signam[i + (j * column)] = ptgrp->NAME[j];
            j++;
            }
          switch (ptiol->FORMAT)
            {
            case 'X':
              model[i++] = ((ptgrp->LENGTH - 1) % 4) + 1;
              for (j=0 ; j<((ptgrp->LENGTH - 1) / 4); j++)
                model[i++] = 4;
              break;
            case 'O':
              model[i++] = ((ptgrp->LENGTH - 1) % 3) + 1;
              for (j=0 ; j<((ptgrp->LENGTH - 1) / 3) ; j++)
                model[i++] = 3;
              break;
            case 'B':
              for (j=0 ; j<ptgrp->LENGTH ; j++)
                model[i++] = 1;
              break;
            }
          iol_idx += ptgrp->LENGTH;
          ptiol    = ptseq->PAIOL + iol_idx - 1;
          
          ptgrp    = ptgrp->NEXT;
          }
        else
          {
          j = 0;
          while (ptiol->NAME[j] != '\0')
            {
            signam[i + (j * column)] = ptiol->NAME[j];
            j++;
            }
          model[i++] = 1;
          iol_idx++;
          }
        i += ptiol->BLANK;
        ptiol = ptiol->NEXT;
        }

	/* ###------------------------------------------------------### */
	/*    print a comment line if needed				*/
	/* ###------------------------------------------------------### */

      if ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
        fprintf (fp,"\n");
      while ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
        {
        fprintf (fp,"# %s\n",ptcom->TEXT);
        ptcom = ptcom->NEXT;
        stt_nbr = 0;
        }

	/* ###------------------------------------------------------### */
	/*    begin printing the pattern description part		*/
	/* ###------------------------------------------------------### */

      fprintf (fp,"\nbegin\n");
      stt_nbr++;

      fprintf (fp,"\n-- Pattern description :\n\n");
      fprintf (fp,"%s\n\n",signam);
      ptpat = ptseq->PAPAT;
      while (ptpat != NULL)
        {
        i = 0;

	/* ###------------------------------------------------------### */
	/*    print a comment line if needed				*/
	/* ###------------------------------------------------------### */

        if ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
          fprintf (fp,"\n");
        while ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
          {
          fprintf (fp,"# %s\n",ptcom->TEXT);
          ptcom = ptcom->NEXT;
          stt_nbr = 0;
          }

	/* ###------------------------------------------------------### */
	/*    check for processed or unprocessed patterns		*/
	/* ###------------------------------------------------------### */

        if ((ptpat->SIMFLAG == 'U') && (sflag == 'S'))
          fprintf (fp,"\n-- Beware : unprocessed patterns\n\n");

        sflag = ptpat->SIMFLAG;

	/* ###------------------------------------------------------### */
	/*    for each event of the pattern :				*/
	/*      - print an error message if simulation and user values	*/
	/*        mismatch						*/
	/*      - copy the event in the paiol structure			*/
	/* ###------------------------------------------------------### */

        ptevt = ptpat->PAEVT;
        while (ptevt != NULL)
          {
          ptiol = ptseq->PAIOL + ptevt->INDEX;
          if ((ptevt->USRVAL != '*') && (ptevt->USRVAL != ptevt->SIMVAL))
            {
            if (sscanf (ptiol->NAME,"%s %d",name,&indx) == 2)
              sprintf (name,"%s(%d)",name,indx);
            fprintf (fp,"-- error on `%s` expected value : %c\n",
                     name,ptevt->USRVAL);
            }
          ptiol->VALUE = ptevt->SIMVAL;
          ptevt = ptevt->NEXT;
          }

	/* ###------------------------------------------------------### */
	/*    copy the pattern's label in buffer			*/
	/* ###------------------------------------------------------### */

        if (ptpat->LABEL != NULL)
          {
          while (ptpat->LABEL[i] != '\0')
            {
            buffer[i] = ptpat->LABEL[i];
            i++;
            }
          }

	/* ###------------------------------------------------------### */
	/*    fill buffer with the pattern's value : take 1, 2, 3 or, 4	*/
	/* paiol structures to form the value in the buffer		*/
	/* ###------------------------------------------------------### */

        ptiol = ptseq->PAIOL;
        while ((buffer[i] = model[i]) != '\0')
          {
          if ((model[i] >= 1) && (model[i] <= 4))
            {
            tmpc = 0;
            for (j=0 ; j<model[i] ; j++)
              {
              if (tmpc != '*')
                {
                switch (ptiol->VALUE)
                  {
                  case '+':
                    tmpc = (tmpc << 1) + 1; compare = 1; break;
                  case '-':
                    tmpc = tmpc << 1;       compare = 1; break;
                  case '0':
                    tmpc = tmpc << 1;       compare = 0; break;
                  case '1':
                    tmpc = (tmpc << 1) + 1; compare = 0; break;
                  case '*':
                    tmpc = '*';             compare = 1; break;
                  }
                }
              ptiol++;
              }
            if (tmpc == '*')
              buffer[i] = '*';
            else
              {
              if (tmpc < 10)
                buffer[i] = '0' + tmpc;
              else
                buffer[i] = 'a' + tmpc - 10;
              }
            if (((ptiol - 1)->MODE == 'T') && (buffer[i-1] == '?') &&
                ( compare          == 0))
              buffer[i-1] = ' ';
            }
          i++;
          }

        fprintf (fp,"%s\n",buffer);
        stt_nbr++;
        ptpat = ptpat->NEXT;
        }

	/* ###------------------------------------------------------### */
	/*    print a comment line if needed				*/
	/* ###------------------------------------------------------### */

      if ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
        fprintf (fp,"\n");
      while ((ptcom != NULL) && (ptcom->POSITION == stt_nbr))
        {
        fprintf (fp,"# %s\n",ptcom->TEXT);
        ptcom = ptcom->NEXT;
        stt_nbr = 0;
        }

      if (ptseq->SUBSEQ == 1)
        {
        if (ptseq->SAVFLG == 'Y')
          fprintf (fp,"\nsave;\n");

        fprintf (fp,"\nend;\n");
        }
      }
    }
  }
