/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpaseq.c					*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a PAT	*/
/*		  data structure					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include <pat103.h>

/* ###--------------------------------------------------------------### */
/* function	: pat_addpaseq						*/
/* description	: create an empty PASEQ structure at the top of a list	*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_addpaseq (lastpaseq)

struct paseq *lastpaseq;	/* pointer on the last paseq structure	*/

  {
  struct paseq *ptseq;

  ptseq         = (struct paseq *) mbkalloc (sizeof(struct paseq));

  ptseq->PAGRP  = NULL;
  ptseq->PAIOL  = NULL;
  ptseq->PAPAT  = NULL;
  ptseq->PACOM  = NULL;
  ptseq->IOLNBR = 0;
  ptseq->SUBSEQ = 0;
  ptseq->SAVFLG = 'N';
  ptseq->ENDFLG = 'N';
  ptseq->ERRFLG = 0;

  ptseq->NEXT   = lastpaseq;

  return (ptseq);
  }
