/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpapat.c					*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a PAT	*/
/*		  data structure					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include <pat103.h>

/* ###--------------------------------------------------------------### */
/* function	: pat_addpapat						*/
/* description	: create an empty PAGRP structure at the top of a list	*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct papat *pat_addpapat (lastpapat, label, line)

struct papat   *lastpapat;	/* pointer on the last papat structure	*/
char           *label;		/* pattern's label			*/
unsigned short  line;		/* pattern' line number			*/

  {
  struct papat *ptpat;

  label          = namealloc (label);

  ptpat          = (struct papat *) mbkalloc (sizeof(struct papat));
  ptpat->LABEL   = label;
  ptpat->PAEVT   = NULL;
  ptpat->PAINI   = NULL;
  ptpat->LINE    = line;
  ptpat->ACTFLAG = 'U';
  ptpat->SIMFLAG = 'U';
  ptpat->NEXT    = lastpapat;

  return (ptpat);
  }
