/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpagrp.c					*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a PAT	*/
/*		  data structure					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include <pat103.h>

/* ###--------------------------------------------------------------### */
/* function	: pat_addpagrp						*/
/* description	: create an empty PAGRP structure at the top of a list	*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct pagrp *pat_addpagrp (lastpagrp, name, length, index, flag)

struct pagrp   *lastpagrp;	/* pointer on the last pagrp structure	*/
char           *name;		/* array's name				*/
unsigned short  length;		/* array's number of bit		*/
unsigned short  index;		/* index of the first paiol of the array*/
short           flag;		/* actual or virtual (0,1) array	*/

  {
  struct pagrp *ptgrp;

  name          = namealloc (name);

  ptgrp         = (struct pagrp *) mbkalloc (sizeof(struct pagrp));
  ptgrp->NAME   = name;
  ptgrp->LENGTH = length;
  ptgrp->FINDEX = index;
  ptgrp->FLAG   = flag;
  ptgrp->NEXT   = lastpagrp;

  return (ptgrp);
  }
