extern char *malloc(), *realloc();

# line 27 "../struct/mvl_scomp.yac"
#include <stdio.h>
#include "../mvl_include.h"
#include "mvl_stype.h"
#include "mvl_syacc.h"
#include "mvl_stdef.h"


static int       MVL_GENFLG = 0;	/* Indicates if generic 	*/
static int       MVL_CONRNK = 0;       	/* rank of an implicit connexion*/
static int       MVL_SIGIDX = 1;       	/* structural's signal index    */
static int       MVL_SIMFLG = 0;       	/* simple flag                  */
static int       MVL_CONCNT = 0;       	/* connector's count            */
static char      *MVL_MODNAM;        	/* current model name           */
static char      *MVL_CHDNAM;        	/* child's model name           */
static char      *MVL_LOCNAM;        	/* instance's name           	*/
static struct chain *MVL_NM1LST = NULL; /* 1-st name liste              */
static struct chain *MVL_NM2LST = NULL; /* 2-nd name liste              */
static struct lofig *MVL_CHDPNT = NULL; /* current child pointer        */
static struct lofig *MVL_CHDHED = NULL; /* childs list                  */


# line 48 "../struct/mvl_scomp.yac"
typedef union 
  {
  int         valu;
  char       *text;
  char        flag;
  mvl_name    name;
  mvl_expr    expr;
} MVL_Y_STYPE;
# define Ampersand 257
# define Apostrophe 258
# define LeftParen 259
# define RightParen 260
# define DoubleStar 261
# define Star 262
# define Plus 263
# define Comma 264
# define Minus 265
# define VarAsgn 266
# define Colon 267
# define Semicolon 268
# define _LESym 269
# define Box 270
# define _LTSym 271
# define Arrow 272
# define _EQSym 273
# define _GESym 274
# define _GTSym 275
# define Bar 276
# define _NESym 277
# define Dot 278
# define Slash 279
# define Identifier 280
# define DecimalInt 281
# define DecimalReal 282
# define AbstractLit 283
# define BasedInt 284
# define BasedReal 285
# define CharacterLit 286
# define StringLit 287
# define BitStringLit 288
# define ABS 289
# define ACCESS 290
# define AFTER 291
# define ALIAS 292
# define ALL 293
# define _AND 294
# define ARCHITECTURE 295
# define ARRAY 296
# define ASSERT 297
# define ATTRIBUTE 298
# define BEGIN_ 299
# define BIT 300
# define BIT_VECTOR 301
# define BLOCK 302
# define BODY 303
# define BUFFER 304
# define BUS 305
# define CASE 306
# define COMPONENT 307
# define CONFIGURATION 308
# define CONSTANT 309
# define CONVERT 310
# define DISCONNECT 311
# define DOWNTO 312
# define ELSE 313
# define ELSIF 314
# define END_ 315
# define ENTITY 316
# define ERROR 317
# define _EXIT 318
# define FILE_ 319
# define FOR 320
# define FUNCTION 321
# define GENERATE 322
# define GENERIC 323
# define GUARDED 324
# define IF 325
# define _INOUT 326
# define _IN 327
# define IS 328
# define _LABEL 329
# define LIBRARY 330
# define _LINKAGE 331
# define LOOP 332
# define MAP 333
# define MOD 334
# define MUX_BIT 335
# define MUX_VECTOR 336
# define _NAND 337
# define NATURAL 338
# define NATURAL_VECTOR 339
# define NEW 340
# define _NEXT 341
# define _NOR 342
# define _NOT 343
# define NULL_ 344
# define OF 345
# define ON 346
# define OPEN 347
# define _OR 348
# define OTHERS 349
# define _OUT 350
# define PACKAGE 351
# define PORT 352
# define PROCEDURE 353
# define PROCESS 354
# define RANGE 355
# define RECORD 356
# define REG_BIT 357
# define REG_VECTOR 358
# define REGISTER 359
# define REM 360
# define REPORT 361
# define RETURN 362
# define SELECT 363
# define SEVERITY 364
# define SIGNAL 365
# define SUBTYPE 366
# define THEN 367
# define TO 368
# define TRANSPORT 369
# define TYPE 370
# define UNITS 371
# define UNTIL 372
# define USE 373
# define VARIABLE 374
# define WAIT 375
# define WARNING 376
# define WHEN 377
# define WHILE 378
# define WITH 379
# define WOR_BIT 380
# define WOR_VECTOR 381
# define _XOR 382
#define mvl_y_clearin mvl_y_char = -1
#define mvl_y_errok mvl_y_errflag = 0
extern int mvl_y_char;
extern int mvl_y_errflag;
#ifndef MVL_Y_MAXDEPTH
#define MVL_Y_MAXDEPTH 150
#endif
MVL_Y_STYPE mvl_y_lval, mvl_y_val;
# define MVL_Y_ERRCODE 256

# line 1483 "../struct/mvl_scomp.yac"

int mvl_y_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 3,
	328, 120,
	-2, 0,
-1, 5,
	280, 38,
	-2, 0,
-1, 28,
	280, 93,
	-2, 0,
-1, 49,
	299, 42,
	-2, 0,
-1, 66,
	280, 93,
	-2, 0,
-1, 72,
	315, 58,
	-2, 0,
-1, 119,
	280, 93,
	-2, 0,
-1, 156,
	280, 93,
	-2, 0,
-1, 164,
	272, 74,
	-2, 90,
	};
# define MVL_Y_NPROD 127
# define MVL_Y_LAST 289
int mvl_y_act[]={

    93,    96,    45,   139,    62,   135,    41,   183,   181,    80,
    78,   129,   184,   109,    81,    22,    15,   145,    25,    18,
    12,     3,    27,   163,   177,    33,   177,   131,   121,    58,
     5,   182,   143,    79,   124,    95,    98,    87,    99,   100,
     7,    54,   113,     9,    75,     9,   189,     9,    35,   157,
   106,   198,    90,    83,   139,    64,   124,    67,   126,   138,
   101,    89,    45,    45,     9,    29,   186,    24,    28,   112,
    23,   195,   190,   154,   119,   178,   192,   178,    32,    11,
    94,    97,    44,   120,   110,   194,   160,   153,   152,   172,
   162,   165,    92,   111,   133,    26,    40,     6,    34,    53,
   166,    39,    31,    82,     8,    68,   188,   159,   128,   127,
   138,    13,   116,    63,    42,    42,    19,    86,    85,    72,
   149,    51,   132,   108,    37,    91,    61,     8,    43,    60,
    59,    49,    71,    48,    36,    10,    50,    52,    38,    21,
   158,   142,   140,    55,   125,    56,    70,    57,    47,    46,
    65,    66,    30,    17,    20,    16,    14,     4,     2,    69,
     1,    73,   167,    74,   168,   137,   122,    84,    76,   176,
   175,   174,   173,   171,   170,   169,   102,   161,    88,   180,
    77,     0,   103,   107,     0,     8,   104,   114,     0,   105,
     0,     0,   117,     0,     0,     0,     0,     0,     0,     0,
   123,   130,   115,     0,   118,   136,     0,     0,     0,     0,
     0,     0,     0,     0,   141,   148,   134,     0,     0,     0,
     0,     0,     0,     0,     0,   151,   144,     0,     0,   146,
   147,     0,     0,     0,   150,     0,     0,     0,     0,     0,
   164,   185,   187,     0,     0,     0,     0,   155,   156,     0,
     0,   179,     0,   134,     0,     0,     0,     0,     0,     0,
   191,     0,     0,     0,     0,     0,     0,     0,     0,   193,
     0,     0,     0,   196,     0,   197,   202,     0,   200,     0,
   199,   204,   201,   206,   164,   205,   207,   203,   208 };
int mvl_y_pact[]={

  -295, -1000,  -265,  -216, -1000,  -177,  -308, -1000, -1000, -1000,
  -237, -1000, -1000,  -329,  -304,  -237,  -337, -1000,  -189,  -310,
  -293, -1000,  -191,  -231,  -220, -1000,  -237, -1000,  -250,  -220,
  -197, -1000, -1000, -1000, -1000, -1000, -1000,  -220,  -197, -1000,
  -239, -1000, -1000, -1000,  -220, -1000,  -220,  -239,  -270,  -252,
 -1000,  -220,  -220,  -210, -1000, -1000,  -231, -1000, -1000, -1000,
 -1000, -1000,  -220,  -239,  -236, -1000,  -250,  -317, -1000, -1000,
  -214,  -293,  -219, -1000,  -215, -1000, -1000,  -300, -1000, -1000,
 -1000, -1000,  -204,  -300,  -237, -1000, -1000,  -220,  -237,  -217,
  -300,  -339,  -190, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,  -238,  -190,  -220, -1000, -1000, -1000,  -190,  -293,  -185,
  -277, -1000,  -249, -1000,  -208, -1000,  -341,  -277,  -280,  -251,
 -1000, -1000,  -197,  -309, -1000, -1000,  -227,  -220, -1000,  -316,
  -220,  -220,  -197, -1000,  -239, -1000, -1000,  -249, -1000, -1000,
 -1000, -1000, -1000,  -249, -1000,  -186, -1000, -1000,  -220,  -220,
  -218, -1000, -1000, -1000,  -233, -1000,  -251,  -319,  -198,  -197,
 -1000,  -226, -1000, -1000, -1000, -1000,  -187, -1000, -1000, -1000,
 -1000,  -181, -1000, -1000, -1000, -1000, -1000,  -235,  -188, -1000,
  -300, -1000, -1000, -1000, -1000, -1000,  -249, -1000,  -213,  -235,
  -249, -1000,  -235,  -197, -1000,  -235,  -190, -1000,  -233, -1000,
  -258, -1000, -1000,  -197,  -277, -1000, -1000, -1000, -1000 };
int mvl_y_pgo[]={

     0,   180,   179,    92,    83,    97,   100,   178,   177,    90,
    91,   175,   174,   173,    89,   172,   171,   170,   169,    84,
    93,   166,   165,    87,    85,   164,   162,   160,   158,   157,
   156,   155,   154,    95,    98,   153,   152,    82,   102,   149,
   148,    99,   146,   144,   142,   141,    88,   140,   139,   138,
   101,   137,    96,   135,   134,   133,   132,   131,   130,   129,
   126,   125,   123,   122,    94,   120,   119,   118,   117,   112,
   109,   108,   107,    86,   106,   105,   103 };
int mvl_y_r1[]={

     0,    27,    30,    28,    28,    31,    31,    35,    35,    36,
    39,    39,    40,    42,    38,    38,    43,    44,    44,    45,
    47,    47,    46,    19,    19,    20,    21,    22,    22,    32,
    32,    48,    48,    49,    51,    51,    50,    50,    53,    54,
    29,    29,    55,    57,    57,    58,    58,    58,    59,    61,
    60,    62,    62,    63,    65,    65,    64,    64,    56,    66,
    66,    67,    67,    69,    68,    70,    70,    71,    72,    74,
    74,    73,    73,    73,     8,     9,    24,    24,    24,    26,
    25,    10,    11,    12,    13,    13,    14,    15,    16,    16,
    16,    17,    18,    52,    52,     2,     2,     2,     2,     2,
     1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
     3,     3,     3,     4,     4,    75,    41,    76,    76,     7,
     5,     5,     6,    34,    23,    37,    33 };
int mvl_y_r2[]={

     0,     5,     1,    19,     5,     0,     2,    10,     6,     4,
     0,     6,     1,     1,    16,     2,     4,     2,     2,     8,
     0,     6,     2,     1,     3,     7,     7,     3,     3,     0,
     2,    10,     7,     4,     0,     6,    15,     3,     1,     1,
    27,     5,     2,     0,     4,     2,     2,     5,    15,     1,
    15,     0,    10,     4,     0,     6,    15,     3,     2,     0,
     4,     2,     5,     1,    11,     0,     2,    10,     4,     0,
     6,     7,     3,     3,     3,     3,     3,     3,     3,     9,
     5,     3,     3,     3,     3,     7,     3,     3,     3,     3,
     3,     7,     9,     0,     2,     1,     3,     3,     3,     3,
     1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     2,     2,     1,     3,     1,     6,     0,     7,     5,
     1,     3,     3,     3,     3,     3,     3 };
int mvl_y_chk[]={

 -1000,   -27,   -28,   316,   -29,   295,    -5,   256,    -6,   280,
   -53,   256,   328,    -6,   -30,   345,   -31,   -35,   323,    -6,
   -32,   -48,   352,   259,   256,   328,   -33,   315,   259,   256,
   -36,   -38,   309,   256,   -34,   268,   -54,    -5,   -49,   -50,
   -52,   256,   365,   -34,   -37,   260,   -39,   -40,   -55,   -57,
   -34,   -37,   -51,   -41,   280,   -34,   -34,   -41,   299,   -58,
   -59,   -60,   256,   365,   307,   -34,   -34,   267,   -75,   -38,
   -42,   -56,   -66,   -34,   -41,   280,   -50,    -1,   327,   350,
   326,   331,   -76,   267,   -33,   -67,   -68,   256,    -7,   280,
   267,   -61,    -3,   300,   380,   335,   301,   381,   336,   338,
   339,   264,    -3,    -5,   -34,    -6,   267,    -3,   -62,   352,
   -19,   -20,   259,   280,   -19,   -34,   -69,   -19,   -33,   259,
    -4,   305,   -21,   -23,   283,   -43,   266,   -70,   -71,   352,
    -4,   307,   -63,   -64,   -52,   256,   -37,   -22,   368,   312,
   -44,   -23,   -45,   259,   -34,   333,   -34,   -34,   -37,   -65,
   -41,   -23,   -46,   -23,   259,   -34,   -34,   267,   -47,   -72,
   -73,    -8,    -9,   256,   -24,   -10,    -6,   -26,   -25,   -11,
   -12,   -13,   -14,   -15,   -16,   -17,   -18,   259,   310,   -64,
    -2,   327,   350,   326,   331,   -37,   264,   -37,   -74,   272,
   259,   -20,   257,   -10,   -24,   259,    -3,   -46,   264,    -9,
   -23,   -14,   -37,   -10,   -19,   -73,   -37,   -37,    -4 };
int mvl_y_def[]={

     0,    -2,     0,    -2,     1,    -2,     0,     4,   121,   122,
     0,    41,     2,     0,     5,     0,    29,     6,     0,     0,
     0,    30,     0,     0,     0,    39,   120,   126,    -2,     0,
     0,    10,    12,    15,     8,   123,    43,     0,     0,    34,
     0,    37,    94,    32,     0,   125,     9,     0,     0,    -2,
     3,     0,    33,     0,   115,     7,     0,    13,    59,    44,
    45,    46,     0,     0,     0,    31,    -2,   100,   117,    11,
     0,     0,    -2,    47,     0,    49,    35,     0,   101,   102,
   103,   104,   116,     0,   120,    60,    61,     0,     0,     0,
     0,    51,    23,   105,   106,   107,   108,   109,   110,   111,
   112,     0,    23,     0,    62,    63,   119,    23,     0,     0,
   113,    24,     0,   118,     0,    40,    65,   113,     0,    -2,
    36,   114,     0,     0,   124,    14,     0,     0,    66,     0,
     0,     0,     0,    54,     0,    57,    25,     0,    27,    28,
    16,    17,    18,     0,    64,     0,    48,    50,     0,    53,
     0,    26,    20,    22,     0,    52,    -2,    95,     0,     0,
    69,     0,    72,    73,    -2,    75,    76,    77,    78,    81,
    82,    83,    84,    86,    87,    88,    89,     0,     0,    55,
     0,    96,    97,    98,    99,    19,     0,    67,    68,     0,
     0,    80,     0,     0,    90,     0,    23,    21,     0,    71,
     0,    85,    91,     0,   113,    70,    79,    92,    56 };
typedef struct { char *t_name; int t_val; } mvl_y_toktype;
#ifndef MVL_Y_DEBUG
#	define MVL_Y_DEBUG	0	/* don't allow debugging */
#endif

#if MVL_Y_DEBUG

mvl_y_toktype mvl_y_toks[] =
{
	"Ampersand",	257,
	"Apostrophe",	258,
	"LeftParen",	259,
	"RightParen",	260,
	"DoubleStar",	261,
	"Star",	262,
	"Plus",	263,
	"Comma",	264,
	"Minus",	265,
	"VarAsgn",	266,
	"Colon",	267,
	"Semicolon",	268,
	"_LESym",	269,
	"Box",	270,
	"_LTSym",	271,
	"Arrow",	272,
	"_EQSym",	273,
	"_GESym",	274,
	"_GTSym",	275,
	"Bar",	276,
	"_NESym",	277,
	"Dot",	278,
	"Slash",	279,
	"Identifier",	280,
	"DecimalInt",	281,
	"DecimalReal",	282,
	"AbstractLit",	283,
	"BasedInt",	284,
	"BasedReal",	285,
	"CharacterLit",	286,
	"StringLit",	287,
	"BitStringLit",	288,
	"ABS",	289,
	"ACCESS",	290,
	"AFTER",	291,
	"ALIAS",	292,
	"ALL",	293,
	"_AND",	294,
	"ARCHITECTURE",	295,
	"ARRAY",	296,
	"ASSERT",	297,
	"ATTRIBUTE",	298,
	"BEGIN_",	299,
	"BIT",	300,
	"BIT_VECTOR",	301,
	"BLOCK",	302,
	"BODY",	303,
	"BUFFER",	304,
	"BUS",	305,
	"CASE",	306,
	"COMPONENT",	307,
	"CONFIGURATION",	308,
	"CONSTANT",	309,
	"CONVERT",	310,
	"DISCONNECT",	311,
	"DOWNTO",	312,
	"ELSE",	313,
	"ELSIF",	314,
	"END_",	315,
	"ENTITY",	316,
	"ERROR",	317,
	"_EXIT",	318,
	"FILE_",	319,
	"FOR",	320,
	"FUNCTION",	321,
	"GENERATE",	322,
	"GENERIC",	323,
	"GUARDED",	324,
	"IF",	325,
	"_INOUT",	326,
	"_IN",	327,
	"IS",	328,
	"_LABEL",	329,
	"LIBRARY",	330,
	"_LINKAGE",	331,
	"LOOP",	332,
	"MAP",	333,
	"MOD",	334,
	"MUX_BIT",	335,
	"MUX_VECTOR",	336,
	"_NAND",	337,
	"NATURAL",	338,
	"NATURAL_VECTOR",	339,
	"NEW",	340,
	"_NEXT",	341,
	"_NOR",	342,
	"_NOT",	343,
	"NULL_",	344,
	"OF",	345,
	"ON",	346,
	"OPEN",	347,
	"_OR",	348,
	"OTHERS",	349,
	"_OUT",	350,
	"PACKAGE",	351,
	"PORT",	352,
	"PROCEDURE",	353,
	"PROCESS",	354,
	"RANGE",	355,
	"RECORD",	356,
	"REG_BIT",	357,
	"REG_VECTOR",	358,
	"REGISTER",	359,
	"REM",	360,
	"REPORT",	361,
	"RETURN",	362,
	"SELECT",	363,
	"SEVERITY",	364,
	"SIGNAL",	365,
	"SUBTYPE",	366,
	"THEN",	367,
	"TO",	368,
	"TRANSPORT",	369,
	"TYPE",	370,
	"UNITS",	371,
	"UNTIL",	372,
	"USE",	373,
	"VARIABLE",	374,
	"WAIT",	375,
	"WARNING",	376,
	"WHEN",	377,
	"WHILE",	378,
	"WITH",	379,
	"WOR_BIT",	380,
	"WOR_VECTOR",	381,
	"_XOR",	382,
	"-unknown-",	-1	/* ends search */
};

char * mvl_y_reds[] =
{
	"-no such reduction-",
	"design_file : entity_declaration architecture_body",
	"entity_declaration : ENTITY .simple_name. IS",
	"entity_declaration : ENTITY .simple_name. IS .generic_clause. .port_clause. END_ERR .simple_name. Semicolon_ERR",
	"entity_declaration : ENTITY error",
	".generic_clause. : /* empty */",
	".generic_clause. : generic_clause",
	"generic_clause : GENERIC LeftParen formal_generic_list RightParen_ERR Semicolon_ERR",
	"generic_clause : GENERIC error Semicolon_ERR",
	"formal_generic_list : formal_generic_element ...formal_generic_element..",
	"...formal_generic_element.. : /* empty */",
	"...formal_generic_element.. : ...formal_generic_element.. Semicolon_ERR formal_generic_element",
	"formal_generic_element : CONSTANT",
	"formal_generic_element : CONSTANT identifier_list",
	"formal_generic_element : CONSTANT identifier_list Colon type_mark .constraint. generic_VarAsgn__expression",
	"formal_generic_element : error",
	"generic_VarAsgn__expression : VarAsgn generic_expression",
	"generic_expression : abstractlit",
	"generic_expression : generic_aggregate",
	"generic_aggregate : LeftParen generic_element_association ...generic_element_association.. RightParen_ERR",
	"...generic_element_association.. : /* empty */",
	"...generic_element_association.. : ...generic_element_association.. Comma generic_element_association",
	"generic_element_association : abstractlit",
	".constraint. : /* empty */",
	".constraint. : constraint",
	"constraint : LeftParen range RightParen_ERR",
	"range : abstractlit direction abstractlit",
	"direction : TO",
	"direction : DOWNTO",
	".port_clause. : /* empty */",
	".port_clause. : port_clause",
	"port_clause : PORT LeftParen formal_port_list RightParen_ERR Semicolon_ERR",
	"port_clause : PORT error Semicolon_ERR",
	"formal_port_list : formal_port_element ...formal_port_element..",
	"...formal_port_element.. : /* empty */",
	"...formal_port_element.. : ...formal_port_element.. Semicolon_ERR formal_port_element",
	"formal_port_element : .SIGNAL. identifier_list Colon .mode. type_mark .constraint. .BUS.",
	"formal_port_element : error",
	"architecture_body : ARCHITECTURE",
	"architecture_body : ARCHITECTURE simple_name OF simple_name IS",
	"architecture_body : ARCHITECTURE simple_name OF simple_name IS architecture_declarative_part BEGIN_ architecture_statement_part END_ERR .simple_name. Semicolon_ERR",
	"architecture_body : ARCHITECTURE error",
	"architecture_declarative_part : ..block_declaration_item..",
	"..block_declaration_item.. : /* empty */",
	"..block_declaration_item.. : ..block_declaration_item.. block_declaration_item",
	"block_declaration_item : signal_declaration",
	"block_declaration_item : component_declaration",
	"block_declaration_item : error Semicolon_ERR",
	"signal_declaration : SIGNAL identifier_list Colon type_mark .constraint. .BUS. Semicolon_ERR",
	"component_declaration : COMPONENT Identifier",
	"component_declaration : COMPONENT Identifier .PORT__local_port_list. END_ERR COMPONENT Semicolon_ERR",
	".PORT__local_port_list. : /* empty */",
	".PORT__local_port_list. : PORT LeftParen local_port_list RightParen_ERR Semicolon_ERR",
	"local_port_list : local_port_element ...local_port_element..",
	"...local_port_element.. : /* empty */",
	"...local_port_element.. : ...local_port_element.. Semicolon_ERR local_port_element",
	"local_port_element : .SIGNAL. identifier_list Colon .local_port_mode. type_mark .constraint. .BUS.",
	"local_port_element : error",
	"architecture_statement_part : ..concurrent_statement..",
	"..concurrent_statement.. : /* empty */",
	"..concurrent_statement.. : ..concurrent_statement.. concurrent_statement",
	"concurrent_statement : component_instantiation_statement",
	"concurrent_statement : error Semicolon_ERR",
	"component_instantiation_statement : a_label simple_name",
	"component_instantiation_statement : a_label simple_name .port_map_aspect. Semicolon_ERR",
	".port_map_aspect. : /* empty */",
	".port_map_aspect. : port_map_aspect",
	"port_map_aspect : PORT MAP LeftParen association_list RightParen_ERR",
	"association_list : association_element ...association_element..",
	"...association_element.. : /* empty */",
	"...association_element.. : ...association_element.. Comma association_element",
	"association_element : formal_port_name Arrow actual_port_name",
	"association_element : actual_port_name",
	"association_element : error",
	"formal_port_name : name",
	"actual_port_name : expression",
	"name : simple_name",
	"name : indexed_name",
	"name : slice_name",
	"indexed_name : simple_name LeftParen abstractlit RightParen_ERR",
	"slice_name : simple_name constraint",
	"expression : relation",
	"relation : simple_expression",
	"simple_expression : .sign.term..add_op__term..",
	".sign.term..add_op__term.. : term",
	".sign.term..add_op__term.. : .sign.term..add_op__term.. Ampersand term",
	"term : factor",
	"factor : primary",
	"primary : aggregate",
	"primary : type_convertion",
	"primary : name",
	"aggregate : LeftParen expression RightParen_ERR",
	"type_convertion : CONVERT LeftParen expression RightParen_ERR",
	".SIGNAL. : /* empty */",
	".SIGNAL. : SIGNAL",
	".local_port_mode. : /* empty */",
	".local_port_mode. : _IN",
	".local_port_mode. : _OUT",
	".local_port_mode. : _INOUT",
	".local_port_mode. : _LINKAGE",
	".mode. : /* empty */",
	".mode. : _IN",
	".mode. : _OUT",
	".mode. : _INOUT",
	".mode. : _LINKAGE",
	"type_mark : BIT",
	"type_mark : WOR_BIT",
	"type_mark : MUX_BIT",
	"type_mark : BIT_VECTOR",
	"type_mark : WOR_VECTOR",
	"type_mark : MUX_VECTOR",
	"type_mark : NATURAL",
	"type_mark : NATURAL_VECTOR",
	".BUS. : /* empty */",
	".BUS. : BUS",
	"identifier_list : Identifier",
	"identifier_list : Identifier ...identifier..",
	"...identifier.. : /* empty */",
	"...identifier.. : ...identifier.. Comma Identifier",
	"a_label : Identifier Colon",
	".simple_name. : /* empty */",
	".simple_name. : simple_name",
	"simple_name : Identifier",
	"Semicolon_ERR : Semicolon",
	"abstractlit : AbstractLit",
	"RightParen_ERR : RightParen",
	"END_ERR : END_",
};
#endif /* MVL_Y_DEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define MVL_Y_ERROR		goto mvl_y_errlab
#define MVL_Y_ACCEPT	{ free(mvl_y_s); free(mvl_y_v); return(0); }
#define MVL_Y_ABORT		{ free(mvl_y_s); free(mvl_y_v); return(1); }
#define MVL_Y_BACKUP( newtoken, newvalue )\
{\
	if ( mvl_y_char >= 0 || ( mvl_y_r2[ mvl_y_tmp ] >> 1 ) != 1 )\
	{\
		mvl_y_error( "syntax error - cannot backup" );\
		goto mvl_y_errlab;\
	}\
	mvl_y_char = newtoken;\
	mvl_y_state = *mvl_y_ps;\
	mvl_y_lval = newvalue;\
	goto mvl_y_newstate;\
}
#define MVL_Y_RECOVERING()	(!!mvl_y_errflag)
#ifndef MVL_Y_DEBUG
#	define MVL_Y_DEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int mvl_y_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define MVL_Y_FLAG		(-1000)

/*
** static variables used by the parser
*/
static MVL_Y_STYPE *mvl_y_v;			/* value stack */
static int *mvl_y_s;			/* state stack */

static MVL_Y_STYPE *mvl_y_pv;			/* top of value stack */
static int *mvl_y_ps;			/* top of state stack */

static int mvl_y_state;			/* current state */
static int mvl_y_tmp;			/* extra var (lasts between blocks) */

int mvl_y_nerrs;			/* number of errors */

int mvl_y_errflag;			/* error recovery flag */
int mvl_y_char;			/* current input token number */


/*
** mvl_y_parse - return 0 if worked, 1 if syntax error not recovered from
*/
int
mvl_y_parse()
{
	register MVL_Y_STYPE *mvl_y_pvt;	/* top of value stack for $vars */
	unsigned mvl_y_maxdepth = MVL_Y_MAXDEPTH;

	/*
	** Initialize externals - mvl_y_parse may be called more than once
	*/
	mvl_y_v = (MVL_Y_STYPE*)malloc(mvl_y_maxdepth*sizeof(MVL_Y_STYPE));
	mvl_y_s = (int*)malloc(mvl_y_maxdepth*sizeof(int));
	if (!mvl_y_v || !mvl_y_s)
	{
		mvl_y_error( "out of memory" );
		return(1);
	}
	mvl_y_pv = &mvl_y_v[-1];
	mvl_y_ps = &mvl_y_s[-1];
	mvl_y_state = 0;
	mvl_y_tmp = 0;
	mvl_y_nerrs = 0;
	mvl_y_errflag = 0;
	mvl_y_char = -1;

	goto mvl_y_stack;
	{
		register MVL_Y_STYPE *mvl_y__pv;	/* top of value stack */
		register int *mvl_y__ps;		/* top of state stack */
		register int mvl_y__state;		/* current state */
		register int  mvl_y__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if MVL_Y_BACKUP was called.
		*/
	mvl_y_newstate:
		mvl_y__pv = mvl_y_pv;
		mvl_y__ps = mvl_y_ps;
		mvl_y__state = mvl_y_state;
		goto mvl_y__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	mvl_y_stack:
		mvl_y__pv = mvl_y_pv;
		mvl_y__ps = mvl_y_ps;
		mvl_y__state = mvl_y_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	mvl_y__stack:
		/*
		** put a state and value onto the stacks
		*/
#if MVL_Y_DEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( mvl_y_debug )
		{
			register int mvl_y__i;

			(void)printf( "State %d, token ", mvl_y__state );
			if ( mvl_y_char == 0 )
				(void)printf( "end-of-file\n" );
			else if ( mvl_y_char < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( mvl_y__i = 0; mvl_y_toks[mvl_y__i].t_val >= 0;
					mvl_y__i++ )
				{
					if ( mvl_y_toks[mvl_y__i].t_val == mvl_y_char )
						break;
				}
				(void)printf( "%s\n", mvl_y_toks[mvl_y__i].t_name );
			}
		}
#endif /* MVL_Y_DEBUG */
		if ( ++mvl_y__ps >= &mvl_y_s[ mvl_y_maxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int mvl_y_ps_index = (mvl_y__ps - mvl_y_s);
			int mvl_y_pv_index = (mvl_y__pv - mvl_y_v);
			int mvl_y_pvt_index = (mvl_y_pvt - mvl_y_v);
			mvl_y_maxdepth += MVL_Y_MAXDEPTH;
			mvl_y_v = (MVL_Y_STYPE*)realloc((char*)mvl_y_v,
				mvl_y_maxdepth * sizeof(MVL_Y_STYPE));
			mvl_y_s = (int*)realloc((char*)mvl_y_s,
				mvl_y_maxdepth * sizeof(int));
			if (!mvl_y_v || !mvl_y_s)
			{
				mvl_y_error( "yacc stack overflow" );
				return(1);
			}
			mvl_y__ps = mvl_y_s + mvl_y_ps_index;
			mvl_y__pv = mvl_y_v + mvl_y_pv_index;
			mvl_y_pvt = mvl_y_v + mvl_y_pvt_index;
		}
		*mvl_y__ps = mvl_y__state;
		*++mvl_y__pv = mvl_y_val;

		/*
		** we have a new state - find out what to do
		*/
	mvl_y__newstate:
		if ( ( mvl_y__n = mvl_y_pact[ mvl_y__state ] ) <= MVL_Y_FLAG )
			goto mvl_y_default;		/* simple state */
#if MVL_Y_DEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		mvl_y_tmp = mvl_y_char < 0;
#endif
		if ( ( mvl_y_char < 0 ) && ( ( mvl_y_char = mvl_y_lex() ) < 0 ) )
			mvl_y_char = 0;		/* reached EOF */
#if MVL_Y_DEBUG
		if ( mvl_y_debug && mvl_y_tmp )
		{
			register int mvl_y__i;

			(void)printf( "Received token " );
			if ( mvl_y_char == 0 )
				(void)printf( "end-of-file\n" );
			else if ( mvl_y_char < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( mvl_y__i = 0; mvl_y_toks[mvl_y__i].t_val >= 0;
					mvl_y__i++ )
				{
					if ( mvl_y_toks[mvl_y__i].t_val == mvl_y_char )
						break;
				}
				(void)printf( "%s\n", mvl_y_toks[mvl_y__i].t_name );
			}
		}
#endif /* MVL_Y_DEBUG */
		if ( ( ( mvl_y__n += mvl_y_char ) < 0 ) || ( mvl_y__n >= MVL_Y_LAST ) )
			goto mvl_y_default;
		if ( mvl_y_chk[ mvl_y__n = mvl_y_act[ mvl_y__n ] ] == mvl_y_char )	/*valid shift*/
		{
			mvl_y_char = -1;
			mvl_y_val = mvl_y_lval;
			mvl_y__state = mvl_y__n;
			if ( mvl_y_errflag > 0 )
				mvl_y_errflag--;
			goto mvl_y__stack;
		}

	mvl_y_default:
		if ( ( mvl_y__n = mvl_y_def[ mvl_y__state ] ) == -2 )
		{
#if MVL_Y_DEBUG
			mvl_y_tmp = mvl_y_char < 0;
#endif
			if ( ( mvl_y_char < 0 ) && ( ( mvl_y_char = mvl_y_lex() ) < 0 ) )
				mvl_y_char = 0;		/* reached EOF */
#if MVL_Y_DEBUG
			if ( mvl_y_debug && mvl_y_tmp )
			{
				register int mvl_y__i;

				(void)printf( "Received token " );
				if ( mvl_y_char == 0 )
					(void)printf( "end-of-file\n" );
				else if ( mvl_y_char < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( mvl_y__i = 0;
						mvl_y_toks[mvl_y__i].t_val >= 0;
						mvl_y__i++ )
					{
						if ( mvl_y_toks[mvl_y__i].t_val
							== mvl_y_char )
						{
							break;
						}
					}
					(void)printf( "%s\n", mvl_y_toks[mvl_y__i].t_name );
				}
			}
#endif /* MVL_Y_DEBUG */
			/*
			** look through exception table
			*/
			{
				register int *mvl_y_xi = mvl_y_exca;

				while ( ( *mvl_y_xi != -1 ) ||
					( mvl_y_xi[1] != mvl_y__state ) )
				{
					mvl_y_xi += 2;
				}
				while ( ( *(mvl_y_xi += 2) >= 0 ) &&
					( *mvl_y_xi != mvl_y_char ) )
					;
				if ( ( mvl_y__n = mvl_y_xi[1] ) < 0 )
					MVL_Y_ACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( mvl_y__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( mvl_y_errflag )
			{
			case 0:		/* new error */
				mvl_y_error( "syntax error" );
				goto skip_init;
			mvl_y_errlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				mvl_y__pv = mvl_y_pv;
				mvl_y__ps = mvl_y_ps;
				mvl_y__state = mvl_y_state;
				mvl_y_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				mvl_y_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( mvl_y__ps >= mvl_y_s )
				{
					mvl_y__n = mvl_y_pact[ *mvl_y__ps ] + MVL_Y_ERRCODE;
					if ( mvl_y__n >= 0 && mvl_y__n < MVL_Y_LAST &&
						mvl_y_chk[mvl_y_act[mvl_y__n]] == MVL_Y_ERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						mvl_y__state = mvl_y_act[ mvl_y__n ];
						goto mvl_y__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if MVL_Y_DEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( mvl_y_debug )
						(void)printf( _POP_, *mvl_y__ps,
							mvl_y__ps[-1] );
#	undef _POP_
#endif
					mvl_y__ps--;
					mvl_y__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				MVL_Y_ABORT;
			case 3:		/* no shift yet; eat a token */
#if MVL_Y_DEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( mvl_y_debug )
				{
					register int mvl_y__i;

					(void)printf( "Error recovery discards " );
					if ( mvl_y_char == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( mvl_y_char < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( mvl_y__i = 0;
							mvl_y_toks[mvl_y__i].t_val >= 0;
							mvl_y__i++ )
						{
							if ( mvl_y_toks[mvl_y__i].t_val
								== mvl_y_char )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							mvl_y_toks[mvl_y__i].t_name );
					}
				}
#endif /* MVL_Y_DEBUG */
				if ( mvl_y_char == 0 )	/* reached EOF. quit */
					MVL_Y_ABORT;
				mvl_y_char = -1;
				goto mvl_y__newstate;
			}
		}/* end if ( mvl_y__n == 0 ) */
		/*
		** reduction by production mvl_y__n
		** put stack tops, etc. so things right after switch
		*/
#if MVL_Y_DEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( mvl_y_debug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				mvl_y__n, mvl_y_reds[ mvl_y__n ] );
#endif
		mvl_y_tmp = mvl_y__n;			/* value to switch over */
		mvl_y_pvt = mvl_y__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using mvl_y__state here as temporary
		** register variable, but why not, if it works...
		** If mvl_y_r2[ mvl_y__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto mvl_y__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int mvl_y__len = mvl_y_r2[ mvl_y__n ];

			if ( !( mvl_y__len & 01 ) )
			{
				mvl_y__len >>= 1;
				mvl_y_val = ( mvl_y__pv -= mvl_y__len )[1];	/* $$ = $1 */
				mvl_y__state = mvl_y_pgo[ mvl_y__n = mvl_y_r1[ mvl_y__n ] ] +
					*( mvl_y__ps -= mvl_y__len ) + 1;
				if ( mvl_y__state >= MVL_Y_LAST ||
					mvl_y_chk[ mvl_y__state =
					mvl_y_act[ mvl_y__state ] ] != -mvl_y__n )
				{
					mvl_y__state = mvl_y_act[ mvl_y_pgo[ mvl_y__n ] ];
				}
				goto mvl_y__stack;
			}
			mvl_y__len >>= 1;
			mvl_y_val = ( mvl_y__pv -= mvl_y__len )[1];	/* $$ = $1 */
			mvl_y__state = mvl_y_pgo[ mvl_y__n = mvl_y_r1[ mvl_y__n ] ] +
				*( mvl_y__ps -= mvl_y__len ) + 1;
			if ( mvl_y__state >= MVL_Y_LAST ||
				mvl_y_chk[ mvl_y__state = mvl_y_act[ mvl_y__state ] ] != -mvl_y__n )
			{
				mvl_y__state = mvl_y_act[ mvl_y_pgo[ mvl_y__n ] ];
			}
		}
					/* save until reenter driver code */
		mvl_y_state = mvl_y__state;
		mvl_y_ps = mvl_y__ps;
		mvl_y_pv = mvl_y__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( mvl_y_tmp )
	{
		
case 1:
# line 217 "../struct/mvl_scomp.yac"
{
		freelomodel (MVL_CHDHED);
		mvl_fretab (MVL_HSHTAB);
		} break;
case 2:
# line 227 "../struct/mvl_scomp.yac"
{
		MVL_HSHTAB = mvl_initab ();
/* Initialization */
MVL_SIMFLG = 0;           /* simple flag                  */
MVL_NM1LST = NULL;        /* 1-st name liste              */
MVL_NM2LST = NULL;        /* 2-nd name liste              */
MVL_CHDPNT = NULL;        /* current child pointer        */
MVL_CHDHED = NULL;        /* childs list                  */
/* Enf of initialization */

		MVL_MODNAM = mvl_y_pvt[-1].text;
		mvl_addtab (MVL_HSHTAB,MVL_MODNAM,MVL_MODNAM,MVL_MODDFN,
		            MVL_ROTDFN);
		/*MVL_LOFPNT = addlofig (MVL_MODNAM);*/
		} break;
case 3:
# line 247 "../struct/mvl_scomp.yac"
{
		if ((mvl_y_pvt[-1].text != NULL) && (mvl_y_pvt[-1].text != mvl_y_pvt[-7].text))
		  mvl_error (1,mvl_y_pvt[-1].text);
		mvl_addtab (MVL_HSHTAB,MVL_MODNAM,MVL_MODNAM,MVL_CCNDFN,
		            MVL_CONCNT);
		MVL_CONCNT = 0;
		} break;
case 4:
# line 256 "../struct/mvl_scomp.yac"
{ mvl_error (2,""); } break;
case 12:
# line 289 "../struct/mvl_scomp.yac"
{
            MVL_GENFLG = 1;
            } break;
case 13:
# line 293 "../struct/mvl_scomp.yac"
{
            MVL_GENFLG = 0;
            } break;
case 23:
# line 333 "../struct/mvl_scomp.yac"
{
                mvl_y_val.name.LEFT  = -1;
                mvl_y_val.name.RIGHT = -1;
		mvl_y_val.name.ERR_FLG = 0;
                } break;
case 24:
# line 339 "../struct/mvl_scomp.yac"
{ mvl_y_val.name = mvl_y_pvt[-0].name; } break;
case 25:
# line 346 "../struct/mvl_scomp.yac"
{ mvl_y_val.name = mvl_y_pvt[-1].name; } break;
case 26:
# line 353 "../struct/mvl_scomp.yac"
{
                mvl_y_val.name.LEFT  = mvl_y_pvt[-2].valu;
                mvl_y_val.name.RIGHT = mvl_y_pvt[-0].valu;

                if (((mvl_y_pvt[-2].valu > mvl_y_pvt[-0].valu) && (mvl_y_pvt[-1].valu == MVL_UPTDFN)) ||
		    ((mvl_y_pvt[-2].valu < mvl_y_pvt[-0].valu) && (mvl_y_pvt[-1].valu == MVL_DWTDFN)))
		  {
                  mvl_error (32,"");
		  mvl_y_val.name.ERR_FLG = 1;
		  }
		else
		  mvl_y_val.name.ERR_FLG = 0;
                } break;
case 27:
# line 370 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_UPTDFN; } break;
case 28:
# line 372 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_DWTDFN; } break;
case 32:
# line 389 "../struct/mvl_scomp.yac"
{ mvl_error (3,""); } break;
case 36:
# line 412 "../struct/mvl_scomp.yac"
{
		struct locon *locon_pnt;
		struct losig *losig_pnt;
		int           sig_width;
		int           sig_conf;
		char         *sig_name;
		struct chain *sig_list;
		int           local_err;

		local_err = mvl_y_pvt[-1].name.ERR_FLG;
  		if ((mvl_y_pvt[-1].name.LEFT==-1)&&((mvl_y_pvt[-2].valu==MVL_BTVDFN)||(mvl_y_pvt[-2].valu==MVL_MXVDFN)||(mvl_y_pvt[-2].valu==MVL_WRVDFN)))
                  {
                  mvl_error (33,"");
                  }

		if (mvl_y_pvt[-1].name.LEFT <= mvl_y_pvt[-1].name.RIGHT)
		  sig_width = mvl_y_pvt[-1].name.RIGHT - mvl_y_pvt[-1].name.LEFT  + 1;
		else
		  sig_width = mvl_y_pvt[-1].name.LEFT  - mvl_y_pvt[-1].name.RIGHT + 1;

		sig_conf   = mvl_y_pvt[-3].valu + mvl_y_pvt[-2].valu + mvl_y_pvt[-0].valu;
		MVL_NM1LST = mvl_reverse (MVL_NM1LST);
		sig_list   = MVL_NM1LST;
		while ((sig_list != NULL) && (local_err == 0))
		  {
		  sig_name = (char *)sig_list->DATA;

		  if (mvl_chktab (MVL_HSHTAB,sig_name,MVL_MODNAM,
		                  MVL_SIGDFN) != 0)
		    mvl_error (4,sig_name);
		  else
		    {
		    switch (sig_conf)
		      {
		      case (MVL_ICNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_ICNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','0',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'I',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_OCNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_OCNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','0',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'O',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_OCNDFN + MVL_MUXDFN + MVL_BUSDFN) :
		      case (MVL_OCNDFN + MVL_MXVDFN + MVL_BUSDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','M',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'Z',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_OCNDFN + MVL_WORDFN + MVL_BUSDFN) :
		      case (MVL_OCNDFN + MVL_WRVDFN + MVL_BUSDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','W',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'Z',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_BCNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_BCNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','0',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'B',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_BCNDFN + MVL_MUXDFN + MVL_BUSDFN) :
		      case (MVL_BCNDFN + MVL_MXVDFN + MVL_BUSDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','M',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'T',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_BCNDFN + MVL_WORDFN + MVL_BUSDFN) :
		      case (MVL_BCNDFN + MVL_WRVDFN + MVL_BUSDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','W',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'T',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_XCNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_XCNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        losig_pnt = mvl_addlosig (MVL_LOFPNT,MVL_SIGIDX,'E','0',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        locon_pnt = mvl_addlocon (MVL_LOFPNT,losig_pnt,'X',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;
		      default :
		        mvl_error (5,sig_name);
		        local_err = 1;
		        break;
		      }

		    if (local_err == 0)
		      {
		      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_PNTDFN,
		                  (int)losig_pnt);
		      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_SIGDFN,
		                  sig_conf);
                      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_LFTDFN,
		                  mvl_y_pvt[-1].name.LEFT);
                      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_RGTDFN,
		                  mvl_y_pvt[-1].name.RIGHT);
		      MVL_CONCNT += sig_width;
		      MVL_SIGIDX += sig_width;
		      }
		    }

		  sig_list = sig_list->NEXT;
		  }
		freechain (MVL_NM1LST);
		MVL_NM1LST = NULL;
		} break;
case 37:
# line 536 "../struct/mvl_scomp.yac"
{
		/*   The following 3 lines reject tokens until the	*/
		/* sync. token ('Semicolon') is found		*/
 		do
		  mvl_y_char = mvl_y_lex ();
		while ((mvl_y_char != Semicolon) && (mvl_y_char != 0));
		mvl_y_errok;

		mvl_error (6,"");
		} break;
case 38:
# line 550 "../struct/mvl_scomp.yac"
{
            if(strcmp(IN_LO,"vbe") == 0)
              {
              MVL_Y_ACCEPT;
              }
            } break;
case 39:
# line 560 "../struct/mvl_scomp.yac"
{
		if (mvl_y_pvt[-1].text != MVL_MODNAM)
		  mvl_error (1,mvl_y_pvt[-1].text);
		} break;
case 40:
# line 570 "../struct/mvl_scomp.yac"
{
		if ((mvl_y_pvt[-1].text != NULL) && (mvl_y_pvt[-1].text != mvl_y_pvt[-10].text))
		  mvl_error (7,mvl_y_pvt[-1].text);
		} break;
case 41:
# line 576 "../struct/mvl_scomp.yac"
{ mvl_error (8,""); } break;
case 47:
# line 594 "../struct/mvl_scomp.yac"
{ mvl_error (9,""); } break;
case 48:
# line 605 "../struct/mvl_scomp.yac"
{
		struct losig *losig_pnt;
		int           sig_width;
		int           sig_conf;
		char         *sig_name;
		struct chain *sig_list;
		int           local_err;

		local_err = mvl_y_pvt[-2].name.ERR_FLG;
                if ((mvl_y_pvt[-2].name.LEFT==-1)&&((mvl_y_pvt[-3].valu==MVL_BTVDFN)||(mvl_y_pvt[-3].valu==MVL_RGVDFN)))
                  {
                  mvl_error (33,"");
                  }
		if (mvl_y_pvt[-2].name.LEFT <= mvl_y_pvt[-2].name.RIGHT)
		  sig_width = mvl_y_pvt[-2].name.RIGHT - mvl_y_pvt[-2].name.LEFT  + 1;
		else
		  sig_width = mvl_y_pvt[-2].name.LEFT  - mvl_y_pvt[-2].name.RIGHT + 1;

		sig_conf   = mvl_y_pvt[-3].valu + mvl_y_pvt[-1].valu;
		MVL_NM1LST = mvl_reverse (MVL_NM1LST);
		sig_list   = MVL_NM1LST;
		while ((sig_list != NULL) && (local_err == 0))
		  {
		  sig_name = (char *)sig_list->DATA;

		  if (mvl_chktab (MVL_HSHTAB,sig_name,MVL_MODNAM,
		                  MVL_SIGDFN) != 0)
		    mvl_error (10,sig_name);
		  else
		    {
		    switch (sig_conf)
		      {
		      case (MVL_BITDFN + MVL_NORDFN):
		      case (MVL_BTVDFN + MVL_NORDFN):
		        losig_pnt = mvl_addlosig(MVL_LOFPNT,MVL_SIGIDX,'I','0',
		                                 sig_name,mvl_y_pvt[-2].name.LEFT,mvl_y_pvt[-2].name.RIGHT);
		        break;

		      case (MVL_MUXDFN + MVL_BUSDFN):
		      case (MVL_MXVDFN + MVL_BUSDFN):
		        losig_pnt = mvl_addlosig(MVL_LOFPNT,MVL_SIGIDX,'I','M',
		                                 sig_name,mvl_y_pvt[-2].name.LEFT,mvl_y_pvt[-2].name.RIGHT);
		        break;

		      case (MVL_WORDFN + MVL_BUSDFN):
		      case (MVL_WRVDFN + MVL_BUSDFN):
		        losig_pnt = mvl_addlosig(MVL_LOFPNT,MVL_SIGIDX,'I','W',
		                                 sig_name,mvl_y_pvt[-2].name.LEFT,mvl_y_pvt[-2].name.RIGHT);
		        break;

		      default:
		        mvl_error (11,sig_name);
		        local_err = 1;
		        break;
		      }

		    if (local_err == 0)
		      {
		      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_PNTDFN,
		                  (int)losig_pnt);
		      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_SIGDFN,
		                  sig_conf);
                      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_LFTDFN,
		                  mvl_y_pvt[-2].name.LEFT);
                      mvl_addtab (MVL_HSHTAB,sig_name,MVL_MODNAM,MVL_RGTDFN,
		                  mvl_y_pvt[-2].name.RIGHT);
		      MVL_SIGIDX += sig_width;
		      }
		    }

		  sig_list = sig_list->NEXT;
		  }
		freechain (MVL_NM1LST);
		MVL_NM1LST = NULL;
		} break;
case 49:
# line 685 "../struct/mvl_scomp.yac"
{
		MVL_CHDNAM = mvl_y_pvt[-0].text;

		if (mvl_chktab (MVL_HSHTAB,MVL_CHDNAM,MVL_MODNAM,MVL_MODDFN) != 0)
		  {
		  mvl_error (12,MVL_CHDNAM);
		  MVL_CHDPNT = NULL;
		  }
		else
		  {
		  MVL_CHDHED = addlomodel (MVL_CHDHED,MVL_CHDNAM);

		  MVL_CHDPNT = MVL_CHDHED;
		  mvl_addtab (MVL_HSHTAB,MVL_CHDNAM,MVL_MODNAM,MVL_MODDFN,MVL_CHDDFN);
		  }
		} break;
case 50:
# line 705 "../struct/mvl_scomp.yac"
{
		if (MVL_CHDPNT != NULL)
		  {
		  mvl_addtab (MVL_HSHTAB,mvl_y_pvt[-5].text,MVL_MODNAM,MVL_CCNDFN,MVL_CONCNT);
		  MVL_LOFPNT->MODELCHAIN = addchain (MVL_LOFPNT->MODELCHAIN,mvl_y_pvt[-5].text);
		  }
		MVL_CONCNT = 0;
		} break;
case 56:
# line 744 "../struct/mvl_scomp.yac"
{
		struct locon *locon_pnt;
		int           sig_width;
		int           sig_conf;
		char         *sig_name;
		struct chain *sig_list;
		int           local_err = 0;

		if ((mvl_y_pvt[-1].name.ERR_FLG != 0) || (MVL_CHDPNT == NULL))
		  local_err = 1;

                if ((mvl_y_pvt[-1].name.LEFT==-1)&&((mvl_y_pvt[-2].valu==MVL_BTVDFN)||(mvl_y_pvt[-2].valu==MVL_MXVDFN)||(mvl_y_pvt[-2].valu==MVL_WRVDFN)))
                  {
                  mvl_error (33,"");
                  }
		if (mvl_y_pvt[-1].name.LEFT <= mvl_y_pvt[-1].name.RIGHT)
		  sig_width = mvl_y_pvt[-1].name.RIGHT - mvl_y_pvt[-1].name.LEFT  + 1;
		else
		  sig_width = mvl_y_pvt[-1].name.LEFT  - mvl_y_pvt[-1].name.RIGHT + 1;

		sig_conf   = mvl_y_pvt[-3].valu + mvl_y_pvt[-2].valu + mvl_y_pvt[-0].valu;
		MVL_NM1LST = mvl_reverse (MVL_NM1LST);
		sig_list   = MVL_NM1LST;
		while ((sig_list != NULL) && (local_err == 0))
		  {
		  sig_name = (char *)sig_list->DATA;
		  if (mvl_chktab (MVL_HSHTAB,sig_name,MVL_CHDNAM,
		                  MVL_SIGDFN) != 0)
		    mvl_error (4,sig_name);
		  else
		    {
		    switch (sig_conf)
		      {
		      case (MVL_ICNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_ICNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'I',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_OCNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_OCNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'O',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_OCNDFN + MVL_MUXDFN + MVL_BUSDFN) :
		      case (MVL_OCNDFN + MVL_MXVDFN + MVL_BUSDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'Z',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_OCNDFN + MVL_WORDFN + MVL_BUSDFN) :
		      case (MVL_OCNDFN + MVL_WRVDFN + MVL_BUSDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'Z',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_BCNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_BCNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'B',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_BCNDFN + MVL_MUXDFN + MVL_BUSDFN) :
		      case (MVL_BCNDFN + MVL_MXVDFN + MVL_BUSDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'T',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_BCNDFN + MVL_WORDFN + MVL_BUSDFN) :
		      case (MVL_BCNDFN + MVL_WRVDFN + MVL_BUSDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'T',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      case (MVL_XCNDFN + MVL_BITDFN + MVL_NORDFN) :
		      case (MVL_XCNDFN + MVL_BTVDFN + MVL_NORDFN) :
		        locon_pnt = mvl_addlocon (MVL_CHDPNT,NULL,'X',
		                                  sig_name,mvl_y_pvt[-1].name.LEFT,mvl_y_pvt[-1].name.RIGHT);
		        break;

		      default :
		        mvl_error (5,sig_name);
		        local_err = 1;
		        break;
		      }

		    if (local_err == 0)
		      {
		      mvl_addtab (MVL_HSHTAB,MVL_CONCNT,MVL_CHDNAM,MVL_PNTDFN,
		                  sig_name);
		      mvl_addtab (MVL_HSHTAB,sig_name,  MVL_CHDNAM,MVL_SIGDFN,
		                  sig_conf);
		      mvl_addtab (MVL_HSHTAB,sig_name,  MVL_CHDNAM,MVL_RNGDFN,
		                  MVL_CONCNT);
		      mvl_addtab (MVL_HSHTAB,sig_name,  MVL_CHDNAM,MVL_LFTDFN,
		                  mvl_y_pvt[-1].name.LEFT);
		      mvl_addtab (MVL_HSHTAB,sig_name,  MVL_CHDNAM,MVL_RGTDFN,
		                  mvl_y_pvt[-1].name.RIGHT);
		      MVL_CONCNT += sig_width;
		      }
		    }
		  sig_list = sig_list->NEXT;
		  }
		freechain (MVL_NM1LST);
		MVL_NM1LST = NULL;
		} break;
case 57:
# line 852 "../struct/mvl_scomp.yac"
{
		/*   The following 3 lines reject tokens until the	*/
		/* sync. token ('Semicolon') is found			*/
		do
		  mvl_y_char = mvl_y_lex ();
		while ((mvl_y_char != Semicolon) && (mvl_y_char != 0));
		mvl_y_errok;

		mvl_error (6,"");
		} break;
case 62:
# line 878 "../struct/mvl_scomp.yac"
{
		mvl_error (18,"");
		} break;
case 63:
# line 886 "../struct/mvl_scomp.yac"
{
		int con_count;
		int local_err = 0;

		MVL_CONRNK = 0;
		MVL_CHDNAM = mvl_y_pvt[-0].text;
                MVL_LOCNAM = mvl_y_pvt[-1].text;
                /* Verifying the component has been declared before */
		if (mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-1].text,MVL_MODNAM,MVL_LBLDFN) != 0)
		  {
		  mvl_error (13,mvl_y_pvt[-1].text);
		  local_err = 1;
		  }

		if (mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].text,MVL_MODNAM,
		                MVL_MODDFN) != MVL_CHDDFN)
		  {
		  mvl_error (14,mvl_y_pvt[-0].text);
		  local_err = 1;
		  }

		if (local_err == 0)
		  {
		  mvl_addtab (MVL_HSHTAB,mvl_y_pvt[-1].text,MVL_MODNAM,MVL_LBLDFN,1);
		  con_count  = mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].text,MVL_MODNAM,MVL_CCNDFN);
		  MVL_NM1LST = NULL;
		  while (con_count != 0)
		    {
		    MVL_NM1LST = addchain (MVL_NM1LST,NULL);
		    con_count--;
		    }
		  MVL_CHDPNT = MVL_CHDHED;
		  while (MVL_CHDPNT != NULL)
		    {
		    if (MVL_CHDPNT->NAME == mvl_y_pvt[-0].text)
		      break;
		    MVL_CHDPNT = MVL_CHDPNT->NEXT;
		    }
		  }
		else
		  MVL_CHDPNT = NULL;
		} break;
case 64:
# line 930 "../struct/mvl_scomp.yac"
{
		struct loins *loins_pnt;
/* Restored 19/12/91 VHN belong to original file */
                struct chain *chain_pnt;
                char         *prt_name;
                int           i=0;

                chain_pnt  = MVL_NM1LST;


                while (chain_pnt != NULL)
                  {
                  if (chain_pnt->DATA == NULL)
                    {
                    prt_name  = (char *) mvl_chktab (MVL_HSHTAB,i,
                                                     MVL_CHDNAM,MVL_PNTDFN);
                    mvl_error (42,prt_name);
                    break;
                    }
                  i++;
                  chain_pnt = chain_pnt->NEXT;
                  }
/*----------------- End of the restoring ----*/
		
		MVL_NM1LST = mvl_reverse (MVL_NM1LST);
		if ((MVL_CHDPNT != NULL) 
                   && (MVL_ERRFLG ==0) && (mvl_y_errflag == 0))
		  loins_pnt = addloins (MVL_LOFPNT,mvl_y_pvt[-4].text,MVL_CHDPNT,MVL_NM1LST,
		                        NULL);
		freechain (MVL_NM1LST);
		MVL_NM1LST = NULL;
		MVL_SIMFLG = MVL_UKNDFN;
		} break;
case 71:
# line 994 "../struct/mvl_scomp.yac"
{
		int           sig_width;
		int           con_pos;
		struct chain *sig_list1;
		struct chain *sig_list2;
		int           local_err = 0;

		if (MVL_CHDPNT == NULL)
		  local_err = 1;
		sig_list1 = MVL_NM1LST;

		if (MVL_SIMFLG == MVL_IMPDFN)
		  sig_list1 = MVL_NM2LST;
		MVL_SIMFLG = MVL_EXPDFN;

		if (mvl_y_pvt[-2].name.LEFT <= mvl_y_pvt[-2].name.RIGHT)
		  sig_width = mvl_y_pvt[-2].name.RIGHT - mvl_y_pvt[-2].name.LEFT + 1;
		else
		  sig_width = mvl_y_pvt[-2].name.LEFT - mvl_y_pvt[-2].name.RIGHT + 1;

		if (local_err == 0)
		  {
		  if (sig_width != mvl_y_pvt[-0].expr.WIDTH)
		    mvl_error (38,"");
		  else
		    {
                    if((MVL_ERRFLG == 0) && (mvl_y_errflag == 0))
                      { 
		      con_pos = mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-2].name.NAME,MVL_CHDNAM,
		                            MVL_RNGDFN);
		      while (con_pos != 0)
		        {
		        sig_list1 = sig_list1->NEXT;
		        con_pos--;
		        }
		      sig_list2 = mvl_y_pvt[-0].expr.LIST;
		      while (sig_list2 != NULL)
		        {
		        if (sig_list1->DATA != NULL)
		          {
		          mvl_error (41,mvl_y_pvt[-2].name.NAME);
		          break;
		          }
		        sig_list1->DATA = sig_list2->DATA;
		        sig_list2       = sig_list2->NEXT;
		        sig_list1       = sig_list1->NEXT;
		        }
                      } 
		    }
		  }
		freechain (mvl_y_pvt[-0].expr.LIST);
		} break;
case 72:
# line 1047 "../struct/mvl_scomp.yac"
{
		int           sig_width;
		struct chain *sig_list1;
		char         *prt_name;
		int           prt_width;
		int           left_bnd;
		int           right_bnd;
		int           local_err = 0;
                int           i;

		if (MVL_CHDPNT == NULL)
		  local_err = 1;

		if (MVL_SIMFLG == MVL_UKNDFN)
		  {
		  MVL_SIMFLG = MVL_IMPDFN;
		  MVL_NM2LST = MVL_NM1LST;
		  }
		if (MVL_SIMFLG != MVL_IMPDFN)
		  {
		  mvl_error (15,"");
		  local_err = 1;
		  }

		prt_name  = (char *) mvl_chktab (MVL_HSHTAB,MVL_CONRNK,
		                                 MVL_CHDNAM,MVL_PNTDFN);
                if(prt_name == NULL)
                {
                local_err = 1;
                mvl_error(76,MVL_LOCNAM);
                }
		right_bnd = mvl_chktab (MVL_HSHTAB,prt_name,MVL_CHDNAM,
		                        MVL_LFTDFN);
		left_bnd  = mvl_chktab (MVL_HSHTAB,prt_name,MVL_CHDNAM,
		                        MVL_RGTDFN);

		if (left_bnd <= right_bnd)
                  prt_width = right_bnd - left_bnd  + 1;
		else
                  prt_width = left_bnd  - right_bnd + 1;

		if (local_err == 0)
		  {
		  if (prt_width != mvl_y_pvt[-0].expr.WIDTH)
                    {
		    mvl_error (38,"");
/* Attention difference avec le texte original VUONG H. N. 19/12/1991 */
/* Restored */
                    for(i=0;i<prt_width;i++)
                      MVL_NM2LST = MVL_NM2LST->NEXT;
/* end restored beware of i declared up */
                    }
		  else
		    {
		    sig_list1 = mvl_y_pvt[-0].expr.LIST;
		    while (sig_list1 != NULL)
		      {
		      MVL_NM2LST->DATA = sig_list1->DATA;
		      sig_list1        = sig_list1->NEXT;
		      MVL_NM2LST       = MVL_NM2LST->NEXT;
		      }
		    }
		  MVL_CONRNK += prt_width;
		  }
		freechain (mvl_y_pvt[-0].expr.LIST);
		} break;
case 73:
# line 1114 "../struct/mvl_scomp.yac"
{
		/*   The following 3 lines reject tokens until the	*/
		/* sync. token ('Comma') is found			*/
		do
		  mvl_y_char = mvl_y_lex ();
		while ((mvl_y_char != Comma) && (mvl_y_char != 0));
		mvl_y_errok;

		MVL_CONRNK++;
		mvl_error (31,"");
		} break;
case 74:
# line 1129 "../struct/mvl_scomp.yac"
{
		if (MVL_CHDPNT != NULL)
		  {
		  if (mvl_chktab(MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_CHDNAM,MVL_SIGDFN) != 0)
		    {
                    mvl_y_val.name.LEFT  = mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_CHDNAM,
		                           MVL_LFTDFN);
                    mvl_y_val.name.RIGHT = mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_CHDNAM,
		                           MVL_RGTDFN);
		    }
		  else
		    {
		    mvl_error (16,mvl_y_pvt[-0].name.NAME);
		    mvl_y_val.name = mvl_y_pvt[-0].name;
		    }
		  }
		else
		  mvl_y_val.name = mvl_y_pvt[-0].name;
		} break;
case 75:
# line 1152 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; 
                } break;
case 76:
# line 1158 "../struct/mvl_scomp.yac"
{
                mvl_y_val.name.NAME  = mvl_y_pvt[-0].text;
  		mvl_y_val.name.LEFT  = -1;
  		mvl_y_val.name.RIGHT = -1;
                } break;
case 77:
# line 1164 "../struct/mvl_scomp.yac"
{ mvl_y_val.name = mvl_y_pvt[-0].name; } break;
case 78:
# line 1166 "../struct/mvl_scomp.yac"
{ mvl_y_val.name = mvl_y_pvt[-0].name; } break;
case 79:
# line 1174 "../struct/mvl_scomp.yac"
{
                mvl_y_val.name.NAME  = mvl_y_pvt[-3].text;
                mvl_y_val.name.LEFT  = mvl_y_pvt[-1].valu;
                mvl_y_val.name.RIGHT = mvl_y_pvt[-1].valu;
                } break;
case 80:
# line 1184 "../struct/mvl_scomp.yac"
{
                mvl_y_val.name.NAME  = mvl_y_pvt[-1].text;
                mvl_y_val.name.LEFT  = mvl_y_pvt[-0].name.LEFT;
                mvl_y_val.name.RIGHT = mvl_y_pvt[-0].name.RIGHT;
                } break;
case 81:
# line 1194 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; 
                 } break;
case 82:
# line 1200 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; 
                } break;
case 83:
# line 1206 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; 
                } break;
case 84:
# line 1212 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; } break;
case 85:
# line 1216 "../struct/mvl_scomp.yac"
{
		struct chain *list1;

		list1 = mvl_y_pvt[-2].expr.LIST;
		while (list1->NEXT != NULL)
		  list1 = list1->NEXT;

		list1->NEXT = mvl_y_pvt[-0].expr.LIST;
		mvl_y_val.expr.LIST     = mvl_y_pvt[-2].expr.LIST;
		mvl_y_val.expr.WIDTH    = mvl_y_pvt[-2].expr.WIDTH + mvl_y_pvt[-0].expr.WIDTH;
                } break;
case 86:
# line 1232 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; } break;
case 87:
# line 1238 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; } break;
case 88:
# line 1243 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; } break;
case 89:
# line 1245 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-0].expr; } break;
case 90:
# line 1247 "../struct/mvl_scomp.yac"
{
		mvl_expr      expr;
		struct losig *losig_pnt;
		int           i;
		int           left;
		int           right;
		int           left_bnd;
		int           right_bnd;
		int           sig_width;
		int           rev_flg;
		int           in_bound;
		int           out_bound;

		if (mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_MODNAM,MVL_SIGDFN) != 0)
		  {
  		  left_bnd  = mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_MODNAM,
		                          MVL_LFTDFN);
  		  right_bnd = mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_MODNAM,
		                          MVL_RGTDFN);

		  if (mvl_y_pvt[-0].name.LEFT == -1)
		    {
		    left  = left_bnd;
		    right = right_bnd;
		    }
		  else
		    {
		    left  = mvl_y_pvt[-0].name.LEFT;
		    right = mvl_y_pvt[-0].name.RIGHT;
		    }

		  if (left_bnd <= right_bnd)
		    {
		    sig_width = right_bnd - left_bnd + 1;
		    if (left <= right)
		      {
		      expr.WIDTH   = right - left + 1;
		      rev_flg    = 0;
		      in_bound   = right_bnd - right;
		      out_bound  = right_bnd - left;
		      if ((left < left_bnd) || (right > right_bnd))
		        mvl_error (36,mvl_y_pvt[-0].name.NAME);
		      }
		    else
		      {
		      expr.WIDTH   = left - right + 1;
		      rev_flg    = 1;
		      in_bound   = right_bnd - left;
		      out_bound  = right_bnd - right;
		      if ((left > right_bnd) || (right < left_bnd))
		        mvl_error (36,mvl_y_pvt[-0].name.NAME);
		      }
		    }
		  else
		    {
		    sig_width = left_bnd - right_bnd + 1;
		    if (left <= right)
		      {
		      expr.WIDTH   = right - left + 1;
		      rev_flg    = 1;
		      in_bound   = left  - right_bnd;
		      out_bound  = right - right_bnd;
		      if ((left < right_bnd) || (right > left_bnd))
		        mvl_error (36,mvl_y_pvt[-0].name.NAME);
		      }
		    else
		      {
		      expr.WIDTH   = left - right + 1;
		      rev_flg    = 0;
		      in_bound   = right - right_bnd;
		      out_bound  = left  - right_bnd;
		      if ((left > left_bnd) || (right < right_bnd))
		        mvl_error (36,mvl_y_pvt[-0].name.NAME);
		      }
		    }

    		  losig_pnt = (struct losig *)
		              mvl_chktab (MVL_HSHTAB,mvl_y_pvt[-0].name.NAME,MVL_MODNAM,
		                          MVL_PNTDFN);
		  expr.LIST = NULL;
		  for (i=0 ; i<sig_width ; i++)
		    {
		    if (i >= in_bound)
		      expr.LIST = addchain (expr.LIST,losig_pnt);
		    if (i >= out_bound)
		      break;
		    losig_pnt = losig_pnt->NEXT;
		    }
		  if (rev_flg == 1)
		    expr.LIST = mvl_reverse (expr.LIST);
		  }
		else
		  {
		  mvl_error(17,mvl_y_pvt[-0].name.NAME);
		  expr.WIDTH = 1;
		  expr.LIST  = addchain (NULL,NULL);
		  }
		mvl_y_val.expr = expr;
		} break;
case 91:
# line 1352 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-1].expr; } break;
case 92:
# line 1360 "../struct/mvl_scomp.yac"
{ mvl_y_val.expr = mvl_y_pvt[-1].expr; } break;
case 95:
# line 1371 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_ICNDFN; } break;
case 96:
# line 1373 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_ICNDFN; } break;
case 97:
# line 1375 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_OCNDFN; } break;
case 98:
# line 1377 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_BCNDFN; } break;
case 99:
# line 1379 "../struct/mvl_scomp.yac"
{
                /* Print consistency check will be desabled
		mvl_warning (2,"");
                ------- */
		mvl_y_val.valu = MVL_XCNDFN;
		} break;
case 100:
# line 1389 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_ICNDFN; } break;
case 101:
# line 1391 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_ICNDFN; } break;
case 102:
# line 1393 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_OCNDFN; } break;
case 103:
# line 1395 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_BCNDFN; } break;
case 104:
# line 1397 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_XCNDFN; } break;
case 105:
# line 1402 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_BITDFN; } break;
case 106:
# line 1404 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_WORDFN; } break;
case 107:
# line 1406 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_MUXDFN; } break;
case 108:
# line 1408 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_BTVDFN; } break;
case 109:
# line 1410 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_WRVDFN; } break;
case 110:
# line 1412 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_MXVDFN; } break;
case 113:
# line 1419 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_NORDFN; } break;
case 114:
# line 1421 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = MVL_BUSDFN; } break;
case 115:
# line 1426 "../struct/mvl_scomp.yac"
{ 
                if(MVL_GENFLG != 1)
                  MVL_NM1LST = addchain (MVL_NM1LST,mvl_y_pvt[-0].text); 
                } break;
case 118:
# line 1438 "../struct/mvl_scomp.yac"
{ 
                if(MVL_GENFLG != 1)
                  MVL_NM1LST = addchain (MVL_NM1LST,mvl_y_pvt[-0].text); 
                } break;
case 119:
# line 1447 "../struct/mvl_scomp.yac"
{ mvl_y_val.text = mvl_y_pvt[-1].text; 
                } break;
case 120:
# line 1453 "../struct/mvl_scomp.yac"
{ mvl_y_val.text = NULL; } break;
case 121:
# line 1455 "../struct/mvl_scomp.yac"
{ mvl_y_val.text = mvl_y_pvt[-0].text; } break;
case 122:
# line 1460 "../struct/mvl_scomp.yac"
{ mvl_y_val.text = mvl_y_pvt[-0].text; } break;
case 123:
# line 1465 "../struct/mvl_scomp.yac"
{ mvl_y_errok; } break;
case 124:
# line 1470 "../struct/mvl_scomp.yac"
{ mvl_y_val.valu = atoi (mvl_y_pvt[-0].valu); } break;
case 125:
# line 1475 "../struct/mvl_scomp.yac"
{ mvl_y_errok; } break;
case 126:
# line 1480 "../struct/mvl_scomp.yac"
{ mvl_y_errok; } break;
	}
	goto mvl_y_stack;		/* reset registers in driver code */
}
