/******************************************************************************/
/*                                                                            */
/* This file is part of the sources of the masi-cao&vlsi cad tools            */
/*              version 2.0                                                   */
/*                                                                            */
/* version 1.0 was develloped by Edmond Janssen & Eric Playe, in june 1991,   */
/*             under the supervision of Frederic Petrot                       */
/*                                                                            */
/* version 2.0 is basically a version 1.0 extension written in august 1991    */
/*             by Frederic Petrot                                             */
/*                                                                            */
/* Please report the bugs at e-mail : cao-vlsi@masi.ibp.fr                    */
/*                                                                            */
/* File : mrglayer.c                                                          */
/*                                                                            */
/******************************************************************************/
#include <stdio.h>
#include "mrgltypes.h"
#include MUT_H
#include MPH_H

int sort_fct(X, Y)
lambda *X;
lambda *Y;
{
	return *X - *Y;
}

unit reduce(Array, Length)
lambda Array[];
unit	Length;
{
register unit I = 0, J = 1;

	do {
		if (J >= Length)
			return Length;
	} while (Array[I++] != Array[J++]);
	do {
		if (Array[I] == Array[J])
			J++;
		else
			Array[I++] = Array[J++];
	} while (J < Length);
	return I;
}

void note_X_and_Y(X, NumOfX, Y, NumOfY, HeadOfRectsLst)
lambda		X[];
unit	  *NumOfX;
lambda		Y[];
unit	  *NumOfY;
rect_link *HeadOfRectsLst;
{
register rect_link *RectLinkPtr;
register unit		 I = 0;

	for (RectLinkPtr = HeadOfRectsLst; RectLinkPtr != NULL; RectLinkPtr = RectLinkPtr->NEXT) {
		X[I]	= RectLinkPtr->X0;
		Y[I++] = RectLinkPtr->Y0;
		X[I]	= RectLinkPtr->X1;
		Y[I++] = RectLinkPtr->Y1;
	}
	qsort(X, *NumOfX, sizeof(lambda), sort_fct);
	qsort(Y, *NumOfY, sizeof(lambda), sort_fct);
	*NumOfX = reduce(X, *NumOfX);
	*NumOfY = reduce(Y, *NumOfY);
}

void note_clusters(Cluster, Tile, X, NumOfX, Y, NumOfY, HeadOfRectsLst)
cluster	 Cluster[];
int		Tile[];
lambda		X[];
unit		NumOfX;
lambda		Y[];
unit		NumOfY;
rect_link *HeadOfRectsLst;
{
#define TILE(I, J) (Tile[ (I) + (J) * NumOfX])

register rect_link *RectLinkPtr, *FreeRectLink;
register unit		 I, J, K, L;
unit		 Iref, Jref;

	K = 1;
	RectLinkPtr = HeadOfRectsLst;
	while (RectLinkPtr != NULL) {
		Iref = (unit *)bsearch(&RectLinkPtr->X0, X, NumOfX, sizeof(lambda), sort_fct) - X;
		Jref = (unit *)bsearch(&RectLinkPtr->Y0, Y, NumOfY, sizeof(lambda), sort_fct) - Y;
		Cluster[K].Iref = Iref;
		Cluster[K].Jref = Jref;
		for (I = Iref; X[I] < RectLinkPtr->X1; I++) {
			for (J = Jref; Y[J] < RectLinkPtr->Y1; J++) {
		 if (L = TILE(I, J)) {
			 while (Cluster[L].MERGED)
				 L = Cluster[L].MERGED;
			 if (L != K)
				 Cluster[L].MERGED = K;
		 }
		 TILE(I, J) = K;
			}		/* for about J */
		}	/* for about I */
		FreeRectLink = RectLinkPtr;
		RectLinkPtr = RectLinkPtr->NEXT;
		free(FreeRectLink);
		K++;
	}	/* while about RectLinkPtr */
}

int note_point(ChainOfPoints, X, Y)
points_chain *ChainOfPoints;
lambda			X;
lambda			Y;
{
register point_link *Auxiliary;

	Auxiliary = (point_link *)malloc(sizeof(point_link));
	Auxiliary->X = X;
	Auxiliary->Y = Y;
	if ((*ChainOfPoints).START == NULL) {
		(*ChainOfPoints).START = (*ChainOfPoints).END = Auxiliary;
		return 1;
	} else {
		(*ChainOfPoints).END = (*ChainOfPoints).END->NEXT = Auxiliary;
		return((*ChainOfPoints).START->X != X) || ((*ChainOfPoints).START->Y != Y);
	}
}

void add_path(TopOfPathsStack, Path)
path_link **TopOfPathsStack;
point_link *Path;
{
register path_link *Auxiliary;

	Auxiliary = (path_link *)malloc(sizeof(path_link));
	Auxiliary->PATH = Path;
	Auxiliary->NEXT = *TopOfPathsStack;
	*TopOfPathsStack = Auxiliary;
}

path_link *note_paths(Cluster, Tile, X, NumOfX, Y, NumOfRects)
cluster Cluster[];
int	Tile[];
lambda	X[];
unit	NumOfX;
lambda	Y[];
unit	NumOfRects;
{
#define TILE(I, J) (Tile[ (I) + (J) * NumOfX])

register unit			I, J;
unit			K;
int			Direction;
int			PathNotClosed;
points_chain ChainOfPoints;
path_link	*StackOfPaths = NULL;

	for (K = NumOfRects; K; K--) {
		if (!Cluster[K].MERGED) {
			I = Cluster[K].Iref;
			J = Cluster[K].Jref;
			ChainOfPoints.START = NULL;
			while (TILE(I, J-1))
		 		J--;
			Direction = EAST;
			PathNotClosed = 1;
			while (PathNotClosed) {
		 switch (Direction) {
			 case NORTH :
				 while (!TILE(I+1, J) && TILE(I, J+1))
			  J++;
				 if (TILE(I+1, J)) {
			  PathNotClosed = note_point(&ChainOfPoints, X[I+1], Y[J]);
			  Direction = EAST;
			  I++;
				 } else {
			  PathNotClosed = note_point(&ChainOfPoints, X[I+1], Y[J+1]);
			  if (!PathNotClosed)
				  break;
			  if (TILE(I-1, J)) {
				  Direction = WEST;
				  I--;
			  } else {
				  PathNotClosed = note_point(&ChainOfPoints, X[I], Y[J+1]);
				  Direction = SOUTH;
				  J--;
			  }
				 }
				 break;
			 case WEST :
				 while (!TILE(I, J+1) && TILE(I-1, J))
			  I--;
				 if (TILE(I, J+1)) {
			  PathNotClosed = note_point(&ChainOfPoints, X[I+1], Y[J+1]);
			  Direction = NORTH;
			  J++;
				 } else {
			  PathNotClosed = note_point(&ChainOfPoints, X[I], Y[J+1]);
			  if (!PathNotClosed)
				  break;
			  if (TILE(I, J-1)) {
				  Direction = SOUTH;
				  J--;
			  } else {
				  PathNotClosed = note_point(&ChainOfPoints, X[I], Y[J]);
				  Direction = EAST;
				  I++;
			  }
				 }
				 break;
			 case SOUTH :
				 while (!TILE(I-1, J) && TILE(I, J-1))
			  J--;
				 if (TILE(I-1, J)) {
			  PathNotClosed = note_point(&ChainOfPoints, X[I], Y[J+1]);
			  Direction = WEST;
			  I--;
				 } else {
			  PathNotClosed = note_point(&ChainOfPoints, X[I], Y[J]);
			  if (!PathNotClosed)
				  break;
			  if (TILE(I+1, J)) {
				  Direction = EAST;
				  I++;
			  } else {
				  PathNotClosed = note_point(&ChainOfPoints, X[I+1], Y[J]);
				  Direction = NORTH;
				  J++;
			  }
				 }
				 break;
			 case EAST :
				 while (!TILE(I, J-1) && TILE(I+1, J))
			  I++;
				 if (TILE(I, J-1)) {
			  PathNotClosed = note_point(&ChainOfPoints, X[I], Y[J]);
			  Direction = SOUTH;
			  J--;
				 } else {
			  PathNotClosed = note_point(&ChainOfPoints, X[I+1], Y[J]);
			  if (!PathNotClosed)
				  break;
			  if (TILE(I, J+1)) {
				  Direction = NORTH;
				  J++;
			  } else {
				  PathNotClosed = note_point(&ChainOfPoints, X[I+1], Y[J+1]);
				  Direction = WEST;
				  I--;
				  if (!TILE(I, J)) {
				note_point(&ChainOfPoints, X[I+1], Y[J+1]);
				note_point(&ChainOfPoints, X[I+1], Y[J]);
				PathNotClosed = note_point(&ChainOfPoints, X[I+2], Y[J]);
				  }
			  }
				 }
				 break;
		 }	/* switch about Direction */
			}		/* while about PathNotClosed */
			ChainOfPoints.END->NEXT = NULL;
			add_path(&StackOfPaths, ChainOfPoints.START);
		}	/* if about Cluster[K].MERGED */
	}	/* for about K */
	return StackOfPaths;
}

path_link *merge_layer(ListOfRects, NumOfRects)
rect_link *ListOfRects;
unit		NumOfRects;
{
unit		NumOfX, NumOfY;
lambda	  *X, *Y;
int	  *Tile;
cluster	  *Cluster;
path_link *PathsList;

	NumOfX = NumOfY = NumOfRects << 1;
	X = (lambda *)malloc(NumOfX * sizeof(lambda));
	Y = (lambda *)malloc(NumOfY * sizeof(lambda));
	note_X_and_Y(X, &NumOfX, Y, &NumOfY, ListOfRects);

	Tile = (int *)calloc((NumOfX+1) * (NumOfY+1), sizeof(int));
	Tile += NumOfX;
	Cluster = (cluster *)calloc(NumOfRects + 1, sizeof(cluster));
	note_clusters(Cluster, Tile, X, NumOfX, Y, NumOfY, ListOfRects);

	PathsList = note_paths(Cluster, Tile, X, NumOfX, Y, NumOfRects);

	free(Cluster);
	Tile -= NumOfX;
	free(Tile);
	free(Y);
	free(Y);

	return PathsList;
}
